/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Locale;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Numbers;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.validation.validator.RangeValidator;

public class NumberTextField<N extends Number>
extends TextField<N> {
    private static final long serialVersionUID = 1L;
    private RangeValidator<N> validator = null;
    private N minimum = null;
    private N maximum = null;

    public NumberTextField(String id) {
        this(id, (IModel<N>)null);
    }

    public NumberTextField(String id, IModel<N> model) {
        this(id, model, (Class<N>)null);
    }

    public NumberTextField(String id, IModel<N> model, Class<N> type) {
        super(id, model, type);
    }

    public NumberTextField<N> setMinimum(N minimum) {
        this.minimum = minimum;
        return this;
    }

    public NumberTextField<N> setMaximum(N maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public void onConfigure() {
        super.onConfigure();
        if (this.validator != null) {
            this.remove(this.validator);
        }
        this.validator = new RangeValidator<Comparable>((Comparable)this.getMinValue(), (Comparable)this.getMaxValue());
        this.add(this.validator);
    }

    private N getMinValue() {
        Object result;
        if (this.minimum != null) {
            result = this.minimum;
        } else {
            Class<N> numberType = this.getNumberType();
            result = Numbers.getMinValue(numberType);
        }
        return result;
    }

    private N getMaxValue() {
        Object result;
        if (this.maximum != null) {
            result = this.maximum;
        } else {
            Class<N> numberType = this.getNumberType();
            result = Numbers.getMaxValue(numberType);
        }
        return result;
    }

    private Class<N> getNumberType() {
        Class<Object> numberType = this.getType();
        if (numberType == null && this.getModelObject() != null) {
            numberType = ((Number)this.getModelObject()).getClass();
        }
        return numberType;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        IValueMap attributes = tag.getAttributes();
        if (this.minimum != null) {
            attributes.put((Object)"min", (Object)Objects.stringValue(this.minimum));
        } else {
            attributes.remove((Object)"min");
        }
        if (this.maximum != null) {
            attributes.put((Object)"max", (Object)Objects.stringValue(this.maximum));
        } else {
            attributes.remove((Object)"max");
        }
    }

    @Override
    protected String getInputType() {
        return "number";
    }

    @Override
    protected String getModelValue() {
        Number value = (Number)this.getModelObject();
        if (value == null) {
            return "";
        }
        return Objects.stringValue((Object)value);
    }

    @Override
    protected void convertInput() {
        IConverter<N> converter = this.getConverter(this.getNumberType());
        try {
            this.setConvertedInput(converter.convertToObject(this.getInput(), Locale.ENGLISH));
        }
        catch (ConversionException e) {
            this.error(this.newValidationError(e));
        }
    }
}

