/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.DynamicPersistenceCapable;
import org.apache.openjpa.enhance.FieldManager;
import org.apache.openjpa.enhance.ManagedInstanceProvider;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.ClearFieldManager;
import org.apache.openjpa.kernel.DetachManager;
import org.apache.openjpa.kernel.ENonTransState;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.ObjectIdStateManager;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.PNewState;
import org.apache.openjpa.kernel.SaveFieldManager;
import org.apache.openjpa.kernel.SavepointFieldManager;
import org.apache.openjpa.kernel.SingleFieldManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FetchGroup;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.ObjectNotFoundException;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.ProxyManager;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.UserException;

public class StateManagerImpl
implements OpenJPAStateManager,
Serializable {
    public static final int LOAD_FGS = 0;
    public static final int LOAD_ALL = 1;
    public static final int LOAD_SERIALIZE = 2;
    private static final int FLAG_SAVE = 2;
    private static final int FLAG_DEREF = 4;
    private static final int FLAG_LOADED = 8;
    private static final int FLAG_READ_LOCKED = 16;
    private static final int FLAG_WRITE_LOCKED = 32;
    private static final int FLAG_OID_ASSIGNED = 64;
    private static final int FLAG_LOADING = 128;
    private static final int FLAG_PRE_DELETING = 256;
    private static final int FLAG_FLUSHED = 512;
    private static final int FLAG_PRE_FLUSHED = 1024;
    private static final int FLAG_FLUSHED_DIRTY = 2048;
    private static final int FLAG_IMPL_CACHE = 4096;
    private static final int FLAG_INVERSES = 8192;
    private static final int FLAG_NO_UNPROXY = 16384;
    private static final int FLAG_VERSION_CHECK = 32768;
    private static final int FLAG_VERSION_UPDATE = 65536;
    private static final int FLAG_DETACHING = 131072;
    private static final int FLAG_EMBED_DEREF = 262144;
    private static final Localizer _loc = Localizer.forPackage(StateManagerImpl.class);
    private transient PersistenceCapable _pc = null;
    protected transient ClassMetaData _meta = null;
    protected BitSet _loaded = null;
    private BitSet _dirty = null;
    private BitSet _flush = null;
    private BitSet _delayed = null;
    private int _flags = 0;
    private Object _id = null;
    private Object _oid = null;
    private transient BrokerImpl _broker;
    protected PCState _state = PCState.TRANSIENT;
    private Object _version = null;
    private Object _loadVersion = null;
    private Object _lock = null;
    private int _readLockLevel = -1;
    private int _writeLockLevel = -1;
    private SingleFieldManager _single = null;
    private SaveFieldManager _saved = null;
    private FieldManager _fm = null;
    private Object _impl = null;
    protected Object[] _fieldImpl = null;
    private StateManagerImpl _owner = null;
    private Object _ownerId = null;
    private int _ownerIndex = -1;
    private List<FieldMetaData> _mappedByIdFields = null;
    private transient ReentrantLock _instanceLock = null;
    private boolean postLoadCallback = true;

    protected StateManagerImpl(Object id, ClassMetaData meta, BrokerImpl broker) {
        this._id = id;
        this._meta = meta;
        this._broker = broker;
        this._single = new SingleFieldManager(this, broker);
        if (broker.getMultithreaded()) {
            this._instanceLock = new ReentrantLock();
        }
        if (this._meta.getIdentityType() == 0 && !this._meta.isEmbeddable()) {
            throw new UserException(_loc.get("meta-unknownid", this._meta));
        }
    }

    public StateManagerImpl(StateManagerImpl sm) {
        this(sm, sm.getPCState());
    }

    public StateManagerImpl(StateManagerImpl sm, PCState newState) {
        this(sm.getId(), sm.getMetaData(), sm.getBroker());
        PersistenceCapable origPC = sm.getPersistenceCapable();
        this._pc = origPC.pcNewInstance(sm, false);
        int[] fields = new int[sm.getMetaData().getFields().length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = i;
        }
        this._pc.pcCopyFields(origPC, fields);
        this._pc.pcReplaceStateManager(this);
        this._state = newState;
        this._dirty = (BitSet)sm.getDirty().clone();
        this._loaded = (BitSet)sm.getLoaded().clone();
        this._flush = (BitSet)sm.getFlushed().clone();
        this._version = sm.getVersion();
        this._oid = sm.getObjectId();
        this._id = sm.getId();
    }

    void setOwner(StateManagerImpl owner, ValueMetaData ownerMeta) {
        this._owner = owner;
        this._ownerIndex = ownerMeta.getFieldMetaData().getIndex();
    }

    boolean isLoading() {
        return (this._flags & 0x80) > 0;
    }

    void setLoading(boolean loading) {
        this._flags = loading ? (this._flags |= 0x80) : (this._flags &= 0xFFFFFF7F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPCState(PCState state) {
        if (this._state == state) {
            return;
        }
        PCState prev = this._state;
        this.lock();
        try {
            this._broker.getStoreManager().beforeStateChange(this, this._state, state);
            boolean wasDeleted = this._state.isDeleted();
            boolean wasDirty = this._state.isDirty();
            boolean wasPending = this._state.isPendingTransactional();
            this._state = state;
            if (this._state.isTransactional()) {
                this._broker.addToTransaction(this);
                if (this._state.isDeleted() != wasDeleted) {
                    this._broker.setDirty(this, !wasDirty || this.isFlushed());
                } else if (this._state.isDirty() && !wasDirty) {
                    this._broker.setDirty(this, true);
                }
            } else if (!wasPending && this._state.isPendingTransactional()) {
                this._broker.addToPendingTransaction(this);
            } else if (wasPending && !this._state.isPendingTransactional()) {
                this._broker.removeFromPendingTransaction(this);
            } else {
                this._broker.removeFromTransaction(this);
            }
            this._state.initialize(this, prev);
            if (this._state.isDeleted() && !wasDeleted) {
                this.fireLifecycleEvent(8);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void initialize(Class cls, PCState state) {
        PersistenceCapable inst;
        if (this._meta.getDescribedType() != cls) {
            ClassMetaData sub = this._meta.getRepository().getMetaData(cls, this._broker.getClassLoader(), true);
            if (this._oid != null) {
                if (this._meta.getIdentityType() == 1) {
                    this._oid = this._broker.getStoreManager().copyDataStoreId(this._oid, sub);
                } else if (this._meta.isOpenJPAIdentity()) {
                    this._oid = ApplicationIds.copy(this._oid, sub);
                } else if (sub.getObjectIdType() != this._meta.getObjectIdType()) {
                    Object[] pkFields = ApplicationIds.toPKValues(this._oid, this._meta);
                    this._oid = ApplicationIds.fromPKValues(pkFields, sub);
                }
            }
            this._meta = sub;
        }
        if ((inst = PCRegistry.newInstance(cls, this, this._oid, true)) == null) {
            if (Modifier.isAbstract(cls.getModifiers())) {
                throw new UserException(_loc.get("instantiate-abstract", cls.getName(), this._oid));
            }
            throw new InternalException();
        }
        this.initialize(inst, state);
    }

    protected void initialize(PersistenceCapable pc, PCState state) {
        if (pc == null) {
            throw new UserException(_loc.get("init-null-pc", this._meta));
        }
        if (pc.pcGetStateManager() != null && pc.pcGetStateManager() != this) {
            throw new UserException(_loc.get("init-sm-pc", Exceptions.toString(pc))).setFailedObject(pc);
        }
        pc.pcReplaceStateManager(this);
        FieldMetaData[] fmds = this._meta.getFields();
        this._loaded = new BitSet(fmds.length);
        this._flush = new BitSet(fmds.length);
        this._dirty = new BitSet(fmds.length);
        for (int i : this._meta.getPkAndNonPersistentManagedFmdIndexes()) {
            this._loaded.set(i);
        }
        this._mappedByIdFields = this._meta.getMappyedByIdFields();
        if (this._broker.getInverseManager() != null && this._meta.hasInverseManagedFields()) {
            this._flags |= 0x2000;
        }
        pc.pcSetDetachedState(null);
        this._pc = pc;
        if (this._oid instanceof OpenJPAId) {
            ((OpenJPAId)this._oid).setManagedInstanceType(this._meta.getDescribedType());
        }
        this.setPCState(state);
        if (this._oid == null || this._broker.getStateManagerImplById(this._oid, false) == null) {
            this._broker.setStateManager(this._id, this, 0);
        }
        if (state == PCState.PNEW) {
            this.fireLifecycleEvent(1);
        }
        if (!this.isIntercepting()) {
            this.saveFields(true);
            if (!this.isNew()) {
                RedefinitionHelper.assignLazyLoadProxies(this);
            }
        }
    }

    public boolean isIntercepting() {
        if (this.getMetaData().isIntercepting()) {
            return true;
        }
        return AccessCode.isProperty(this.getMetaData().getAccessType()) && this._pc instanceof DynamicPersistenceCapable;
    }

    private boolean fireLifecycleEvent(int type) {
        if (type == 1 && this._broker.getConfiguration().getCallbackOptionsInstance().getPostPersistCallbackImmediate()) {
            this.fetchObjectId();
        }
        return this._broker.fireLifecycleEvent(this.getManagedInstance(), null, this._meta, type);
    }

    @Override
    public void load(FetchConfiguration fetch) {
        this.load(fetch, 0, null, null, false);
    }

    protected boolean load(FetchConfiguration fetch, int loadMode, BitSet exclude, Object sdata, boolean forWrite) {
        if (!forWrite && (!this.isPersistent() || this.isNew() && !this.isFlushed() || this.isDeleted())) {
            return false;
        }
        BitSet fields = this.getUnloadedInternal(fetch, loadMode, exclude);
        boolean active = this._broker.isActive();
        if (!forWrite && fields != null) {
            this.beforeRead(-1);
        }
        int lockLevel = this.calculateLockLevel(active, forWrite, fetch);
        boolean ret = this.loadFields(fields, fetch, lockLevel, sdata);
        this.obtainLocks(active, forWrite, lockLevel, fetch, sdata);
        return ret;
    }

    @Override
    public Object getManagedInstance() {
        if (this._pc instanceof ManagedInstanceProvider) {
            return ((ManagedInstanceProvider)((Object)this._pc)).getManagedInstance();
        }
        return this._pc;
    }

    @Override
    public PersistenceCapable getPersistenceCapable() {
        return this._pc;
    }

    @Override
    public ClassMetaData getMetaData() {
        return this._meta;
    }

    @Override
    public OpenJPAStateManager getOwner() {
        return this._owner;
    }

    @Override
    public int getOwnerIndex() {
        return this._ownerIndex;
    }

    public void setOwner(Object oid) {
        this._ownerId = oid;
    }

    @Override
    public boolean isEmbedded() {
        return this._owner != null || this._state instanceof ENonTransState;
    }

    @Override
    public boolean isFlushed() {
        return (this._flags & 0x200) > 0;
    }

    @Override
    public boolean isFlushedDirty() {
        return (this._flags & 0x800) > 0;
    }

    @Override
    public BitSet getLoaded() {
        return this._loaded;
    }

    @Override
    public BitSet getFlushed() {
        return this._flush;
    }

    @Override
    public BitSet getDirty() {
        return this._dirty;
    }

    @Override
    public BitSet getUnloaded(FetchConfiguration fetch) {
        BitSet fields = this.getUnloadedInternal(fetch, 0, null);
        return fields == null ? new BitSet(0) : fields;
    }

    private BitSet getUnloadedInternal(FetchConfiguration fetch, int mode, BitSet exclude) {
        if (exclude == StoreContext.EXCLUDE_ALL) {
            return null;
        }
        BitSet fields = null;
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            boolean load;
            if (this._loaded.get(i) || exclude != null && exclude.get(i)) continue;
            switch (mode) {
                case 2: {
                    load = !fmds[i].isTransient();
                    break;
                }
                case 0: {
                    load = fetch == null || fetch.requiresFetch(fmds[i]) != 0;
                    break;
                }
                default: {
                    load = true;
                }
            }
            if (!load) continue;
            if (fields == null) {
                fields = new BitSet(fmds.length);
            }
            fields.set(i);
        }
        return fields;
    }

    @Override
    public StoreContext getContext() {
        return this._broker;
    }

    BrokerImpl getBroker() {
        return this._broker;
    }

    @Override
    public Object getId() {
        return this._id;
    }

    @Override
    public Object getObjectId() {
        StateManagerImpl sm = this;
        while (sm.getOwner() != null) {
            sm = (StateManagerImpl)sm.getOwner();
        }
        if (sm.isEmbedded() && sm.getOwner() == null) {
            return sm._ownerId;
        }
        return sm._oid;
    }

    @Override
    public void setObjectId(Object oid) {
        this._oid = oid;
        if (this._pc != null && oid instanceof OpenJPAId) {
            ((OpenJPAId)oid).setManagedInstanceType(this._meta.getDescribedType());
        }
    }

    public StateManagerImpl getObjectIdOwner() {
        StateManagerImpl sm = this;
        while (sm.getOwner() != null) {
            sm = (StateManagerImpl)sm.getOwner();
        }
        return sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean assignObjectId(boolean flush) {
        this.lock();
        try {
            boolean bl = this.assignObjectId(flush, false);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    boolean assignObjectId(boolean flush, boolean preFlushing) {
        if (this._oid != null || this.isEmbedded() || !this.isPersistent()) {
            return true;
        }
        if (this._broker.getStoreManager().assignObjectId(this, preFlushing)) {
            if (!preFlushing) {
                this.assertObjectIdAssigned(true);
            }
        } else if (flush) {
            this._broker.flush();
        } else {
            return false;
        }
        return true;
    }

    private void assertObjectIdAssigned(boolean recache) {
        if (!this.isNew() || this.isDeleted() || this.isProvisional() || (this._flags & 0x40) != 0) {
            return;
        }
        if (this._oid == null) {
            if (this._meta.getIdentityType() == 1) {
                throw new InternalException(Exceptions.toString(this.getManagedInstance()));
            }
            this._oid = ApplicationIds.create(this._pc, this._meta);
        }
        Object orig = this._id;
        this._id = this._oid;
        if (recache) {
            try {
                this._broker.setStateManager(orig, this, 2);
            }
            catch (RuntimeException re) {
                this._id = orig;
                this._oid = null;
                throw re;
            }
        }
        this._flags |= 0x40;
    }

    private boolean assignField(int field, boolean preFlushing) {
        OpenJPAStateManager sm;
        for (sm = this; sm != null && sm.isEmbedded(); sm = sm.getOwner()) {
        }
        if (sm == null) {
            return false;
        }
        if (!sm.isNew() || sm.isFlushed() || sm.isDeleted()) {
            return false;
        }
        FieldMetaData fmd = this._meta.getField(field);
        if (fmd.getDeclaredTypeCode() == 29) {
            if (this._oid != null || this.isEmbedded() || !this.isPersistent()) {
                return true;
            }
            FieldMetaData[] pks = fmd.getEmbeddedMetaData().getFields();
            OpenJPAStateManager oidsm = null;
            boolean assign = false;
            for (int i = 0; !assign && i < pks.length; ++i) {
                if (pks[i].getValueStrategy() == 0) continue;
                if (oidsm == null) {
                    oidsm = new ObjectIdStateManager(this.fetchObjectField(field), this, fmd);
                }
                assign = oidsm.isDefaultValue(i);
            }
            return assign && this.assignObjectId(!preFlushing, preFlushing);
        }
        if (fmd.getValueStrategy() == 0) {
            return false;
        }
        if (!fmd.isValueGenerated() && !this.isDefaultValue(field)) {
            throw new InvalidStateException(_loc.get("existing-value-override-excep", fmd.getFullName(false)));
        }
        if (fmd.isPrimaryKey() && !this.isEmbedded()) {
            return this.assignObjectId(!preFlushing, preFlushing);
        }
        if (this._broker.getStoreManager().assignField(this, field, preFlushing)) {
            fmd.setValueGenerated(true);
            return true;
        }
        if (!preFlushing) {
            this._broker.flush();
        }
        return !preFlushing;
    }

    @Override
    public Object getLock() {
        return this._lock;
    }

    @Override
    public void setLock(Object lock) {
        this._lock = lock;
    }

    @Override
    public Object getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(Object version) {
        this._loadVersion = version;
        this.assignVersionField(version);
    }

    Object getLoadVersion() {
        return this._loadVersion;
    }

    @Override
    public void setNextVersion(Object version) {
        this.assignVersionField(version);
    }

    private void assignVersionField(Object version) {
        this._version = version;
        FieldMetaData vfield = this._meta.getVersionField();
        if (vfield != null) {
            this.store(vfield.getIndex(), JavaTypes.convert(version, vfield.getTypeCode()));
        }
    }

    @Override
    public PCState getPCState() {
        return this._state;
    }

    @Override
    public synchronized Object getImplData() {
        return this._impl;
    }

    @Override
    public synchronized Object setImplData(Object data, boolean cacheable) {
        Object old = this._impl;
        this._impl = data;
        this._flags = cacheable && data != null ? (this._flags |= 0x1000) : (this._flags &= 0xFFFFEFFF);
        return old;
    }

    @Override
    public boolean isImplDataCacheable() {
        return (this._flags & 0x1000) != 0;
    }

    @Override
    public Object getImplData(int field) {
        return this.getExtraFieldData(field, true);
    }

    @Override
    public Object setImplData(int field, Object data) {
        return this.setExtraFieldData(field, data, true);
    }

    @Override
    public synchronized boolean isImplDataCacheable(int field) {
        if (this._fieldImpl == null || !this._loaded.get(field)) {
            return false;
        }
        if (this._meta.getField(field).usesImplData() != null) {
            return false;
        }
        int idx = this._meta.getExtraFieldDataIndex(field);
        return idx != -1 && this._fieldImpl[idx] != null;
    }

    @Override
    public Object getIntermediate(int field) {
        return this.getExtraFieldData(field, false);
    }

    @Override
    public void setIntermediate(int field, Object data) {
        this.setExtraFieldData(field, data, false);
    }

    protected synchronized Object getExtraFieldData(int field, boolean isLoaded) {
        if (this._fieldImpl == null || this._loaded.get(field) != isLoaded) {
            return null;
        }
        int idx = this._meta.getExtraFieldDataIndex(field);
        return idx == -1 ? null : this._fieldImpl[idx];
    }

    private synchronized Object setExtraFieldData(int field, Object data, boolean loaded) {
        Object old;
        int idx = this._meta.getExtraFieldDataIndex(field);
        if (idx == -1) {
            throw new InternalException(String.valueOf(this._meta.getField(field)));
        }
        Object object = old = this._fieldImpl == null ? null : this._fieldImpl[idx];
        if (data != null) {
            if (this._loaded.get(field) != loaded) {
                throw new InternalException(String.valueOf(this._meta.getField(field)));
            }
            if (this._fieldImpl == null) {
                this._fieldImpl = new Object[this._meta.getExtraFieldDataLength()];
            }
            this._fieldImpl[idx] = data;
        } else if (this._fieldImpl != null && this._loaded.get(field) == loaded) {
            this._fieldImpl[idx] = null;
        }
        return old;
    }

    @Override
    public Object fetch(int field) {
        Object val = this.fetchField(field, false);
        return this._meta.getField(field).getExternalValue(val, this._broker);
    }

    @Override
    public Object fetchField(int field, boolean transitions) {
        FieldMetaData fmd = this._meta.getField(field);
        if (fmd == null) {
            throw new UserException(_loc.get("no-field", String.valueOf(field), this.getManagedInstance().getClass())).setFailedObject(this.getManagedInstance());
        }
        if (!fmd.isPrimaryKey() && transitions) {
            this.accessingField(field);
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 9: {
                return this.fetchStringField(field);
            }
            case 8: {
                return this.fetchObjectField(field);
            }
            case 0: {
                return this.fetchBooleanField(field) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.fetchByteField(field);
            }
            case 2: {
                return Character.valueOf(this.fetchCharField(field));
            }
            case 3: {
                return this.fetchDoubleField(field);
            }
            case 4: {
                return Float.valueOf(this.fetchFloatField(field));
            }
            case 5: {
                return this.fetchIntField(field);
            }
            case 6: {
                return this.fetchLongField(field);
            }
            case 7: {
                return this.fetchShortField(field);
            }
        }
        return this.fetchObjectField(field);
    }

    @Override
    public void store(int field, Object val) {
        val = this._meta.getField(field).getFieldValue(val, this._broker);
        this.storeField(field, val);
    }

    @Override
    public void storeField(int field, Object val) {
        this.storeField(field, val, this);
    }

    public void dirtyCheck() {
        if (!this.needsDirtyCheck()) {
            return;
        }
        SaveFieldManager saved = this.getSaveFieldManager();
        if (saved == null) {
            throw new InternalException(_loc.get("no-saved-fields", this.getMetaData().getDescribedType().getName()));
        }
        FieldMetaData[] fmds = this.getMetaData().getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].isPrimaryKey() || fmds[i].isVersion() || !this._loaded.get(i) || saved.isFieldEqual(i, this.fetch(i))) continue;
            this.dirty(i);
        }
    }

    private boolean needsDirtyCheck() {
        if (this.isIntercepting()) {
            return false;
        }
        if (this.isDeleted()) {
            return false;
        }
        return !this.isNew() || this.isFlushed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fetchInitialField(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (this._broker.getRestoreState() == 0 && ((this._flags & 0x2000) == 0 || fmd.getInverseMetaDatas().length == 0)) {
            throw new InvalidStateException(_loc.get("restore-unset"));
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 28: {
                if (this._broker.getRestoreState() == 2 || (this._flags & 0x2000) != 0 && fmd.getInverseMetaDatas().length != 0) break;
                throw new InvalidStateException(_loc.get("mutable-restore-unset"));
            }
        }
        this.lock();
        try {
            if (this._saved == null || !this._loaded.get(field) || !this._dirty.get(field)) {
                Object object = this.fetchField(field, false);
                return object;
            }
            if (this._saved.getUnloaded().get(field)) {
                throw new InvalidStateException(_loc.get("initial-unloaded", fmd));
            }
            this.provideField(this._saved.getState(), this._single, field);
            Object object = StateManagerImpl.fetchField(this._single, fmd);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    private static Object fetchField(FieldManager fm, FieldMetaData fmd) {
        int field = fmd.getIndex();
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                return fm.fetchBooleanField(field) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return fm.fetchByteField(field);
            }
            case 2: {
                return Character.valueOf(fm.fetchCharField(field));
            }
            case 3: {
                return fm.fetchDoubleField(field);
            }
            case 4: {
                return Float.valueOf(fm.fetchFloatField(field));
            }
            case 5: {
                return fm.fetchIntField(field);
            }
            case 6: {
                return fm.fetchLongField(field);
            }
            case 7: {
                return fm.fetchShortField(field);
            }
            case 9: {
                return fm.fetchStringField(field);
            }
        }
        return fm.fetchObjectField(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRemote(int field, Object value) {
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, false);
            this.storeField(field, value, this._single);
            this.replaceField(this._pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    void beforeRead(int field) {
        if (field != -1 && this._meta.getField(field).isPrimaryKey()) {
            return;
        }
        if (this._broker.isActive() && !this._broker.isTransactionEnding()) {
            if (this._broker.getOptimistic()) {
                this.setPCState(this._state.beforeOptimisticRead(this, field));
            } else {
                this.setPCState(this._state.beforeRead(this, field));
            }
        } else if (this._broker.getNontransactionalRead()) {
            this.setPCState(this._state.beforeNontransactionalRead(this, field));
        } else {
            throw new InvalidStateException(_loc.get("non-trans-read")).setFailedObject(this.getManagedInstance());
        }
    }

    void beforeFlush(int reason, OpCallbacks call) {
        this._state.beforeFlush(this, reason == 3, call);
    }

    void afterFlush(int reason) {
        if (!this.isPersistent()) {
            return;
        }
        if (reason != 2 && reason != 3) {
            boolean wasNew = this.isNew();
            boolean wasFlushed = this.isFlushed();
            boolean wasDeleted = this.isDeleted();
            boolean needPostUpdate = (!wasNew || wasFlushed) && ImplHelper.getUpdateFields(this) != null;
            this._flush.or(this._dirty);
            this.setPCState(this._state.flush(this));
            this._flags |= 0x200;
            this._flags &= 0xFFFFF7FF;
            this._flags &= 0xFFFF7FFF;
            this._flags &= 0xFFFEFFFF;
            if (reason == 0) {
                this.assertObjectIdAssigned(true);
            }
            if ((this._flags & 0x400) > 0) {
                this.fireLifecycleEvent(4);
            }
            if (wasNew && !wasFlushed) {
                this.fireLifecycleEvent(18);
            } else if (wasDeleted) {
                this.fireLifecycleEvent(19);
            } else if (needPostUpdate) {
                this.fireLifecycleEvent(21);
            }
        } else if (reason == 2) {
            this.assignVersionField(this._loadVersion);
            if (this.isNew() && (this._flags & 0x40) == 0) {
                this._oid = null;
            }
        }
        this._flags &= 0xFFFFFBFF;
    }

    void commit() {
        boolean wasNew;
        this.releaseLocks();
        this.setVersion(this._version);
        this._flags &= 0xFFFFFDFF;
        this._flags &= 0xFFFFF7FF;
        Object orig = this._id;
        this.assertObjectIdAssigned(false);
        boolean bl = wasNew = this.isNew() && !this.isDeleted() && !this.isProvisional();
        if (this._broker.getRetainState()) {
            this.setPCState(this._state.commitRetain(this));
        } else {
            this.setPCState(this._state.commit(this));
        }
        if (wasNew) {
            this._broker.setStateManager(orig, this, 3);
        }
    }

    void rollback() {
        this.releaseLocks();
        this._flags &= 0xFFFFFDFF;
        this._flags &= 0xFFFFF7FF;
        this.afterFlush(2);
        if (this._broker.getRestoreState() != 0) {
            this.setPCState(this._state.rollbackRestore(this));
        } else {
            this.setPCState(this._state.rollback(this));
        }
    }

    void rollbackToSavepoint(SavepointFieldManager savepoint) {
        this._state = savepoint.getPCState();
        BitSet loaded = savepoint.getLoaded();
        int len = loaded.length();
        for (int i = 0; i < len; ++i) {
            if (!loaded.get(i) || !savepoint.restoreField(i)) continue;
            this.provideField(savepoint.getCopy(), savepoint, i);
            this.replaceField(this._pc, savepoint, i);
        }
        this._loaded = loaded;
        this._dirty = savepoint.getDirty();
        this._flush = savepoint.getFlushed();
        this._version = savepoint.getVersion();
        this._loadVersion = savepoint.getLoadVersion();
    }

    void persist() {
        this.setPCState(this._state.persist(this));
    }

    void delete() {
        this.setPCState(this._state.delete(this));
    }

    void nontransactional() {
        this.setPCState(this._state.nontransactional(this));
    }

    void transactional() {
        this.setPCState(this._state.transactional(this));
    }

    void nonprovisional(boolean logical, OpCallbacks call) {
        this.setPCState(this._state.nonprovisional(this, logical, call));
    }

    void release(boolean unproxy) {
        this.release(unproxy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(boolean unproxy, boolean force) {
        if (!unproxy) {
            this._flags |= 0x4000;
        }
        try {
            if (force) {
                this.setPCState(PCState.TRANSIENT);
            } else {
                this.setPCState(this._state.release(this));
            }
        }
        finally {
            this._flags &= 0xFFFFBFFF;
        }
    }

    void evict() {
        this.setPCState(this._state.evict(this));
    }

    void gatherCascadeRefresh(OpCallbacks call) {
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (!this._loaded.get(i) || fmds[i].getCascadeRefresh() != 1 && fmds[i].getKey().getCascadeRefresh() != 1 && fmds[i].getElement().getCascadeRefresh() != 1) continue;
            this._single.storeObjectField(i, this.fetchField(i, false));
            this._single.gatherCascadeRefresh(call);
            this._single.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beforeRefresh(boolean refreshAll) {
        if (!this.isPersistent() || this.isNew() && !this.isFlushed()) {
            return false;
        }
        this.lock();
        try {
            if (this.isDirty()) {
                this.clearFields();
                boolean bl = true;
                return bl;
            }
            if (this._loaded.length() > 0 && (refreshAll || this.isEmbedded() || !this.syncVersion(null))) {
                Object version = this._version;
                this.clearFields();
                if (!refreshAll && !this.isEmbedded()) {
                    this.setVersion(version);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterRefresh() {
        this.lock();
        try {
            if (!this._broker.isActive()) {
                this.setPCState(this._state.afterNontransactionalRefresh());
            } else if (this._broker.getOptimistic()) {
                this.setPCState(this._state.afterOptimisticRefresh());
            } else {
                this.setPCState(this._state.afterRefresh());
            }
        }
        finally {
            this.unlock();
        }
    }

    void setDereferencedDependent(boolean deref, boolean notify) {
        if (!deref && (this._flags & 4) > 0) {
            if (notify) {
                this._broker.removeDereferencedDependent(this);
            }
            this._flags &= 0xFFFFFFFB;
        } else if (deref && (this._flags & 4) == 0) {
            this._flags |= 4;
            if (notify) {
                this._broker.addDereferencedDependent(this);
            }
        }
    }

    void setDereferencedEmbedDependent(boolean deref) {
        if (!deref && (this._flags & 0x40000) > 0) {
            this._flags &= 0xFFFBFFFF;
        } else if (deref && (this._flags & 0x40000) == 0) {
            this._flags |= 0x40000;
        }
    }

    public boolean getDereferencedEmbedDependent() {
        return (this._flags & 0x40000) != 0;
    }

    void readLocked(int readLockLevel, int writeLockLevel) {
        if (readLockLevel != 0) {
            this.transactional();
        }
        this._readLockLevel = readLockLevel;
        this._writeLockLevel = writeLockLevel;
        this._flags |= 0x10;
        this._flags &= 0xFFFFFFDF;
    }

    private int calculateLockLevel(boolean active, boolean forWrite, FetchConfiguration fetch) {
        if (!active) {
            return 0;
        }
        if (fetch == null) {
            fetch = this._broker.getFetchConfiguration();
        }
        if (this._readLockLevel == -1) {
            this._readLockLevel = fetch.getReadLockLevel();
        }
        if (this._writeLockLevel == -1) {
            this._writeLockLevel = fetch.getWriteLockLevel();
        }
        return forWrite ? this._writeLockLevel : this._readLockLevel;
    }

    private void obtainLocks(boolean active, boolean forWrite, int lockLevel, FetchConfiguration fetch, Object sdata) {
        int flag;
        if (!active) {
            return;
        }
        int n = flag = forWrite ? 32 : 16;
        if ((this._flags & flag) == 0) {
            if (lockLevel != 0) {
                this.transactional();
            }
            if (fetch == null) {
                fetch = this._broker.getFetchConfiguration();
            }
            this._broker.getLockManager().lock(this, lockLevel, fetch.getLockTimeout(), sdata);
            this._flags |= 0x10;
            this._flags |= flag;
        }
    }

    private void releaseLocks() {
        if (this._lock != null) {
            this._broker.getLockManager().release(this);
        }
        this._readLockLevel = -1;
        this._writeLockLevel = -1;
        this._flags &= 0xFFFFFFEF;
        this._flags &= 0xFFFFFFDF;
    }

    @Override
    public boolean serializing() {
        if (this._broker.isSerializing()) {
            return false;
        }
        try {
            if (this._meta.isDetachable()) {
                return DetachManager.preSerialize(this);
            }
            this.load(this._broker.getFetchConfiguration(), 2, null, null, false);
            return false;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean writeDetached(ObjectOutput out) throws IOException {
        BitSet idxs = new BitSet(this._meta.getFields().length);
        this.lock();
        try {
            boolean detsm = DetachManager.writeDetachedState(this, out, idxs);
            if (detsm) {
                this._flags |= 0x20000;
            }
            FieldMetaData[] fmds = this._meta.getFields();
            for (int i = 0; i < fmds.length; ++i) {
                if (fmds[i].isTransient()) continue;
                this.provideField(this._pc, this._single, i);
                this._single.serialize(out, !idxs.get(i));
                this._single.clear();
            }
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
        finally {
            this._flags &= 0xFFFDFFFF;
            this.unlock();
        }
    }

    @Override
    public void proxyDetachedDeserialized(int idx) {
        throw new InternalException();
    }

    @Override
    public boolean isTransactional() {
        return this._state == PCState.TCLEAN || this._state.isTransactional();
    }

    public boolean isPendingTransactional() {
        return this._state.isPendingTransactional();
    }

    @Override
    public boolean isProvisional() {
        return this._state.isProvisional();
    }

    @Override
    public boolean isPersistent() {
        return this._state.isPersistent();
    }

    @Override
    public boolean isNew() {
        return this._state.isNew();
    }

    @Override
    public boolean isDeleted() {
        return this._state.isDeleted();
    }

    @Override
    public boolean isDirty() {
        return this._state.isDirty();
    }

    @Override
    public boolean isDetached() {
        return (this._flags & 0x20000) != 0;
    }

    @Override
    public Object getGenericContext() {
        return this._broker;
    }

    @Override
    public Object fetchObjectId() {
        try {
            if (this.hasGeneratedKey() && this._state instanceof PNewState && this._oid == null) {
                return this._oid;
            }
            this.assignObjectId(true);
            if (this._oid == null || !this._broker.getConfiguration().getCompatibilityInstance().getCopyObjectIds()) {
                return this._oid;
            }
            if (this._meta.getIdentityType() == 1) {
                return this._broker.getStoreManager().copyDataStoreId(this._oid, this._meta);
            }
            return ApplicationIds.copy(this._oid, this._meta);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    private boolean hasGeneratedKey() {
        FieldMetaData[] pkFields = this._meta.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            if (pkFields[i].getValueStrategy() != 3) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getPCPrimaryKey(Object oid, int field) {
        FieldMetaData fmd = this._meta.getField(field);
        Object pk = ApplicationIds.get(oid, fmd);
        if (pk == null) {
            return null;
        }
        ClassMetaData relmeta = fmd.getDeclaredTypeMetaData();
        pk = ApplicationIds.wrap(relmeta, pk);
        if (relmeta.getIdentityType() == 1 && fmd.getObjectIdFieldTypeCode() == 6) {
            pk = this._broker.getStoreManager().newDataStoreId(pk, relmeta);
        } else if (relmeta.getIdentityType() == 2 && fmd.getObjectIdFieldType() != relmeta.getObjectIdType()) {
            pk = ApplicationIds.fromPKValues(new Object[]{pk}, relmeta);
        }
        return this._broker.find(pk, false, null);
    }

    public byte replaceFlags() {
        return 1;
    }

    @Override
    public StateManager replaceStateManager(StateManager sm) {
        return sm;
    }

    @Override
    public void accessingField(int field) {
        try {
            if (this._loaded.get(field) && !this._meta.getField(field).isPrimaryKey()) {
                return;
            }
            this.beforeRead(field);
            this.beforeAccessField(field);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean isDelayed(int field) {
        if (this._delayed == null) {
            return false;
        }
        return this._delayed.get(field);
    }

    @Override
    public void setDelayed(int field, boolean delay) {
        if (this._delayed == null) {
            this._delayed = new BitSet();
        }
        if (delay) {
            this._delayed.set(field);
        } else {
            this._delayed.clear(field);
        }
    }

    @Override
    public void loadDelayedField(int field) {
        if (!this.isDelayed(field)) {
            return;
        }
        try {
            this.beforeRead(field);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
        this.lock();
        try {
            boolean active = this._broker.isActive();
            int lockLevel = this.calculateLockLevel(active, false, null);
            BitSet fields = new BitSet();
            fields.set(field);
            if (!this._broker.getStoreManager().load(this, fields, this._broker.getFetchConfiguration(), lockLevel, null)) {
                throw new ObjectNotFoundException(_loc.get("del-instance", this._meta.getDescribedType(), this._oid)).setFailedObject(this.getManagedInstance());
            }
            this._delayed.clear(field);
            this.obtainLocks(active, false, lockLevel, null, null);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
        finally {
            this.unlock();
        }
    }

    protected void beforeAccessField(int field) {
        this.lock();
        try {
            boolean active = this._broker.isActive();
            int lockLevel = this.calculateLockLevel(active, false, null);
            if (!this._loaded.get(field)) {
                this.loadField(field, lockLevel, false, true);
            } else {
                this.assignField(field, false);
            }
            this.obtainLocks(active, false, lockLevel, null, null);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void dirty(String field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (fmd == null) {
            throw this.translate(new UserException(_loc.get("no-field", field, ImplHelper.getManagedInstance(this._pc).getClass())).setFailedObject(this.getManagedInstance()));
        }
        this.dirty(fmd.getIndex(), null, true);
    }

    @Override
    public void dirty(int field) {
        this.dirty(field, null, true);
    }

    private boolean isEmbeddedNotUpdatable() {
        return this._owner == null && this._ownerId != null;
    }

    private Boolean dirty(int field, Boolean mutate, boolean loadFetchGroup) {
        boolean locked = false;
        boolean newFlush = false;
        boolean clean = false;
        try {
            FieldMetaData fmd = this._meta.getField(field);
            if (!this.isNew() || this.isFlushed()) {
                if (fmd.getUpdateStrategy() == 2) {
                    throw new InvalidStateException(_loc.get("update-restrict", fmd));
                }
                if (fmd.getUpdateStrategy() == 1) {
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
            }
            if (this.isEmbedded()) {
                if (this.isEmbeddedNotUpdatable()) {
                    throw new UserException(_loc.get("cant-update-embed-in-query-result")).setFailedObject(this.getManagedInstance());
                }
                this._owner.dirty(this._ownerIndex, Boolean.TRUE, loadFetchGroup);
            }
            if (mutate == null) {
                switch (fmd.getDeclaredTypeCode()) {
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 28: {
                        mutate = Boolean.TRUE;
                        break;
                    }
                    case 15: {
                        mutate = fmd.isEmbedded() ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    default: {
                        mutate = Boolean.FALSE;
                    }
                }
            }
            boolean active = this._broker.isActive();
            boolean bl = clean = !this._state.isDirty();
            if (clean) {
                this.fireLifecycleEvent(9);
            }
            if (active) {
                if (this._broker.getOptimistic()) {
                    this.setPCState(this._state.beforeOptimisticWrite(this, field, mutate));
                } else {
                    this.setPCState(this._state.beforeWrite(this, field, mutate));
                }
            } else if (fmd.getManagement() == 3) {
                if (this.isPersistent() && !this._broker.getNontransactionalWrite()) {
                    throw new InvalidStateException(_loc.get("non-trans-write")).setFailedObject(this.getManagedInstance());
                }
                this.setPCState(this._state.beforeNontransactionalWrite(this, field, mutate));
            }
            if ((this._flags & 0x200) != 0) {
                newFlush = (this._flags & 0x800) == 0;
                this._flags |= 0x800;
            }
            this.lock();
            locked = true;
            this._flush.clear(field);
            this._broker.setDirty(this, newFlush && !clean);
            this.saveField(field);
            int lockLevel = this.calculateLockLevel(active, true, null);
            if (!this._dirty.get(field)) {
                this.setLoaded(field, true);
                this._dirty.set(field);
                if (loadFetchGroup && this.isPersistent()) {
                    if (fmd.getManagement() == 3) {
                        this.loadField(field, lockLevel, true, true);
                    }
                }
            }
            this.obtainLocks(active, true, lockLevel, null, null);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
        finally {
            if (locked) {
                this.unlock();
            }
        }
        if (clean) {
            return Boolean.TRUE;
        }
        if (newFlush) {
            this.fireLifecycleEvent(11);
            return null;
        }
        return Boolean.FALSE;
    }

    private void postDirty(Boolean status) {
        if (Boolean.TRUE.equals(status)) {
            this.fireLifecycleEvent(10);
        } else if (status == null) {
            this.fireLifecycleEvent(12);
        }
    }

    @Override
    public void removed(int field, Object removed, boolean key) {
        if (removed == null) {
            return;
        }
        try {
            ValueMetaData vmd;
            FieldMetaData fmd = this._meta.getField(field);
            ValueMetaData valueMetaData = vmd = key ? fmd.getKey() : fmd.getElement();
            if (vmd.isEmbeddedPC()) {
                this._single.delete(vmd, removed, null);
            } else if (vmd.getCascadeDelete() == 2) {
                this._single.dereferenceDependent(removed);
            }
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Object newProxy(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.newFieldProxy(field);
        }
        switch (fmd.getTypeCode()) {
            case 14: {
                if (fmd.getDeclaredType() == Date.class) {
                    return new Date(System.currentTimeMillis());
                }
                if (fmd.getDeclaredType() == Timestamp.class) {
                    return new Timestamp(System.currentTimeMillis());
                }
                if (fmd.getDeclaredType() == Time.class) {
                    return new Time(System.currentTimeMillis());
                }
                return new java.util.Date();
            }
            case 28: {
                return Calendar.getInstance();
            }
            case 12: {
                return new ArrayList();
            }
            case 13: {
                return new HashMap();
            }
        }
        return null;
    }

    @Override
    public Object newFieldProxy(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        ProxyManager mgr = this._broker.getConfiguration().getProxyManagerInstance();
        Object init = fmd.getInitializer();
        switch (fmd.getDeclaredTypeCode()) {
            case 14: {
                return mgr.newDateProxy(fmd.getDeclaredType());
            }
            case 28: {
                return mgr.newCalendarProxy(fmd.getDeclaredType(), init instanceof TimeZone ? (TimeZone)init : null);
            }
            case 12: {
                return mgr.newCollectionProxy(fmd.getProxyType(), fmd.getElement().getDeclaredType(), init instanceof Comparator ? (Comparator)init : null, this._broker.getConfiguration().getCompatibilityInstance().getAutoOff());
            }
            case 13: {
                return mgr.newMapProxy(fmd.getProxyType(), fmd.getKey().getDeclaredType(), fmd.getElement().getDeclaredType(), init instanceof Comparator ? (Comparator)init : null, this._broker.getConfiguration().getCompatibilityInstance().getAutoOff());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefaultValue(int field) {
        this.lock();
        try {
            this._single.clear();
            this.provideField(this._pc, this._single, field);
            boolean ret = this._single.isDefaultValue();
            this._single.clear();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingBooleanField(PersistenceCapable pc, int field, boolean curVal, boolean newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeBooleanField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingByteField(PersistenceCapable pc, int field, byte curVal, byte newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeByteField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingCharField(PersistenceCapable pc, int field, char curVal, char newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeCharField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingDoubleField(PersistenceCapable pc, int field, double curVal, double newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeDoubleField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingFloatField(PersistenceCapable pc, int field, float curVal, float newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeFloatField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingIntField(PersistenceCapable pc, int field, int curVal, int newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeIntField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingLongField(PersistenceCapable pc, int field, long curVal, long newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeLongField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void settingObjectField(PersistenceCapable pc, int field, Object curVal, Object newVal, int set) {
        block16: {
            block18: {
                block17: {
                    if (set == 1) break block16;
                    fmd = this._meta.getField(field);
                    if (!this._loaded.get(field)) break block17;
                    if (newVal == curVal) {
                        return;
                    }
                    switch (fmd.getDeclaredTypeCode()) {
                        case 11: 
                        case 12: 
                        case 13: 
                        case 27: {
                            break block18;
                        }
                        case 15: {
                            if (this._meta.getField(field).isPrimaryKey()) {
                                if (curVal != null && newVal != null && curVal instanceof PersistenceCapable && newVal instanceof PersistenceCapable) {
                                    curPc = (PersistenceCapable)curVal;
                                    newPc = (PersistenceCapable)newVal;
                                    if (curPc.pcFetchObjectId().equals(newPc.pcFetchObjectId())) {
                                        return;
                                    } else {
                                        ** GOTO lbl17
                                    }
                                } else {
                                    ** GOTO lbl17
                                }
                            }
                            break block18;
                        }
lbl17:
                        // 5 sources

                        default: {
                            if (newVal != null && newVal.equals(curVal)) {
                                return;
                            }
                            break block18;
                        }
                    }
                }
                if (fmd.getCascadeDelete() == 2 || fmd.getKey().getCascadeDelete() == 2 || fmd.getElement().getCascadeDelete() == 2) {
                    curVal = this.fetchObjectField(field);
                }
            }
            this.assertNoPrimaryKeyChange(field);
            if (fmd.getDeclaredTypeCode() == 29) {
                this.assertNotManagedObjectId(newVal);
            }
        }
        this.lock();
        try {
            stat = this.dirty(field, Boolean.FALSE, set == 0);
            if (set != 1) {
                this._single.storeObjectField(field, curVal);
                this._single.unproxy();
                this._single.dereferenceDependent();
                this._single.clear();
            }
            this._single.storeObjectField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingShortField(PersistenceCapable pc, int field, short curVal, short newVal, int set) {
        if (set != 1) {
            if (newVal == curVal && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeShortField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingStringField(PersistenceCapable pc, int field, String curVal, String newVal, int set) {
        if (set != 1) {
            if (StringUtils.equals((String)newVal, (String)curVal) && this._loaded.get(field)) {
                return;
            }
            this.assertNoPrimaryKeyChange(field);
        }
        this.lock();
        try {
            Boolean stat = this.dirty(field, Boolean.FALSE, set == 0);
            this._single.storeStringField(field, newVal);
            this.replaceField(pc, this._single, field);
            this.postDirty(stat);
        }
        finally {
            this.unlock();
        }
    }

    private void assertNoPrimaryKeyChange(int field) {
        if (this._oid != null && this._meta.getField(field).isPrimaryKey()) {
            throw this.translate(new InvalidStateException(_loc.get("change-identity")).setFailedObject(this.getManagedInstance()));
        }
    }

    void assertNotManagedObjectId(Object val) {
        if (val != null && ImplHelper.toPersistenceCapable(val, this.getContext().getConfiguration()).pcGetGenericContext() != null) {
            throw this.translate(new InvalidStateException(_loc.get("managed-oid", Exceptions.toString(val), Exceptions.toString(this.getManagedInstance()))).setFailedObject(this.getManagedInstance()));
        }
    }

    @Override
    public void providedBooleanField(PersistenceCapable pc, int field, boolean curVal) {
        this._fm.storeBooleanField(field, curVal);
    }

    @Override
    public void providedByteField(PersistenceCapable pc, int field, byte curVal) {
        this._fm.storeByteField(field, curVal);
    }

    @Override
    public void providedCharField(PersistenceCapable pc, int field, char curVal) {
        this._fm.storeCharField(field, curVal);
    }

    @Override
    public void providedDoubleField(PersistenceCapable pc, int field, double curVal) {
        this._fm.storeDoubleField(field, curVal);
    }

    @Override
    public void providedFloatField(PersistenceCapable pc, int field, float curVal) {
        this._fm.storeFloatField(field, curVal);
    }

    @Override
    public void providedIntField(PersistenceCapable pc, int field, int curVal) {
        this._fm.storeIntField(field, curVal);
    }

    @Override
    public void providedLongField(PersistenceCapable pc, int field, long curVal) {
        this._fm.storeLongField(field, curVal);
    }

    @Override
    public void providedObjectField(PersistenceCapable pc, int field, Object curVal) {
        this._fm.storeObjectField(field, curVal);
    }

    @Override
    public void providedShortField(PersistenceCapable pc, int field, short curVal) {
        this._fm.storeShortField(field, curVal);
    }

    @Override
    public void providedStringField(PersistenceCapable pc, int field, String curVal) {
        this._fm.storeStringField(field, curVal);
    }

    @Override
    public boolean replaceBooleanField(PersistenceCapable pc, int field) {
        return this._fm.fetchBooleanField(field);
    }

    @Override
    public byte replaceByteField(PersistenceCapable pc, int field) {
        return this._fm.fetchByteField(field);
    }

    @Override
    public char replaceCharField(PersistenceCapable pc, int field) {
        return this._fm.fetchCharField(field);
    }

    @Override
    public double replaceDoubleField(PersistenceCapable pc, int field) {
        return this._fm.fetchDoubleField(field);
    }

    @Override
    public float replaceFloatField(PersistenceCapable pc, int field) {
        return this._fm.fetchFloatField(field);
    }

    @Override
    public int replaceIntField(PersistenceCapable pc, int field) {
        return this._fm.fetchIntField(field);
    }

    @Override
    public long replaceLongField(PersistenceCapable pc, int field) {
        return this._fm.fetchLongField(field);
    }

    @Override
    public Object replaceObjectField(PersistenceCapable pc, int field) {
        return this._fm.fetchObjectField(field);
    }

    @Override
    public short replaceShortField(PersistenceCapable pc, int field) {
        return this._fm.fetchShortField(field);
    }

    @Override
    public String replaceStringField(PersistenceCapable pc, int field) {
        return this._fm.fetchStringField(field);
    }

    @Override
    public boolean fetchBoolean(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchBooleanField(field);
        }
        Object val = this.fetchField(field, false);
        return (Boolean)fmd.getExternalValue(val, this._broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fetchBooleanField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            boolean bl = this._single.fetchBooleanField(field);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public byte fetchByte(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchByteField(field);
        }
        Object val = this.fetchField(field, false);
        return ((Number)fmd.getExternalValue(val, this._broker)).byteValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte fetchByteField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            byte by = this._single.fetchByteField(field);
            return by;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public char fetchChar(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchCharField(field);
        }
        Object val = this.fetchField(field, false);
        return ((Character)fmd.getExternalValue(val, this._broker)).charValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char fetchCharField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            char c = this._single.fetchCharField(field);
            return c;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public double fetchDouble(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchDoubleField(field);
        }
        Object val = this.fetchField(field, false);
        return ((Number)fmd.getExternalValue(val, this._broker)).doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double fetchDoubleField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            double d = this._single.fetchDoubleField(field);
            return d;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public float fetchFloat(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchFloatField(field);
        }
        Object val = this.fetchField(field, false);
        return ((Number)fmd.getExternalValue(val, this._broker)).floatValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float fetchFloatField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            float f = this._single.fetchFloatField(field);
            return f;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int fetchInt(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchIntField(field);
        }
        Object val = this.fetchField(field, false);
        return ((Number)fmd.getExternalValue(val, this._broker)).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fetchIntField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            int n = this._single.fetchIntField(field);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long fetchLong(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchLongField(field);
        }
        Object val = this.fetchField(field, false);
        return ((Number)fmd.getExternalValue(val, this._broker)).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long fetchLongField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            long l = this._single.fetchLongField(field);
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Object fetchObject(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchObjectField(field);
        }
        Object val = this.fetchField(field, false);
        return fmd.getExternalValue(val, this._broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fetchObjectField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            Object object = this._single.fetchObjectField(field);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public short fetchShort(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchShortField(field);
        }
        Object val = this.fetchField(field, false);
        return ((Number)fmd.getExternalValue(val, this._broker)).shortValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short fetchShortField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            short s = this._single.fetchShortField(field);
            return s;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String fetchString(int field) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            return this.fetchStringField(field);
        }
        Object val = this.fetchField(field, false);
        return (String)fmd.getExternalValue(val, this._broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String fetchStringField(int field) {
        this.lock();
        try {
            if (!this._loaded.get(field)) {
                this.loadField(field, 0, false, false);
            }
            this.provideField(this._pc, this._single, field);
            String string = this._single.fetchStringField(field);
            return string;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeBoolean(int field, boolean externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeBooleanField(field, externalVal);
        } else {
            Boolean val = externalVal ? Boolean.TRUE : Boolean.FALSE;
            this.storeField(field, fmd.getFieldValue(val, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeBooleanField(int field, boolean curVal) {
        this.lock();
        try {
            this._single.storeBooleanField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeByte(int field, byte externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeByteField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(externalVal, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeByteField(int field, byte curVal) {
        this.lock();
        try {
            this._single.storeByteField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeChar(int field, char externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeCharField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(Character.valueOf(externalVal), this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCharField(int field, char curVal) {
        this.lock();
        try {
            this._single.storeCharField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeDouble(int field, double externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeDoubleField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(externalVal, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDoubleField(int field, double curVal) {
        this.lock();
        try {
            this._single.storeDoubleField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeFloat(int field, float externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeFloatField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(Float.valueOf(externalVal), this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFloatField(int field, float curVal) {
        this.lock();
        try {
            this._single.storeFloatField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeInt(int field, int externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeIntField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(externalVal, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeIntField(int field, int curVal) {
        this.lock();
        try {
            this._single.storeIntField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeLong(int field, long externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeLongField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(externalVal, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeLongField(int field, long curVal) {
        this.lock();
        try {
            this._single.storeLongField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeObject(int field, Object externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        externalVal = fmd.order(externalVal);
        if (!fmd.isExternalized()) {
            this.storeObjectField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(externalVal, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeObjectField(int field, Object curVal) {
        this.lock();
        try {
            this._single.storeObjectField(field, curVal);
            this._single.proxy(true, false);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeShort(int field, short externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeShortField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(externalVal, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeShortField(int field, short curVal) {
        this.lock();
        try {
            this._single.storeShortField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeString(int field, String externalVal) {
        FieldMetaData fmd = this._meta.getField(field);
        if (!fmd.isExternalized()) {
            this.storeStringField(field, externalVal);
        } else {
            this.storeField(field, fmd.getFieldValue(externalVal, this._broker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeStringField(int field, String curVal) {
        this.lock();
        try {
            this._single.storeStringField(field, curVal);
            this.replaceField(this._pc, this._single, field);
            this.setLoaded(field, true);
            this.postLoad(field, null);
        }
        finally {
            this.unlock();
        }
    }

    private void storeField(int field, Object val, FieldManager fm) {
        FieldMetaData fmd = this._meta.getField(field);
        if (fmd == null) {
            throw new UserException(_loc.get("no-field-index", String.valueOf(field), this._meta.getDescribedType())).setFailedObject(this.getManagedInstance());
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                boolean bool = val != null && (Boolean)val != false;
                fm.storeBooleanField(field, bool);
                break;
            }
            case 1: {
                byte b = val == null ? (byte)0 : ((Number)val).byteValue();
                fm.storeByteField(field, b);
                break;
            }
            case 2: {
                char c = val == null ? (char)'\u0000' : ((Character)val).charValue();
                fm.storeCharField(field, c);
                break;
            }
            case 3: {
                double d = val == null ? 0.0 : ((Number)val).doubleValue();
                fm.storeDoubleField(field, d);
                break;
            }
            case 4: {
                float f = val == null ? 0.0f : ((Number)val).floatValue();
                fm.storeFloatField(field, f);
                break;
            }
            case 5: {
                int i = val == null ? 0 : ((Number)val).intValue();
                fm.storeIntField(field, i);
                break;
            }
            case 6: {
                long l = val == null ? 0L : ((Number)val).longValue();
                fm.storeLongField(field, l);
                break;
            }
            case 7: {
                short s = val == null ? (short)0 : ((Number)val).shortValue();
                fm.storeShortField(field, s);
                break;
            }
            case 9: {
                fm.storeStringField(field, (String)val);
                break;
            }
            default: {
                fm.storeObjectField(field, val);
            }
        }
    }

    void eraseFlush() {
        this._flags &= 0xFFFFFDFF;
        this._flags &= 0xFFFFF7FF;
        int fmds = this._meta.getFields().length;
        for (int i = 0; i < fmds; ++i) {
            this._flush.clear(i);
        }
    }

    void setLoaded(boolean val) {
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].isPrimaryKey()) continue;
            FieldMetaData cfr_ignored_0 = fmds[i];
            if (fmds[i].getManagement() != 3) continue;
            this.setLoaded(i, val);
        }
        if (!val) {
            this._flags &= 0xFFFFFFF7;
            this.setDirty(false);
        } else {
            this._flags |= 8;
        }
    }

    void setDirty(boolean val) {
        FieldMetaData[] fmds = this._meta.getFields();
        boolean update = !this.isNew() || this.isFlushed();
        for (int i = 0; i < fmds.length; ++i) {
            if (val && (!update || fmds[i].getUpdateStrategy() != 1)) {
                this._dirty.set(i);
                continue;
            }
            if (val) continue;
            this._flush.clear(i);
            this._dirty.clear(i);
        }
        if (val) {
            this._flags |= 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFields() {
        if (!this.isIntercepting()) {
            return;
        }
        this.fireLifecycleEvent(5);
        this.unproxyFields();
        this.lock();
        try {
            FieldMetaData[] fmds = this._meta.getFields();
            for (int i = 0; i < fmds.length; ++i) {
                if (fmds[i].isPrimaryKey() || fmds[i].getManagement() != 3) continue;
                this.replaceField(this._pc, ClearFieldManager.getInstance(), i);
            }
            this.setLoaded(false);
            this._version = null;
            this._loadVersion = null;
            if (this._fieldImpl != null) {
                Arrays.fill(this._fieldImpl, null);
            }
        }
        finally {
            this.unlock();
        }
        this.fireLifecycleEvent(6);
    }

    void saveFields(boolean immediate) {
        if (this._broker.getRestoreState() == 0 && (this._flags & 0x2000) == 0) {
            return;
        }
        this._flags |= 2;
        if (immediate) {
            int len = this._loaded.length();
            for (int i = 0; i < len; ++i) {
                this.saveField(i);
            }
            this._flags &= 0xFFFFFFFD;
            if (this._saved == null) {
                this._saved = new SaveFieldManager(this, this.getPersistenceCapable(), this._dirty);
            }
        }
    }

    private void saveField(int field) {
        if ((this._flags & 2) == 0) {
            return;
        }
        if (!this._loaded.get(field) && (this._flags & 0x2000) != 0 && this._meta.getField(field).getInverseMetaDatas().length > 0) {
            this.loadField(field, 0, false, false);
        }
        if (this._saved == null) {
            if (this._loaded.get(field)) {
                this._saved = new SaveFieldManager(this, null, this._dirty);
            } else {
                return;
            }
        }
        if (this._saved.saveField(field)) {
            this.provideField(this._pc, this._saved, field);
            this.replaceField(this._saved.getState(), this._saved, field);
        }
    }

    void clearSavedFields() {
        if (this.isIntercepting()) {
            this._flags &= 0xFFFFFFFD;
            this._saved = null;
        }
    }

    public SaveFieldManager getSaveFieldManager() {
        return this._saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreFields() {
        this.lock();
        try {
            if (this._saved == null) {
                if ((this._flags & 2) == 0) {
                    this.clearFields();
                } else {
                    this._loaded.andNot(this._loaded);
                }
            } else if (this._broker.getRestoreState() != 0) {
                int len = this._loaded.length();
                for (int i = 0; i < len; ++i) {
                    if (!this._loaded.get(i) || !this._saved.restoreField(i)) continue;
                    this.replaceField(this._pc, this._saved, i);
                }
                this._loaded.andNot(this._saved.getUnloaded());
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void proxyFields(boolean reset, boolean replaceNull) {
        if (this.getBroker().getAutoDetach() == 32) {
            return;
        }
        if (replaceNull) {
            replaceNull = !this._broker.getConfiguration().supportedOptions().contains("openjpa.option.NullContainer");
        }
        this.lock();
        try {
            for (FieldMetaData fmd : this._meta.getProxyFields()) {
                int index = fmd.getIndex();
                if (!this._loaded.get(index) || !this._dirty.get(index)) continue;
                this.provideField(this._pc, this._single, index);
                if (this._single.proxy(reset, replaceNull)) {
                    this.replaceField(this._pc, this._single, index);
                    continue;
                }
                this._single.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unproxyFields() {
        if ((this._flags & 0x4000) != 0) {
            return;
        }
        this.lock();
        try {
            int len = this._loaded.length();
            for (int i = 0; i < len; ++i) {
                this.provideField(this._pc, this._single, i);
                this._single.unproxy();
                this._single.releaseEmbedded();
                this._single.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preFlush(boolean logical, OpCallbacks call) {
        if ((this._flags & 0x400) != 0) {
            return;
        }
        if (this.isPersistent()) {
            this.fireLifecycleEvent(3);
            if (this.isDeleted()) {
                this.fireLifecycleEvent(7);
            } else if ((!this.isNew() || this.isFlushed()) && ImplHelper.getUpdateFields(this) != null) {
                this.fireLifecycleEvent(20);
            }
            this._flags |= 0x400;
        }
        this.lock();
        try {
            if (!logical) {
                this.assignObjectId(false, true);
            }
            int len = this._meta.getFields().length;
            for (int i = 0; i < len; ++i) {
                if (!logical && this.assignField(i, true) || this._flush.get(i) || !this._dirty.get(i)) continue;
                this.provideField(this._pc, this._single, i);
                if (this._single.preFlush(logical, call)) {
                    this.replaceField(this._pc, this._single, i);
                    continue;
                }
                this._single.clear();
            }
            this.dirtyCheck();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preDelete() {
        if ((this._flags & 0x100) == 0) {
            this._flags |= 0x100;
            try {
                this.fireLifecycleEvent(7);
            }
            finally {
                this._flags &= 0xFFFFFEFF;
            }
        }
    }

    void cascadeDelete(OpCallbacks call) {
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getCascadeDelete() == 0 && fmds[i].getKey().getCascadeDelete() == 0 && fmds[i].getElement().getCascadeDelete() == 0) continue;
            this._single.storeObjectField(i, this.fetchField(i, false));
            this._single.delete(call);
            this._single.clear();
        }
    }

    void cascadePersist(OpCallbacks call) {
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (!this._loaded.get(i) || fmds[i].getCascadePersist() != 1 && fmds[i].getKey().getCascadePersist() != 1 && fmds[i].getElement().getCascadePersist() != 1) continue;
            this._single.storeObjectField(i, this.fetchField(i, false));
            this._single.persist(call);
            this._single.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadFields(BitSet fields, FetchConfiguration fetch, int lockLevel, Object sdata) {
        FieldMetaData vfield;
        if (fields != null && (vfield = this._meta.getVersionField()) != null) {
            fields.clear(vfield.getIndex());
        }
        boolean ret = false;
        this.setLoading(true);
        try {
            FieldMetaData versionMeta;
            int len;
            int n = len = fields == null ? 0 : fields.length();
            if (len > 0) {
                if (fetch == null) {
                    fetch = this._broker.getFetchConfiguration();
                }
                if (!this._broker.getStoreManager().load(this, fields, fetch, lockLevel, sdata)) {
                    throw new ObjectNotFoundException(_loc.get("del-instance", this._meta.getDescribedType(), this._oid)).setFailedObject(this.getManagedInstance());
                }
                ret = true;
            }
            FieldMetaData fieldMetaData = versionMeta = this._meta != null ? this._meta.getVersionField() : null;
            if (this._loadVersion == null && versionMeta != null && !this._loaded.get(versionMeta.getIndex())) {
                this.syncVersion(sdata);
                ret = ret || this._loadVersion != null;
            }
        }
        finally {
            this.setLoading(false);
        }
        this.postLoad(-1, fetch);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadField(int field, int lockLevel, boolean forWrite, boolean fgs) {
        FetchConfiguration fetch = this._broker.getFetchConfiguration();
        FieldMetaData fmd = this._meta.getField(field);
        BitSet fields = null;
        if (fgs && (this._flags & 8) == 0) {
            fields = this.getUnloadedInternal(fetch, 0, null);
        }
        String lfg = fmd.getLoadFetchGroup();
        boolean lfgAdded = false;
        if (lfg != null) {
            FieldMetaData[] fmds = this._meta.getFields();
            for (int i = 0; i < fmds.length; ++i) {
                if (this._loaded.get(i) || i != field && !fmds[i].isInFetchGroup(lfg)) continue;
                if (fields == null) {
                    fields = new BitSet(fmds.length);
                }
                fields.set(i);
            }
            if (!fetch.hasFetchGroup(lfg)) {
                fetch.addFetchGroup(lfg);
                lfgAdded = true;
            }
        } else if (fmd.isInDefaultFetchGroup() && fields == null) {
            fields = this.getUnloadedInternal(fetch, 0, null);
        } else if (!this._loaded.get(fmd.getIndex())) {
            if (fields == null) {
                fields = new BitSet();
            }
            fields.set(fmd.getIndex());
        }
        try {
            this.loadFields(fields, fetch, lockLevel, null);
        }
        finally {
            if (lfgAdded) {
                fetch.removeFetchGroup(lfg);
            }
        }
    }

    void provideField(PersistenceCapable pc, FieldManager store, int field) {
        if (pc != null) {
            FieldManager beforeFM = this._fm;
            this._fm = store;
            pc.pcProvideField(field);
            if (beforeFM != null) {
                this._fm = beforeFM;
            }
        }
    }

    void replaceField(PersistenceCapable pc, FieldManager load, int field) {
        FieldManager beforeFM = this._fm;
        this._fm = load;
        pc.pcReplaceField(field);
        if (beforeFM != null) {
            this._fm = beforeFM;
        }
    }

    private void setLoaded(int field, boolean isLoaded) {
        int idx;
        if (this._loaded.get(field) == isLoaded) {
            return;
        }
        if (this._fieldImpl != null && (idx = this._meta.getExtraFieldDataIndex(field)) != -1) {
            this._fieldImpl[idx] = null;
        }
        if (isLoaded) {
            this._loaded.set(field);
        } else {
            this._loaded.clear(field);
        }
    }

    public void setPostLoadCallback(boolean enabled) {
        this.postLoadCallback = enabled;
    }

    private void postLoad(int field, FetchConfiguration fetch) {
        if ((this._flags & 8) != 0) {
            return;
        }
        if (field != -1 && this.isLoading()) {
            return;
        }
        LifecycleEventManager mgr = this._broker.getLifecycleEventManager();
        if (mgr == null || !mgr.hasLoadListeners(this.getManagedInstance(), this._meta)) {
            return;
        }
        if (fetch == null) {
            fetch = this._broker.getFetchConfiguration();
        }
        if (field != -1) {
            FieldMetaData fmd = this._meta.getField(field);
            if (fmd.isInDefaultFetchGroup() && fetch.hasFetchGroup("default") && this.postLoad("default", fetch)) {
                return;
            }
            String[] fgs = fmd.getCustomFetchGroups();
            for (int i = 0; i < fgs.length; ++i) {
                if (!fetch.hasFetchGroup(fgs[i]) || !this.postLoad(fgs[i], fetch)) continue;
                return;
            }
        } else {
            Iterator<String> itr = fetch.getFetchGroups().iterator();
            while (itr.hasNext()) {
                if (!this.postLoad(itr.next(), fetch)) continue;
                return;
            }
        }
    }

    private boolean postLoad(String fgName, FetchConfiguration fetch) {
        FetchGroup fg = this._meta.getFetchGroup(fgName);
        if (fg == null || !fg.isPostLoad()) {
            return false;
        }
        FieldMetaData[] fmds = this._meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (this._loaded.get(i) || !fmds[i].isInFetchGroup(fgName)) continue;
            return false;
        }
        this._flags |= 8;
        if (this.postLoadCallback) {
            this._broker.fireLifecycleEvent(this.getManagedInstance(), fetch, this._meta, 2);
        }
        return true;
    }

    private boolean syncVersion(Object sdata) {
        return this._broker.getStoreManager().syncVersion(this, sdata);
    }

    @Override
    public boolean isVersionCheckRequired() {
        if ((this._flags & 0x8000) != 0) {
            return true;
        }
        if (!this._broker.getOptimistic() && !this._broker.getConfiguration().getCompatibilityInstance().getNonOptimisticVersionCheck()) {
            return false;
        }
        return this._state.isVersionCheckRequired(this);
    }

    void setCheckVersion(boolean versionCheck) {
        this._flags = versionCheck ? (this._flags |= 0x8000) : (this._flags &= 0xFFFF7FFF);
    }

    @Override
    public boolean isVersionUpdateRequired() {
        return (this._flags & 0x10000) > 0;
    }

    void setUpdateVersion(boolean versionUpdate) {
        this._flags = versionUpdate ? (this._flags |= 0x10000) : (this._flags &= 0xFFFEFFFF);
    }

    protected RuntimeException translate(RuntimeException re) {
        RuntimeExceptionTranslator trans = this._broker.getInstanceExceptionTranslator();
        return trans == null ? re : trans.translate(re);
    }

    protected void lock() {
        if (this._instanceLock != null) {
            this._instanceLock.lock();
        }
    }

    protected void unlock() {
        if (this._instanceLock != null) {
            this._instanceLock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this._broker);
        oos.defaultWriteObject();
        oos.writeObject(this._meta.getDescribedType());
        this.writePC(oos, this._pc);
    }

    void writePC(ObjectOutputStream oos, PersistenceCapable pc) throws IOException {
        if (!Serializable.class.isAssignableFrom(this._meta.getDescribedType())) {
            throw new NotSerializableException(this._meta.getDescribedType().getName());
        }
        oos.writeObject(pc);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._broker = (BrokerImpl)in.readObject();
        in.defaultReadObject();
        Class managedType = (Class)in.readObject();
        this._meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(managedType, null, true);
        this._pc = this.readPC(in);
    }

    PersistenceCapable readPC(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Object o = in.readObject();
        if (o == null) {
            return null;
        }
        PersistenceCapable pc = !(o instanceof PersistenceCapable) ? ImplHelper.toPersistenceCapable(o, this) : (PersistenceCapable)o;
        pc.pcReplaceStateManager(this);
        return pc;
    }

    public List<FieldMetaData> getMappedByIdFields() {
        return this._mappedByIdFields;
    }

    public boolean requiresFetch(FieldMetaData fmd) {
        return this._broker.getFetchConfiguration().requiresFetch(fmd) != 0;
    }

    public void setPc(PersistenceCapable pc) {
        this._pc = pc;
    }

    public void setBroker(BrokerImpl ctx) {
        this._broker = ctx;
    }
}

