/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.ConnectorService;
import org.apache.syncope.common.to.BulkAction;
import org.apache.syncope.common.to.BulkActionRes;
import org.apache.syncope.common.to.ConnBundleTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.types.ConnConfProperty;
import org.springframework.web.client.RestTemplate;

public class ConnectorServiceProxy
extends SpringServiceProxy
implements ConnectorService {
    public ConnectorServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public Response create(ConnInstanceTO connInstanceTO) {
        ConnInstanceTO response = (ConnInstanceTO)this.getRestTemplate().postForObject(this.baseUrl + "connector/create.json", (Object)connInstanceTO, ConnInstanceTO.class, new Object[0]);
        URI location = URI.create(this.baseUrl + "connector/read/" + response.getId() + ".json");
        return Response.created((URI)location).build();
    }

    public void update(Long connInstanceId, ConnInstanceTO connInstanceTO) {
        this.getRestTemplate().postForObject(this.baseUrl + "connector/update.json", (Object)connInstanceTO, ConnInstanceTO.class, new Object[0]);
    }

    public void delete(Long connInstanceId) {
        this.getRestTemplate().getForObject(this.baseUrl + "connector/delete/{connInstanceId}.json", ConnInstanceTO.class, new Object[]{connInstanceId});
    }

    public List<ConnInstanceTO> list(String lang) {
        String param = lang == null ? "" : "?lang=" + lang;
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "connector/list.json" + param, ConnInstanceTO[].class, new Object[0]));
    }

    public ConnInstanceTO read(Long connInstanceId) {
        return (ConnInstanceTO)this.getRestTemplate().getForObject(this.baseUrl + "connector/read/{connInstanceId}", ConnInstanceTO.class, new Object[]{connInstanceId});
    }

    public List<ConnBundleTO> getBundles(String lang) {
        String param = lang == null ? "" : "?lang=" + lang;
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "connector/bundle/list.json" + param, ConnBundleTO[].class, new Object[0]));
    }

    public List<SchemaTO> getSchemaNames(Long connInstanceId, ConnInstanceTO connInstanceTO, boolean showall) {
        String queryString = "?showall=" + showall;
        List<Object> response = Arrays.asList((Object[])this.getRestTemplate().postForObject(this.baseUrl + "connector/schema/list" + queryString, (Object)connInstanceTO, String[].class, new Object[0]));
        ArrayList<SchemaTO> schemaNames = new ArrayList<SchemaTO>();
        for (String string : response) {
            SchemaTO schemaTO = new SchemaTO();
            schemaTO.setName(string);
            schemaNames.add(schemaTO);
        }
        return schemaNames;
    }

    public List<ConnConfProperty> getConfigurationProperties(Long connInstanceId) {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "connector/{connInstanceId}/configurationProperty/list", ConnConfProperty[].class, new Object[]{connInstanceId}));
    }

    public boolean check(ConnInstanceTO connInstanceTO) {
        return (Boolean)this.getRestTemplate().postForObject(this.baseUrl + "connector/check.json", (Object)connInstanceTO, Boolean.class, new Object[0]);
    }

    public ConnInstanceTO readByResource(String resourceName) {
        return (ConnInstanceTO)this.getRestTemplate().getForObject(this.baseUrl + "connector/{resourceName}/readByResource", ConnInstanceTO.class, new Object[]{resourceName});
    }

    public void reload() {
        this.getRestTemplate().postForLocation(this.baseUrl + "connector/reload", null, new Object[0]);
    }

    public BulkActionRes bulkAction(BulkAction bulkAction) {
        return (BulkActionRes)this.getRestTemplate().postForObject(this.baseUrl + "connector/bulk", (Object)bulkAction, BulkActionRes.class, new Object[0]);
    }
}

