/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang.StringUtils;

public class ProcessParser
implements BpmnXMLConstants {
    public Process parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        Process process = null;
        if (StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "id"))) {
            String candidateGroupsString;
            String candidateUsersString;
            String processId = xtr.getAttributeValue(null, "id");
            process = new Process();
            process.setId(processId);
            BpmnXMLUtil.addXMLLocation((BaseElement)process, xtr);
            process.setName(xtr.getAttributeValue(null, "name"));
            if (StringUtils.isNotEmpty((String)xtr.getAttributeValue(null, "isExecutable"))) {
                process.setExecutable(Boolean.parseBoolean(xtr.getAttributeValue(null, "isExecutable")));
            }
            if (StringUtils.isNotEmpty((String)(candidateUsersString = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateStarterUsers")))) {
                List<String> candidateUsers = BpmnXMLUtil.parseDelimitedList(candidateUsersString);
                process.setCandidateStarterUsers(candidateUsers);
            }
            if (StringUtils.isNotEmpty((String)(candidateGroupsString = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateStarterGroups")))) {
                List<String> candidateGroups = BpmnXMLUtil.parseDelimitedList(candidateGroupsString);
                process.setCandidateStarterGroups(candidateGroups);
            }
            if (process.isExecutable()) {
                model.getProcesses().add(process);
            }
        }
        return process;
    }
}

