/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.apache.commons.lang.StringUtils;

public class MultiInstanceExport
implements BpmnXMLConstants {
    public static void writeMultiInstance(Activity activity, XMLStreamWriter xtw) throws Exception {
        MultiInstanceLoopCharacteristics multiInstanceObject;
        if (activity.getLoopCharacteristics() != null && (StringUtils.isNotEmpty((String)(multiInstanceObject = activity.getLoopCharacteristics()).getLoopCardinality()) || StringUtils.isNotEmpty((String)multiInstanceObject.getInputDataItem()) || StringUtils.isNotEmpty((String)multiInstanceObject.getCompletionCondition()))) {
            xtw.writeStartElement("multiInstanceLoopCharacteristics");
            BpmnXMLUtil.writeDefaultAttribute("isSequential", String.valueOf(multiInstanceObject.isSequential()).toLowerCase(), xtw);
            if (StringUtils.isNotEmpty((String)multiInstanceObject.getInputDataItem())) {
                BpmnXMLUtil.writeQualifiedAttribute("collection", multiInstanceObject.getInputDataItem(), xtw);
            }
            if (StringUtils.isNotEmpty((String)multiInstanceObject.getElementVariable())) {
                BpmnXMLUtil.writeQualifiedAttribute("elementVariable", multiInstanceObject.getElementVariable(), xtw);
            }
            if (StringUtils.isNotEmpty((String)multiInstanceObject.getLoopCardinality())) {
                xtw.writeStartElement("loopCardinality");
                xtw.writeCharacters(multiInstanceObject.getLoopCardinality());
                xtw.writeEndElement();
            }
            if (StringUtils.isNotEmpty((String)multiInstanceObject.getCompletionCondition())) {
                xtw.writeStartElement("completionCondition");
                xtw.writeCharacters(multiInstanceObject.getCompletionCondition());
                xtw.writeEndElement();
            }
            xtw.writeEndElement();
        }
    }
}

