/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChildElementParser
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseChildElementParser.class);
    protected BaseElement parentElement;

    public abstract String getElementName();

    public abstract void parseChildElement(XMLStreamReader var1, BaseElement var2, BpmnModel var3) throws Exception;

    protected void parseChildElements(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model, BaseChildElementParser parser) throws Exception {
        this.parentElement = parentElement;
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if (!parser.getElementName().equals(xtr.getLocalName())) continue;
                parser.parseChildElement(xtr, parentElement, model);
                continue;
            }
            if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }
}

