/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.RetryInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaRetryInterceptor
extends RetryInterceptor {
    private final Logger log = LoggerFactory.getLogger(JtaRetryInterceptor.class);
    protected final TransactionManager transactionManager;

    public JtaRetryInterceptor(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public <T> T execute(Command<T> command) {
        if (this.calledInsideTransaction()) {
            this.log.trace("Called inside transaction, skipping the retry interceptor.");
            return this.next.execute(command);
        }
        return super.execute(command);
    }

    protected boolean calledInsideTransaction() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new ActivitiException("Could not determine the current status of the transaction manager: " + e.getMessage(), e);
        }
    }
}

