/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.FailedJobListener;
import org.activiti.engine.impl.jobexecutor.JobExecutorContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobsCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecuteJobsCmd.class);
    protected String jobId;

    public ExecuteJobsCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobEntity job;
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing job {}", (Object)this.jobId);
        }
        if ((job = commandContext.getJobEntityManager().findJobById(this.jobId)) == null) {
            throw new JobNotFoundException(this.jobId);
        }
        JobExecutorContext jobExecutorContext = Context.getJobExecutorContext();
        if (jobExecutorContext != null) {
            jobExecutorContext.setCurrentJob(job);
        }
        try {
            job.execute(commandContext);
        }
        catch (RuntimeException exception) {
            CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew();
            commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, new FailedJobListener(commandExecutor, this.jobId, exception));
            throw exception;
        }
        finally {
            if (jobExecutorContext != null) {
                jobExecutorContext.setCurrentJob(null);
            }
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }
}

