/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.filters;

import java.net.URI;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.util.UriComponentsBuilder;

public class QueryParamToRequestHeaderFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    public QueryParamToRequestHeaderFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        return (exchange, chain) -> {
            ServerHttpRequest mutatedRequest;
            ServerHttpRequest originalRequest = exchange.getRequest();
            if (originalRequest.getQueryParams().isEmpty()) {
                mutatedRequest = originalRequest;
            } else {
                URI newUri = UriComponentsBuilder.fromUri((URI)originalRequest.getURI()).replaceQueryParam(config.getName(), new Object[0]).build().toUri();
                mutatedRequest = exchange.getRequest().mutate().uri(newUri).headers(headers -> headers.addAll(config.getName(), (List)originalRequest.getQueryParams().get((Object)config.getName()))).build();
            }
            return chain.filter(exchange.mutate().request(mutatedRequest).build());
        };
    }
}

