/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.sra.filters;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class ClientCertsToRequestHeaderFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCertsToRequestHeaderFilterFactory.class);

    public ClientCertsToRequestHeaderFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    public GatewayFilter apply(AbstractGatewayFilterFactory.NameConfig config) {
        return (exchange, chain) -> {
            ServerHttpRequest mutatedRequest;
            ServerHttpRequest originalRequest = exchange.getRequest();
            if (originalRequest.getSslInfo() != null && ArrayUtils.isNotEmpty((Object[])originalRequest.getSslInfo().getPeerCertificates())) {
                LOG.debug("Client certificates found in original request: {}", (Object)originalRequest.getSslInfo().getPeerCertificates().length);
                ArrayList<String> certs = new ArrayList<String>();
                for (X509Certificate cert : originalRequest.getSslInfo().getPeerCertificates()) {
                    try {
                        certs.add(Base64.getEncoder().encodeToString(cert.getEncoded()));
                    }
                    catch (CertificateEncodingException e) {
                        LOG.error("Could not encode one of client certificates", (Throwable)e);
                    }
                }
                mutatedRequest = originalRequest.mutate().headers(headers -> headers.addAll(config.getName(), certs)).sslInfo(null).build();
            } else {
                mutatedRequest = originalRequest;
            }
            return chain.filter(exchange.mutate().request(mutatedRequest).build());
        };
    }
}

