/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.buildtools;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class H2StartStopListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(H2StartStopListener.class);
    private static final String H2_TESTDB = "h2TestDb";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        try {
            Server h2TestDb = new Server();
            h2TestDb.runTool(new String[]{"-tcp", "-tcpDaemon", "-web", "-webDaemon", "-webPort", sce.getServletContext().getInitParameter("testdb.webport")});
            context.setAttribute(H2_TESTDB, (Object)h2TestDb);
        }
        catch (SQLException e) {
            LOG.error("Could not start H2 test db", (Throwable)e);
        }
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
        DataSource datasource = (DataSource)ctx.getBean(DataSource.class);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DataSourceUtils.getConnection((DataSource)datasource);
            stmt = conn.createStatement();
            stmt.executeUpdate("RUNSCRIPT FROM 'classpath:/testdb.sql'");
        }
        catch (Exception e) {
            LOG.error("While loading data into testdb", (Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)datasource);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        Server h2TestDb = (Server)context.getAttribute(H2_TESTDB);
        if (h2TestDb != null) {
            h2TestDb.shutdown();
        }
    }
}

