/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.buildtools;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.schema.registries.SchemaLoader;
import org.apache.syncope.buildtools.JarSchemaLdifExtractor;
import org.apache.syncope.buildtools.LdifURLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDSStartStopListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDSStartStopListener.class);
    private DirectoryService service;
    private LdapServer server;

    private void initSchemaPartition(ServletContext servletContext) throws Exception {
        Pattern sharedLdapSchemaManagerPattern = Pattern.compile(".*apacheds-all-.*\\.jar");
        File found = null;
        for (File jarFile : new File(servletContext.getRealPath("/WEB-INF/lib")).listFiles()) {
            if (!sharedLdapSchemaManagerPattern.matcher(jarFile.getAbsolutePath()).matches()) continue;
            found = jarFile;
        }
        if (found == null) {
            throw new RuntimeException("No apache-ds-all JAR found under WEB-INF/lib");
        }
        SchemaPartition schemaPartition = this.service.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.service.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + "/schema");
        File schemaRepository = new File(workingDirectory, "schema");
        JarSchemaLdifExtractor extractor = new JarSchemaLdifExtractor(new File(workingDirectory), found);
        extractor.extractOrCopy(true);
        schemaPartition.setWrappedPartition((Partition)ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        this.service.setSchemaManager((SchemaManager)schemaManager);
        schemaManager.enable(new String[]{"nis"});
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager((SchemaManager)schemaManager);
        List errors = schemaManager.getErrors();
        if (!errors.isEmpty()) {
            throw new RuntimeException("Schema load failed : " + errors);
        }
    }

    private Partition addPartition(String partitionId, String partitionDn) throws Exception {
        JdbmPartition partition = new JdbmPartition();
        partition.setId(partitionId);
        partition.setPartitionDir(new File(this.service.getWorkingDirectory(), partitionId));
        partition.setSuffix(partitionDn);
        this.service.addPartition((Partition)partition);
        return partition;
    }

    private void addIndex(Partition partition, String ... attrs) {
        HashSet<JdbmIndex> indexedAttributes = new HashSet<JdbmIndex>();
        for (String attribute : attrs) {
            indexedAttributes.add(new JdbmIndex(attribute));
        }
        ((JdbmPartition)partition).setIndexedAttributes(indexedAttributes);
    }

    private void initDirectoryService(ServletContext servletContext, File workDir, boolean loadDefaultContent) throws Exception {
        this.service = new DefaultDirectoryService();
        this.service.setWorkingDirectory(workDir);
        this.initSchemaPartition(servletContext);
        Partition systemPartition = this.addPartition("system", "ou=system");
        this.service.setSystemPartition(systemPartition);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
        Partition ispPartition = this.addPartition("isp", "o=isp");
        this.addIndex(ispPartition, "objectClass", "ou", "uid");
        this.service.startup();
        if (loadDefaultContent) {
            LdifURLLoader contentLoader = new LdifURLLoader(this.service.getAdminSession(), servletContext.getResource("/WEB-INF/classes/content.ldif"));
            int numEntries = contentLoader.execute();
            LOG.info("Successfully created {} entries", (Object)numEntries);
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        ClonedServerEntry result;
        boolean loadDefaultContent;
        File workDir = (File)sce.getServletContext().getAttribute("javax.servlet.context.tempdir");
        boolean bl = loadDefaultContent = !(workDir = new File(workDir, "server-work")).exists();
        if (loadDefaultContent && !workDir.mkdirs()) {
            throw new RuntimeException("Could not create " + workDir.getAbsolutePath());
        }
        try {
            this.initDirectoryService(sce.getServletContext(), workDir, loadDefaultContent);
            this.server = new LdapServer();
            this.server.setTransports(new Transport[]{new TcpTransport(Integer.valueOf(sce.getServletContext().getInitParameter("testds.port")).intValue())});
            this.server.setDirectoryService(this.service);
            this.server.start();
            sce.getServletContext().setAttribute(DirectoryService.JNDI_KEY, (Object)this.service);
            result = this.service.getAdminSession().lookup(new DN("o=isp"));
        }
        catch (Exception e) {
            LOG.error("Fatal error in context init", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (result == null) {
            throw new RuntimeException("Base DN not found");
        }
        LOG.info("ApacheDS startup completed succesfully");
    }

    public void contextDestroyed(ServletContextEvent scEvent) {
        try {
            if (this.server != null) {
                this.server.stop();
            }
            if (this.service != null) {
                this.service.shutdown();
            }
        }
        catch (Exception e) {
            LOG.error("Fatal error in context shutdown", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

