/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.Member;
import org.apache.syncope.ext.scimv2.api.data.SCIMGroup;
import org.apache.syncope.ext.scimv2.api.data.SCIMPatchOp;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.service.SCIMGroupService;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.PatchOp;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.apache.syncope.ext.scimv2.cxf.service.AbstractSCIMService;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

public class SCIMGroupServiceImpl
extends AbstractSCIMService<SCIMGroup>
implements SCIMGroupService {
    public SCIMGroupServiceImpl(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        super(userDAO, groupDAO, anyObjectDAO, userLogic, groupLogic, anyObjectLogic, binder, confManager);
    }

    private void changeMembership(String user, String group, PatchOp patchOp) {
        UserUR req = (UserUR)new UserUR.Builder(user).membership((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(group).operation(patchOp == PatchOp.remove ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).build()).build();
        try {
            this.userLogic.update(req, false);
        }
        catch (Exception e) {
            LOG.error("While applying {} on membership of {} to {}", new Object[]{patchOp, group, user, e});
        }
    }

    public Response create(SCIMGroup group) {
        ProvisioningResult result = this.groupLogic.create(this.binder.toGroupCR(group), false);
        group.getMembers().forEach(member -> this.changeMembership(member.getValue(), ((GroupTO)result.getEntity()).getKey(), PatchOp.add));
        return this.createResponse(((GroupTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMGroup((GroupTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((GroupTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()));
    }

    public SCIMGroup get(String id, String attributes, String excludedAttributes) {
        return this.binder.toSCIMGroup(this.groupLogic.read(id), this.uriInfo.getAbsolutePathBuilder().build(new Object[0]).toASCIIString(), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
    }

    private Set<String> members(String group) {
        HashSet<String> members = new HashSet<String>();
        MembershipCond membCond = new MembershipCond();
        membCond.setGroup(group);
        SearchCond searchCond = SearchCond.of((AbstractSearchCond)membCond);
        long count = this.userLogic.search(searchCond, (Pageable)PageRequest.of((int)0, (int)1), "/", true, false).getTotalElements();
        int page = 0;
        while ((long)page <= count / 500L) {
            members.addAll(this.userLogic.search(searchCond, (Pageable)PageRequest.of((int)page, (int)500, (Sort)DAO.DEFAULT_SORT), "/", true, false).get().map(AnyTO::getKey).collect(Collectors.toSet()));
            ++page;
        }
        return members;
    }

    public Response update(String id, SCIMPatchOp patch) {
        Response.ResponseBuilder builder = this.checkETag(Resource.Group.schema(), id);
        if (builder != null) {
            return builder.build();
        }
        patch.getOperations().forEach(op -> {
            if (op.getPath() != null && "members".equals(op.getPath().getAttribute())) {
                if (CollectionUtils.isEmpty((Collection)op.getValue())) {
                    this.members(id).stream().filter(member -> op.getPath().getFilter() == null ? true : BooleanUtils.toBoolean((String)JexlUtils.evaluateExpr((String)SCIMDataBinder.filter2JexlExpression((String)op.getPath().getFilter()), (JexlContext)new MapContext(Map.of("value", member))).toString())).forEach(member -> this.changeMembership((String)member, id, op.getOp()));
                } else {
                    op.getValue().stream().map(Member.class::cast).forEach(member -> this.changeMembership(member.getValue(), id, op.getOp()));
                }
            } else {
                this.groupLogic.update(this.binder.toGroupUR(this.groupLogic.read(id), op), false);
            }
        });
        return this.updateResponse(id, null, true);
    }

    public Response replace(String id, SCIMGroup group) {
        if (!id.equals(group.getId())) {
            throw new BadRequestException(ErrorType.invalidPath, "Expected " + id + ", found " + group.getId());
        }
        Response.ResponseBuilder builder = this.checkETag(Resource.Group.schema(), id);
        if (builder != null) {
            return builder.build();
        }
        Set<String> beforeMembers = this.members(id);
        GroupUR req = AnyOperations.diff((GroupTO)this.binder.toGroupTO(group, true), (GroupTO)this.groupLogic.read(id), (boolean)false);
        req.getResources().clear();
        req.getAuxClasses().clear();
        ProvisioningResult result = this.groupLogic.update(req, false);
        HashSet afterMembers = new HashSet();
        group.getMembers().forEach(member -> {
            afterMembers.add(member.getValue());
            if (!beforeMembers.contains(member.getValue())) {
                this.changeMembership(member.getValue(), ((GroupTO)result.getEntity()).getKey(), PatchOp.add);
            }
        });
        beforeMembers.stream().filter(member -> !afterMembers.contains(member)).forEach(user -> this.changeMembership((String)user, ((GroupTO)result.getEntity()).getKey(), PatchOp.remove));
        return this.updateResponse(((GroupTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMGroup((GroupTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((GroupTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()), false);
    }

    @Override
    protected SCIMResource getResource(String key) {
        return this.binder.toSCIMGroup(this.groupLogic.read(key), this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0]).toASCIIString(), List.of(), List.of());
    }

    public Response delete(String id) {
        Response.ResponseBuilder builder = this.checkETag(Resource.Group.schema(), id);
        if (builder != null) {
            return builder.build();
        }
        this.anyLogic(Resource.Group.name()).delete(id, false);
        return Response.noContent().build();
    }

    public ListResponse<SCIMGroup> search(String attributes, String excludedAttributes, String filter, String sortBy, SortOrder sortOrder, Integer startIndex, Integer count) {
        SCIMSearchRequest request = new SCIMSearchRequest(filter, sortBy, sortOrder, startIndex, count);
        if (attributes != null) {
            request.getAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))));
        }
        if (excludedAttributes != null) {
            request.getExcludedAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
        }
        return this.doSearch(Resource.Group.name(), request);
    }

    public ListResponse<SCIMGroup> search(SCIMSearchRequest request) {
        return this.doSearch(Resource.Group.name(), request);
    }
}

