/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf.service;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.StatusRType;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.ListResponse;
import org.apache.syncope.ext.scimv2.api.data.SCIMPatchOp;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;
import org.apache.syncope.ext.scimv2.api.data.SCIMSearchRequest;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;
import org.apache.syncope.ext.scimv2.api.service.SCIMUserService;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.apache.syncope.ext.scimv2.api.type.SortOrder;
import org.apache.syncope.ext.scimv2.cxf.service.AbstractSCIMService;

public class SCIMUserServiceImpl
extends AbstractSCIMService<SCIMUser>
implements SCIMUserService {
    public SCIMUserServiceImpl(UserDAO userDAO, GroupDAO groupDAO, UserLogic userLogic, GroupLogic groupLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        super(userDAO, groupDAO, userLogic, groupLogic, binder, confManager);
    }

    public Response create(SCIMUser user) {
        ProvisioningResult result = this.userLogic.create(this.binder.toUserCR(user), false);
        return this.createResponse(((UserTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMUser((UserTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((UserTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()));
    }

    public SCIMUser get(String id, String attributes, String excludedAttributes) {
        return this.binder.toSCIMUser(this.userLogic.read(id), this.uriInfo.getAbsolutePathBuilder().build(new Object[0]).toASCIIString(), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))), List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
    }

    public Response update(String id, SCIMPatchOp patch) {
        Response.ResponseBuilder builder = this.checkETag(Resource.User, id);
        if (builder != null) {
            return builder.build();
        }
        patch.getOperations().forEach(op -> {
            Pair update = this.binder.toUserUpdate(this.userLogic.read(id), this.userDAO.findAllResourceKeys(id), op);
            this.userLogic.update((UserUR)update.getLeft(), false);
            Optional.ofNullable((StatusR)update.getRight()).ifPresent(statusR -> this.userLogic.status(statusR, false));
        });
        return this.updateResponse(id, null, true);
    }

    public Response replace(String id, SCIMUser user) {
        if (!id.equals(user.getId())) {
            throw new BadRequestException(ErrorType.invalidPath, "Expected " + id + ", found " + user.getId());
        }
        Response.ResponseBuilder builder = this.checkETag(Resource.User, id);
        if (builder != null) {
            return builder.build();
        }
        UserTO before = this.userLogic.read(id);
        UserUR req = AnyOperations.diff((UserTO)this.binder.toUserTO(user, true), (UserTO)before, (boolean)false);
        req.getResources().clear();
        req.getAuxClasses().clear();
        req.getRelationships().clear();
        req.getRoles().clear();
        req.getLinkedAccounts().clear();
        ProvisioningResult result = this.userLogic.update(req, false);
        if (before.isSuspended() == user.isActive()) {
            StatusR statusR = new StatusR.Builder(before.getKey(), user.isActive() ? StatusRType.REACTIVATE : StatusRType.SUSPEND).build();
            this.userLogic.status(statusR, false);
        }
        return this.updateResponse(((UserTO)result.getEntity()).getKey(), (SCIMResource)this.binder.toSCIMUser((UserTO)result.getEntity(), this.uriInfo.getAbsolutePathBuilder().path(((UserTO)result.getEntity()).getKey()).build(new Object[0]).toASCIIString(), List.of(), List.of()), false);
    }

    @Override
    protected SCIMResource getResource(String key) {
        return this.binder.toSCIMUser(this.userLogic.read(key), this.uriInfo.getAbsolutePathBuilder().path(key).build(new Object[0]).toASCIIString(), List.of(), List.of());
    }

    public Response delete(String id) {
        Response.ResponseBuilder builder = this.checkETag(Resource.User, id);
        if (builder != null) {
            return builder.build();
        }
        this.anyLogic(Resource.User).delete(id, false);
        return Response.noContent().build();
    }

    public ListResponse<SCIMUser> search(String attributes, String excludedAttributes, String filter, String sortBy, SortOrder sortOrder, Integer startIndex, Integer count) {
        SCIMSearchRequest request = new SCIMSearchRequest(filter, sortBy, sortOrder, startIndex, count);
        if (attributes != null) {
            request.getAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)attributes, (char)','))));
        }
        if (excludedAttributes != null) {
            request.getExcludedAttributes().addAll(List.of(ArrayUtils.nullToEmpty((String[])StringUtils.split((String)excludedAttributes, (char)','))));
        }
        return this.doSearch(Resource.User, request);
    }

    public ListResponse<SCIMUser> search(SCIMSearchRequest request) {
        return this.doSearch(Resource.User, request);
    }
}

