/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.StringReplacePatchItem;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.scim.SCIMComplexConf;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.scim.SCIMEnterpriseUserConf;
import org.apache.syncope.common.lib.scim.SCIMExtensionAnyObjectConf;
import org.apache.syncope.common.lib.scim.SCIMManagerConf;
import org.apache.syncope.common.lib.scim.SCIMUserAddressConf;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.StatusRType;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.ext.scimv2.api.BadRequestException;
import org.apache.syncope.ext.scimv2.api.data.Member;
import org.apache.syncope.ext.scimv2.api.data.Meta;
import org.apache.syncope.ext.scimv2.api.data.SCIMAnyObject;
import org.apache.syncope.ext.scimv2.api.data.SCIMComplexValue;
import org.apache.syncope.ext.scimv2.api.data.SCIMEnterpriseInfo;
import org.apache.syncope.ext.scimv2.api.data.SCIMExtensionInfo;
import org.apache.syncope.ext.scimv2.api.data.SCIMGroup;
import org.apache.syncope.ext.scimv2.api.data.SCIMPatchOp;
import org.apache.syncope.ext.scimv2.api.data.SCIMPatchOperation;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserAddress;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserManager;
import org.apache.syncope.ext.scimv2.api.data.SCIMUserName;
import org.apache.syncope.ext.scimv2.api.data.Value;
import org.apache.syncope.ext.scimv2.api.type.ErrorType;
import org.apache.syncope.ext.scimv2.api.type.Function;
import org.apache.syncope.ext.scimv2.api.type.PatchOp;
import org.apache.syncope.ext.scimv2.api.type.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class SCIMDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(SCIMDataBinder.class);
    protected final SCIMConfManager confManager;
    protected final UserLogic userLogic;
    protected final AuthDataAccessor authDataAccessor;
    protected final GroupDAO groupDAO;

    public static String filter2JexlExpression(String filter) {
        int pr;
        String jexlExpression = filter.replace(" co ", " =~ ").replace(" sw ", " =^ ").replace(" ew ", " =$ ");
        boolean endsWithPR = jexlExpression.endsWith(" pr");
        int n = pr = endsWithPR ? jexlExpression.indexOf(" pr") : jexlExpression.indexOf(" pr ");
        while (pr != -1) {
            String before = jexlExpression.substring(0, pr);
            int start = before.indexOf(32) == -1 ? 0 : jexlExpression.substring(0, pr).lastIndexOf(32, pr) + 1;
            String literal = jexlExpression.substring(start, pr);
            endsWithPR = jexlExpression.endsWith(" pr");
            jexlExpression = jexlExpression.replace(literal + " pr" + (endsWithPR ? "" : " "), "not(empty(" + literal + "))" + (endsWithPR ? "" : " "));
            pr = endsWithPR ? jexlExpression.indexOf(" pr") : jexlExpression.indexOf(" pr ");
        }
        return jexlExpression;
    }

    public SCIMDataBinder(SCIMConfManager confManager, UserLogic userLogic, AuthDataAccessor authDataAccessor, GroupDAO groupDAO) {
        this.confManager = confManager;
        this.userLogic = userLogic;
        this.authDataAccessor = authDataAccessor;
        this.groupDAO = groupDAO;
    }

    protected <E extends Enum<?>> void fill(Map<String, Attr> attrs, List<SCIMComplexConf<E>> confs, List<SCIMComplexValue> values) {
        confs.forEach(conf -> {
            SCIMComplexValue value = new SCIMComplexValue();
            if (conf.getValue() != null && attrs.containsKey(conf.getValue())) {
                value.setValue((String)((Attr)attrs.get(conf.getValue())).getValues().get(0));
            }
            if (conf.getDisplay() != null && attrs.containsKey(conf.getDisplay())) {
                value.setDisplay((String)((Attr)attrs.get(conf.getDisplay())).getValues().get(0));
            }
            if (conf.getType() != null) {
                value.setType(conf.getType().name());
            }
            value.setPrimary(conf.isPrimary());
            if (!value.isEmpty()) {
                values.add(value);
            }
        });
    }

    protected boolean output(List<String> attributes, List<String> excludedAttributes, String schema) {
        return !(!attributes.isEmpty() && !attributes.contains(schema) || !excludedAttributes.isEmpty() && excludedAttributes.contains(schema));
    }

    protected <T> T output(List<String> attributes, List<String> excludedAttributes, String schema, T value) {
        return (T)(this.output(attributes, excludedAttributes, schema) ? value : null);
    }

    public SCIMUser toSCIMUser(UserTO userTO, String location, List<String> attributes, List<String> excludedAttributes) {
        SCIMConf conf = this.confManager.get();
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(Resource.User.schema());
        if (conf.getEnterpriseUserConf() != null) {
            schemas.add(Resource.EnterpriseUser.schema());
        }
        if (conf.getExtensionUserConf() != null) {
            schemas.add(Resource.ExtensionUser.schema());
        }
        SCIMUser user = new SCIMUser(userTO.getKey(), schemas, new Meta(Resource.User.name(), userTO.getCreationDate(), Optional.ofNullable(userTO.getLastChangeDate()).orElse(userTO.getCreationDate()), userTO.getETagValue(), location), this.output(attributes, excludedAttributes, "userName", userTO.getUsername()), Boolean.valueOf(!userTO.isSuspended()));
        HashMap<String, Attr> attrs = new HashMap<String, Attr>();
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)userTO.getPlainAttrs()));
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)userTO.getDerAttrs()));
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)userTO.getVirAttrs()));
        attrs.put("username", new Attr.Builder("username").value(userTO.getUsername()).build());
        if (conf.getUserConf() != null) {
            if (this.output(attributes, excludedAttributes, "externalId") && conf.getUserConf().getExternalId() != null && attrs.containsKey(conf.getUserConf().getExternalId())) {
                user.setExternalId((String)((Attr)attrs.get(conf.getUserConf().getExternalId())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "name") && conf.getUserConf().getName() != null) {
                SCIMUserName name = new SCIMUserName();
                if (conf.getUserConf().getName().getFamilyName() != null && attrs.containsKey(conf.getUserConf().getName().getFamilyName())) {
                    name.setFamilyName((String)((Attr)attrs.get(conf.getUserConf().getName().getFamilyName())).getValues().get(0));
                }
                if (conf.getUserConf().getName().getFormatted() != null && attrs.containsKey(conf.getUserConf().getName().getFormatted())) {
                    name.setFormatted((String)((Attr)attrs.get(conf.getUserConf().getName().getFormatted())).getValues().get(0));
                }
                if (conf.getUserConf().getName().getGivenName() != null && attrs.containsKey(conf.getUserConf().getName().getGivenName())) {
                    name.setGivenName((String)((Attr)attrs.get(conf.getUserConf().getName().getGivenName())).getValues().get(0));
                }
                if (conf.getUserConf().getName().getHonorificPrefix() != null && attrs.containsKey(conf.getUserConf().getName().getHonorificPrefix())) {
                    name.setHonorificPrefix((String)((Attr)attrs.get(conf.getUserConf().getName().getHonorificPrefix())).getValues().get(0));
                }
                if (conf.getUserConf().getName().getHonorificSuffix() != null && attrs.containsKey(conf.getUserConf().getName().getHonorificSuffix())) {
                    name.setHonorificSuffix((String)((Attr)attrs.get(conf.getUserConf().getName().getHonorificSuffix())).getValues().get(0));
                }
                if (conf.getUserConf().getName().getMiddleName() != null && attrs.containsKey(conf.getUserConf().getName().getMiddleName())) {
                    name.setMiddleName((String)((Attr)attrs.get(conf.getUserConf().getName().getMiddleName())).getValues().get(0));
                }
                if (!name.isEmpty()) {
                    user.setName(name);
                }
            }
            if (this.output(attributes, excludedAttributes, "displayName") && conf.getUserConf().getDisplayName() != null && attrs.containsKey(conf.getUserConf().getDisplayName())) {
                user.setDisplayName((String)((Attr)attrs.get(conf.getUserConf().getDisplayName())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "nickName") && conf.getUserConf().getNickName() != null && attrs.containsKey(conf.getUserConf().getNickName())) {
                user.setNickName((String)((Attr)attrs.get(conf.getUserConf().getNickName())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "profileUrl") && conf.getUserConf().getProfileUrl() != null && attrs.containsKey(conf.getUserConf().getProfileUrl())) {
                user.setProfileUrl((String)((Attr)attrs.get(conf.getUserConf().getProfileUrl())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "title") && conf.getUserConf().getTitle() != null && attrs.containsKey(conf.getUserConf().getTitle())) {
                user.setTitle((String)((Attr)attrs.get(conf.getUserConf().getTitle())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "userType") && conf.getUserConf().getUserType() != null && attrs.containsKey(conf.getUserConf().getUserType())) {
                user.setUserType((String)((Attr)attrs.get(conf.getUserConf().getUserType())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "preferredLanguage") && conf.getUserConf().getPreferredLanguage() != null && attrs.containsKey(conf.getUserConf().getPreferredLanguage())) {
                user.setPreferredLanguage((String)((Attr)attrs.get(conf.getUserConf().getPreferredLanguage())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "locale") && conf.getUserConf().getLocale() != null && attrs.containsKey(conf.getUserConf().getLocale())) {
                user.setLocale((String)((Attr)attrs.get(conf.getUserConf().getLocale())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "timezone") && conf.getUserConf().getTimezone() != null && attrs.containsKey(conf.getUserConf().getTimezone())) {
                user.setTimezone((String)((Attr)attrs.get(conf.getUserConf().getTimezone())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "emails")) {
                this.fill(attrs, conf.getUserConf().getEmails(), user.getEmails());
            }
            if (this.output(attributes, excludedAttributes, "phoneNumbers")) {
                this.fill(attrs, conf.getUserConf().getPhoneNumbers(), user.getPhoneNumbers());
            }
            if (this.output(attributes, excludedAttributes, "ims")) {
                this.fill(attrs, conf.getUserConf().getIms(), user.getIms());
            }
            if (this.output(attributes, excludedAttributes, "photos")) {
                this.fill(attrs, conf.getUserConf().getPhotos(), user.getPhotos());
            }
            if (this.output(attributes, excludedAttributes, "addresses")) {
                conf.getUserConf().getAddresses().forEach(addressConf -> {
                    SCIMUserAddress address = new SCIMUserAddress();
                    if (addressConf.getFormatted() != null && attrs.containsKey(addressConf.getFormatted())) {
                        address.setFormatted((String)((Attr)attrs.get(addressConf.getFormatted())).getValues().get(0));
                    }
                    if (addressConf.getStreetAddress() != null && attrs.containsKey(addressConf.getStreetAddress())) {
                        address.setStreetAddress((String)((Attr)attrs.get(addressConf.getStreetAddress())).getValues().get(0));
                    }
                    if (addressConf.getLocality() != null && attrs.containsKey(addressConf.getLocality())) {
                        address.setLocality((String)((Attr)attrs.get(addressConf.getLocality())).getValues().get(0));
                    }
                    if (addressConf.getRegion() != null && attrs.containsKey(addressConf.getRegion())) {
                        address.setRegion((String)((Attr)attrs.get(addressConf.getRegion())).getValues().get(0));
                    }
                    if (addressConf.getCountry() != null && attrs.containsKey(addressConf.getCountry())) {
                        address.setCountry((String)((Attr)attrs.get(addressConf.getCountry())).getValues().get(0));
                    }
                    if (addressConf.getType() != null) {
                        address.setType(addressConf.getType().name());
                    }
                    if (addressConf.isPrimary()) {
                        address.setPrimary(true);
                    }
                    if (!address.isEmpty()) {
                        user.getAddresses().add(address);
                    }
                });
            }
            if (this.output(attributes, excludedAttributes, "x509Certificates")) {
                conf.getUserConf().getX509Certificates().stream().filter(attrs::containsKey).forEach(cert -> user.getX509Certificates().add(new Value((String)((Attr)attrs.get(cert)).getValues().get(0))));
            }
        }
        if (conf.getEnterpriseUserConf() != null) {
            SCIMEnterpriseInfo enterpriseInfo = new SCIMEnterpriseInfo();
            if (this.output(attributes, excludedAttributes, "employeeNumber") && conf.getEnterpriseUserConf().getEmployeeNumber() != null && attrs.containsKey(conf.getEnterpriseUserConf().getEmployeeNumber())) {
                enterpriseInfo.setEmployeeNumber((String)((Attr)attrs.get(conf.getEnterpriseUserConf().getEmployeeNumber())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "costCenter") && conf.getEnterpriseUserConf().getCostCenter() != null && attrs.containsKey(conf.getEnterpriseUserConf().getCostCenter())) {
                enterpriseInfo.setCostCenter((String)((Attr)attrs.get(conf.getEnterpriseUserConf().getCostCenter())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "organization") && conf.getEnterpriseUserConf().getOrganization() != null && attrs.containsKey(conf.getEnterpriseUserConf().getOrganization())) {
                enterpriseInfo.setOrganization((String)((Attr)attrs.get(conf.getEnterpriseUserConf().getOrganization())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "division") && conf.getEnterpriseUserConf().getDivision() != null && attrs.containsKey(conf.getEnterpriseUserConf().getDivision())) {
                enterpriseInfo.setDivision((String)((Attr)attrs.get(conf.getEnterpriseUserConf().getDivision())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "department") && conf.getEnterpriseUserConf().getDepartment() != null && attrs.containsKey(conf.getEnterpriseUserConf().getDepartment())) {
                enterpriseInfo.setDepartment((String)((Attr)attrs.get(conf.getEnterpriseUserConf().getDepartment())).getValues().get(0));
            }
            if (this.output(attributes, excludedAttributes, "manager") && conf.getEnterpriseUserConf().getManager() != null) {
                SCIMUserManager manager = new SCIMUserManager();
                if (conf.getEnterpriseUserConf().getManager().getKey() != null && attrs.containsKey(conf.getEnterpriseUserConf().getManager().getKey())) {
                    try {
                        UserTO userManager = this.userLogic.read((String)((Attr)attrs.get(conf.getEnterpriseUserConf().getManager().getKey())).getValues().get(0));
                        manager.setValue(userManager.getKey());
                        manager.setRef(StringUtils.substringBefore((String)location, (String)"/Users") + "/Users/" + userManager.getKey());
                        if (conf.getEnterpriseUserConf().getManager().getDisplayName() != null) {
                            Attr displayName = userManager.getPlainAttr(conf.getEnterpriseUserConf().getManager().getDisplayName()).orElse(null);
                            if (displayName == null) {
                                displayName = userManager.getDerAttr(conf.getEnterpriseUserConf().getManager().getDisplayName()).orElse(null);
                            }
                            if (displayName == null) {
                                displayName = userManager.getVirAttr(conf.getEnterpriseUserConf().getManager().getDisplayName()).orElse(null);
                            }
                            if (displayName != null) {
                                manager.setDisplayName((String)displayName.getValues().get(0));
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Could not read user {}", (Object)conf.getEnterpriseUserConf().getManager().getKey(), (Object)e);
                    }
                }
                if (!manager.isEmpty()) {
                    enterpriseInfo.setManager(manager);
                }
            }
            if (!enterpriseInfo.isEmpty()) {
                user.setEnterpriseInfo(enterpriseInfo);
            }
        }
        if (conf.getExtensionUserConf() != null) {
            SCIMExtensionInfo extensionInfo = new SCIMExtensionInfo();
            conf.getExtensionUserConf().asMap().forEach((scimAttr, syncopeAttr) -> {
                if (this.output(attributes, excludedAttributes, (String)scimAttr) && attrs.containsKey(syncopeAttr)) {
                    extensionInfo.getAttributes().put(scimAttr, (String)((Attr)attrs.get(syncopeAttr)).getValues().get(0));
                }
            });
            if (!extensionInfo.isEmpty()) {
                user.setExtensionInfo(extensionInfo);
            }
        }
        if (this.output(attributes, excludedAttributes, "groups")) {
            userTO.getMemberships().forEach(membership -> user.getGroups().add(new org.apache.syncope.ext.scimv2.api.data.Group(membership.getGroupKey(), StringUtils.substringBefore((String)location, (String)"/Users") + "/Groups/" + membership.getGroupKey(), membership.getGroupName(), Function.direct)));
            userTO.getDynMemberships().forEach(membership -> user.getGroups().add(new org.apache.syncope.ext.scimv2.api.data.Group(membership.getGroupKey(), StringUtils.substringBefore((String)location, (String)"/Users") + "/Groups/" + membership.getGroupKey(), membership.getGroupName(), Function.indirect)));
        }
        if (this.output(attributes, excludedAttributes, "entitlements")) {
            this.authDataAccessor.getAuthorities(userTO.getUsername(), null).forEach(authority -> user.getEntitlements().add(new Value(authority.getAuthority() + " on Realm(s) " + String.valueOf(authority.getRealms()))));
        }
        if (this.output(attributes, excludedAttributes, "roles")) {
            userTO.getRoles().forEach(role -> user.getRoles().add(new Value(role)));
        }
        return user;
    }

    protected void setAttribute(UserTO userTO, String schema, String value) {
        if (schema == null || value == null) {
            return;
        }
        switch (schema) {
            case "username": {
                userTO.setUsername(value);
                break;
            }
            default: {
                userTO.getPlainAttrs().add(new Attr.Builder(schema).value(value).build());
            }
        }
    }

    protected void setAttribute(GroupTO groupTO, String schema, String value) {
        if (schema == null || value == null) {
            return;
        }
        switch (schema) {
            case "name": {
                groupTO.setName(value);
                break;
            }
            default: {
                groupTO.getPlainAttrs().add(new Attr.Builder(schema).value(value).build());
            }
        }
    }

    protected void setAttribute(AnyObjectTO anyObjectTO, String schema, String value) {
        if (schema == null || value == null) {
            return;
        }
        if ("name".equals(schema)) {
            anyObjectTO.setName(value);
        } else {
            anyObjectTO.getPlainAttrs().add(new Attr.Builder(schema).value(value).build());
        }
    }

    protected <E extends Enum<?>> void setAttribute(Set<Attr> attrs, List<SCIMComplexConf<E>> confs, List<SCIMComplexValue> values) {
        values.stream().filter(value -> value.getType() != null).forEach(value -> confs.stream().filter(object -> value.getType().equals(object.getType().name())).findFirst().ifPresent(conf -> attrs.add(new Attr.Builder(conf.getValue()).value(value.getValue()).build())));
    }

    protected <E extends Enum<?>> void setAttribute(Set<Attr> attrs, Set<AttrPatch> attrPatches, List<SCIMComplexConf<E>> confs, List<SCIMComplexValue> values) {
        values.stream().filter(value -> value.getType() != null).forEach(value -> confs.stream().filter(object -> value.getType().equals(object.getType().name()) && attrPatches.stream().noneMatch(attrPatch -> attrPatch.getAttr().getSchema().equals(object.getValue()))).findFirst().ifPresent(conf -> attrs.add(new Attr.Builder(conf.getValue()).value(value.getValue()).build())));
    }

    public void populateUserUR(UserUR userUR, UserTO before, SCIMUser user, Collection<String> resources, SCIMPatchOperation op) {
        SCIMConf conf = this.confManager.get();
        if (!"/".equals(before.getRealm())) {
            userUR.setRealm((StringReplacePatchItem)((StringReplacePatchItem.Builder)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value((Object)"/")).operation(PatchOperation.ADD_REPLACE)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getPassword())) {
            userUR.setPassword((PasswordPatch)((PasswordPatch.Builder)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)user.getPassword())).resources(resources).operation(PatchOperation.ADD_REPLACE)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getUserName()) && !user.getUserName().equals(before.getUsername())) {
            userUR.setUsername((StringReplacePatchItem)((StringReplacePatchItem.Builder)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value((Object)user.getUserName())).operation(PatchOperation.ADD_REPLACE)).build());
        }
        if (conf.getUserConf() != null) {
            this.setAttribute(before, userUR, conf.getUserConf().getExternalId(), user.getExternalId(), op);
            if (conf.getUserConf().getName() != null && user.getName() != null) {
                this.setAttribute(before, userUR, conf.getUserConf().getName().getFamilyName(), user.getName().getFamilyName(), op);
                this.setAttribute(before, userUR, conf.getUserConf().getName().getFormatted(), user.getName().getFormatted(), op);
                this.setAttribute(before, userUR, conf.getUserConf().getName().getGivenName(), user.getName().getGivenName(), op);
                this.setAttribute(before, userUR, conf.getUserConf().getName().getHonorificPrefix(), user.getName().getHonorificPrefix(), op);
                this.setAttribute(before, userUR, conf.getUserConf().getName().getHonorificSuffix(), user.getName().getHonorificSuffix(), op);
                this.setAttribute(before, userUR, conf.getUserConf().getName().getMiddleName(), user.getName().getMiddleName(), op);
            }
            this.setAttribute(before, userUR, conf.getUserConf().getDisplayName(), user.getDisplayName(), op);
            this.setAttribute(before, userUR, conf.getUserConf().getNickName(), user.getNickName(), op);
            this.setAttribute(before, userUR, conf.getUserConf().getProfileUrl(), user.getProfileUrl(), op);
            this.setAttribute(before, userUR, conf.getUserConf().getTitle(), user.getTitle(), op);
            this.setAttribute(before, userUR, conf.getUserConf().getUserType(), user.getUserType(), op);
            this.setAttribute(before, userUR, conf.getUserConf().getPreferredLanguage(), user.getPreferredLanguage(), op);
            this.setAttribute(before, userUR, conf.getUserConf().getLocale(), user.getLocale(), op);
            this.setAttribute(before, userUR, conf.getUserConf().getTimezone(), user.getTimezone(), op);
            this.setAttribute(before.getPlainAttrs(), userUR.getPlainAttrs(), conf.getUserConf().getEmails(), user.getEmails());
            this.setAttribute(before.getPlainAttrs(), userUR.getPlainAttrs(), conf.getUserConf().getPhoneNumbers(), user.getPhoneNumbers());
            this.setAttribute(before.getPlainAttrs(), userUR.getPlainAttrs(), conf.getUserConf().getIms(), user.getIms());
            this.setAttribute(before.getPlainAttrs(), userUR.getPlainAttrs(), conf.getUserConf().getPhotos(), user.getPhotos());
            user.getAddresses().stream().filter(address -> address.getType() != null).forEach(address -> conf.getUserConf().getAddresses().stream().filter(object -> address.getType().equals(object.getType().name())).findFirst().ifPresent(addressConf -> {
                this.setAttribute(before, userUR, addressConf.getFormatted(), address.getFormatted(), op);
                this.setAttribute(before, userUR, addressConf.getStreetAddress(), address.getStreetAddress(), op);
                this.setAttribute(before, userUR, addressConf.getLocality(), address.getLocality(), op);
                this.setAttribute(before, userUR, addressConf.getRegion(), address.getRegion(), op);
                this.setAttribute(before, userUR, addressConf.getPostalCode(), address.getPostalCode(), op);
                this.setAttribute(before, userUR, addressConf.getCountry(), address.getCountry(), op);
            }));
            for (int i = 0; i < user.getX509Certificates().size(); ++i) {
                Value certificate = (Value)user.getX509Certificates().get(i);
                if (conf.getUserConf().getX509Certificates().size() <= i) continue;
                this.setAttribute(before, userUR, (String)conf.getUserConf().getX509Certificates().get(i), certificate.getValue(), op);
            }
        }
        if (conf.getEnterpriseUserConf() != null && user.getEnterpriseInfo() != null) {
            this.setAttribute(before, userUR, conf.getEnterpriseUserConf().getEmployeeNumber(), user.getEnterpriseInfo().getEmployeeNumber(), op);
            this.setAttribute(before, userUR, conf.getEnterpriseUserConf().getCostCenter(), user.getEnterpriseInfo().getCostCenter(), op);
            this.setAttribute(before, userUR, conf.getEnterpriseUserConf().getOrganization(), user.getEnterpriseInfo().getOrganization(), op);
            this.setAttribute(before, userUR, conf.getEnterpriseUserConf().getDivision(), user.getEnterpriseInfo().getDivision(), op);
            this.setAttribute(before, userUR, conf.getEnterpriseUserConf().getDepartment(), user.getEnterpriseInfo().getDepartment(), op);
            this.setAttribute(before, userUR, Optional.ofNullable(conf.getEnterpriseUserConf().getManager()).map(SCIMManagerConf::getKey).orElse(null), Optional.ofNullable(user.getEnterpriseInfo().getManager()).map(SCIMUserManager::getValue).orElse(null), op);
        }
        if (conf.getExtensionUserConf() != null && user.getExtensionInfo() != null) {
            conf.getExtensionUserConf().asMap().forEach((scimAttr, syncopeAttr) -> this.setAttribute(before, userUR, (String)syncopeAttr, (String)user.getExtensionInfo().getAttributes().get(scimAttr), op));
        }
        user.getGroups().forEach(group -> {
            if (before.getMembership(group.getValue()).isEmpty() && userUR.getMemberships().stream().noneMatch(membershipUR -> membershipUR.getGroup().equals(group.getValue()))) {
                userUR.getMemberships().add((MembershipUR)((MembershipUR.Builder)new MembershipUR.Builder(group.getValue()).operation(PatchOperation.ADD_REPLACE)).build());
            }
        });
        user.getRoles().forEach(role -> {
            if (!before.getRoles().contains(role.getValue()) && userUR.getRoles().stream().noneMatch(roleUR -> ((String)roleUR.getValue()).equals(role.getValue()))) {
                userUR.getRoles().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().value((Object)role.getValue())).operation(PatchOperation.ADD_REPLACE)).build());
            }
        });
    }

    public UserTO toUserTO(SCIMUser user, boolean checkSchemas) {
        SCIMConf conf = this.confManager.get();
        HashSet<String> expectedSchemas = new HashSet<String>();
        expectedSchemas.add(Resource.User.schema());
        if (conf.getEnterpriseUserConf() != null) {
            expectedSchemas.add(Resource.EnterpriseUser.schema());
        }
        if (conf.getExtensionUserConf() != null) {
            expectedSchemas.add(Resource.ExtensionUser.schema());
        }
        if (!(!checkSchemas || user.getSchemas().containsAll(expectedSchemas) && expectedSchemas.containsAll(user.getSchemas()))) {
            throw new BadRequestException(ErrorType.invalidValue);
        }
        UserTO userTO = new UserTO();
        userTO.setRealm("/");
        userTO.setKey(user.getId());
        userTO.setPassword(user.getPassword());
        userTO.setUsername(user.getUserName());
        if (conf.getUserConf() != null) {
            this.setAttribute(userTO, conf.getUserConf().getExternalId(), user.getExternalId());
            if (conf.getUserConf().getName() != null && user.getName() != null) {
                this.setAttribute(userTO, conf.getUserConf().getName().getFamilyName(), user.getName().getFamilyName());
                this.setAttribute(userTO, conf.getUserConf().getName().getFormatted(), user.getName().getFormatted());
                this.setAttribute(userTO, conf.getUserConf().getName().getGivenName(), user.getName().getGivenName());
                this.setAttribute(userTO, conf.getUserConf().getName().getHonorificPrefix(), user.getName().getHonorificPrefix());
                this.setAttribute(userTO, conf.getUserConf().getName().getHonorificSuffix(), user.getName().getHonorificSuffix());
                this.setAttribute(userTO, conf.getUserConf().getName().getMiddleName(), user.getName().getMiddleName());
            }
            this.setAttribute(userTO, conf.getUserConf().getDisplayName(), user.getDisplayName());
            this.setAttribute(userTO, conf.getUserConf().getNickName(), user.getNickName());
            this.setAttribute(userTO, conf.getUserConf().getProfileUrl(), user.getProfileUrl());
            this.setAttribute(userTO, conf.getUserConf().getTitle(), user.getTitle());
            this.setAttribute(userTO, conf.getUserConf().getUserType(), user.getUserType());
            this.setAttribute(userTO, conf.getUserConf().getPreferredLanguage(), user.getPreferredLanguage());
            this.setAttribute(userTO, conf.getUserConf().getLocale(), user.getLocale());
            this.setAttribute(userTO, conf.getUserConf().getTimezone(), user.getTimezone());
            this.setAttribute(userTO.getPlainAttrs(), conf.getUserConf().getEmails(), user.getEmails());
            this.setAttribute(userTO.getPlainAttrs(), conf.getUserConf().getPhoneNumbers(), user.getPhoneNumbers());
            this.setAttribute(userTO.getPlainAttrs(), conf.getUserConf().getIms(), user.getIms());
            this.setAttribute(userTO.getPlainAttrs(), conf.getUserConf().getPhotos(), user.getPhotos());
            user.getAddresses().stream().filter(address -> address.getType() != null).forEach(address -> conf.getUserConf().getAddresses().stream().filter(object -> address.getType().equals(object.getType().name())).findFirst().ifPresent(addressConf -> {
                this.setAttribute(userTO, addressConf.getFormatted(), address.getFormatted());
                this.setAttribute(userTO, addressConf.getStreetAddress(), address.getStreetAddress());
                this.setAttribute(userTO, addressConf.getLocality(), address.getLocality());
                this.setAttribute(userTO, addressConf.getRegion(), address.getRegion());
                this.setAttribute(userTO, addressConf.getPostalCode(), address.getPostalCode());
                this.setAttribute(userTO, addressConf.getCountry(), address.getCountry());
            }));
            for (int i = 0; i < user.getX509Certificates().size(); ++i) {
                Value certificate = (Value)user.getX509Certificates().get(i);
                if (conf.getUserConf().getX509Certificates().size() <= i) continue;
                this.setAttribute(userTO, (String)conf.getUserConf().getX509Certificates().get(i), certificate.getValue());
            }
        }
        if (conf.getEnterpriseUserConf() != null && user.getEnterpriseInfo() != null) {
            this.setAttribute(userTO, conf.getEnterpriseUserConf().getEmployeeNumber(), user.getEnterpriseInfo().getEmployeeNumber());
            this.setAttribute(userTO, conf.getEnterpriseUserConf().getCostCenter(), user.getEnterpriseInfo().getCostCenter());
            this.setAttribute(userTO, conf.getEnterpriseUserConf().getOrganization(), user.getEnterpriseInfo().getOrganization());
            this.setAttribute(userTO, conf.getEnterpriseUserConf().getDivision(), user.getEnterpriseInfo().getDivision());
            this.setAttribute(userTO, conf.getEnterpriseUserConf().getDepartment(), user.getEnterpriseInfo().getDepartment());
            this.setAttribute(userTO, (String)Optional.ofNullable(conf.getEnterpriseUserConf().getManager()).map(SCIMManagerConf::getKey).orElse(null), (String)Optional.ofNullable(user.getEnterpriseInfo().getManager()).map(SCIMUserManager::getValue).orElse(null));
        }
        if (conf.getExtensionUserConf() != null && user.getExtensionInfo() != null) {
            conf.getExtensionUserConf().asMap().forEach((scimAttr, syncopeAttr) -> this.setAttribute(userTO, (String)syncopeAttr, (String)user.getExtensionInfo().getAttributes().get(scimAttr)));
        }
        userTO.getMemberships().addAll(user.getGroups().stream().map(group -> new MembershipTO.Builder(group.getValue()).build()).collect(Collectors.toList()));
        userTO.getRoles().addAll(user.getRoles().stream().map(Value::getValue).collect(Collectors.toList()));
        return userTO;
    }

    public UserCR toUserCR(SCIMUser user) {
        UserTO userTO = this.toUserTO(user, true);
        UserCR userCR = new UserCR();
        EntityTOUtils.toAnyCR((AnyTO)userTO, (AnyCR)userCR);
        return userCR;
    }

    protected void setAttribute(UserTO before, UserUR userUR, String schema, String value, SCIMPatchOperation op) {
        if (schema == null || value == null) {
            return;
        }
        switch (schema) {
            case "username": {
                if (value.equals(before.getUsername()) || userUR.getUsername() != null) break;
                userUR.setUsername((StringReplacePatchItem)((StringReplacePatchItem.Builder)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value((Object)value)).operation(PatchOperation.ADD_REPLACE)).build());
                break;
            }
            default: {
                if ((before.getPlainAttr(schema).isEmpty() || !value.equals(((Attr)before.getPlainAttr(schema).get()).getValues().get(0))) && userUR.getPlainAttrs().stream().noneMatch(attrPatch -> attrPatch.getAttr().getSchema().equals(schema)) && op.getOp() != PatchOp.remove) {
                    userUR.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(new Attr.Builder(schema).value(value).build()).operation(PatchOperation.ADD_REPLACE)).build());
                }
                if (!before.getPlainAttr(schema).isPresent() || !userUR.getPlainAttrs().stream().noneMatch(attrPatch -> attrPatch.getAttr().getSchema().equals(schema)) || op.getOp() != PatchOp.remove) break;
                userUR.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(new Attr.Builder(schema).build()).operation(PatchOperation.DELETE)).build());
            }
        }
    }

    protected void setAttribute(Set<AttrPatch> attrs, String schema, SCIMPatchOperation op) {
        Optional.ofNullable(schema).ifPresent(a -> {
            Attr.Builder attr = new Attr.Builder(a);
            if (!CollectionUtils.isEmpty((Collection)op.getValue())) {
                attr.value(((Serializable)op.getValue().get(0)).toString());
            }
            attrs.add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(attr.build()).operation(op.getOp() == PatchOp.remove ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).build());
        });
    }

    protected <E extends Enum<?>> void setAttribute(Set<AttrPatch> attrs, List<SCIMComplexConf<E>> confs, SCIMPatchOperation op) {
        confs.stream().filter(conf -> BooleanUtils.toBoolean((String)JexlUtils.evaluateExpr((String)SCIMDataBinder.filter2JexlExpression(op.getPath().getFilter()), (JexlContext)new MapContext(Map.of("type", conf.getType().name()))).toString())).findFirst().ifPresent(conf -> {
            if (op.getPath().getSub() == null || "display".equals(op.getPath().getSub())) {
                this.setAttribute(attrs, conf.getDisplay(), op);
            }
            if (op.getPath().getSub() == null || "value".equals(op.getPath().getSub())) {
                this.setAttribute(attrs, conf.getValue(), op);
            }
        });
    }

    protected <E extends Enum<?>> void setAttribute(Set<AttrPatch> attrs, List<SCIMComplexConf<E>> confs, List<SCIMComplexValue> values, PatchOp patchOp) {
        values.stream().filter(value -> value.getType() != null).forEach(value -> confs.stream().filter(conf -> value.getType().equals(conf.getType().name())).findFirst().ifPresent(conf -> attrs.add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder(new Attr.Builder(conf.getValue()).value(value.getValue()).build()).operation(patchOp == PatchOp.remove ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).build())));
    }

    protected void setAttribute(Set<AttrPatch> attrs, SCIMUserAddressConf conf, SCIMPatchOperation op) {
        if (op.getPath().getSub() == null || "formatted".equals(op.getPath().getSub())) {
            this.setAttribute(attrs, conf.getFormatted(), op);
        }
        if (op.getPath().getSub() == null || "streetAddress".equals(op.getPath().getSub())) {
            this.setAttribute(attrs, conf.getStreetAddress(), op);
        }
        if (op.getPath().getSub() == null || "locality".equals(op.getPath().getSub())) {
            this.setAttribute(attrs, conf.getLocality(), op);
        }
        if (op.getPath().getSub() == null || "region".equals(op.getPath().getSub())) {
            this.setAttribute(attrs, conf.getRegion(), op);
        }
        if (op.getPath().getSub() == null || "postalCode".equals(op.getPath().getSub())) {
            this.setAttribute(attrs, conf.getPostalCode(), op);
        }
        if (op.getPath().getSub() == null || "country".equals(op.getPath().getSub())) {
            this.setAttribute(attrs, conf.getCountry(), op);
        }
    }

    public Pair<List<UserUR>, StatusR> toUserUpdate(UserTO before, SCIMPatchOp patch) {
        AtomicReference statusR = new AtomicReference();
        ArrayList<UserUR> userURs = new ArrayList<UserUR>();
        UserUR userUR = (UserUR)new UserUR.Builder(before.getKey()).build();
        userURs.add(userUR);
        ArrayList resources = new ArrayList(before.getResources());
        AtomicInteger numberUR = new AtomicInteger();
        patch.getOperations().forEach(op -> {
            if (op.getPath() == null && op.getOp() != PatchOp.remove && !CollectionUtils.isEmpty((Collection)op.getValue()) && op.getValue().get(0) instanceof SCIMUser) {
                String groupKey;
                Group group;
                SCIMUser after = (SCIMUser)op.getValue().get(0);
                if (after.getActive() != null && before.isSuspended() == after.isActive()) {
                    statusR.set(new StatusR.Builder(before.getKey(), after.isActive() ? StatusRType.REACTIVATE : StatusRType.SUSPEND).resources((Collection)resources).build());
                }
                if (!after.getGroups().isEmpty() && (group = (Group)this.groupDAO.find(groupKey = ((org.apache.syncope.ext.scimv2.api.data.Group)after.getGroups().get(0)).getValue())) != null && before.getMembership(groupKey).isEmpty()) {
                    List<ExternalResource> filteredResources = group.getResources().stream().filter(resource -> resource.getProvisions().stream().anyMatch(provision -> AnyTypeKind.USER.name().equals(provision.getAnyType()))).collect(Collectors.toList());
                    filteredResources.forEach(resource -> resources.add(resource.getKey()));
                    if (!filteredResources.isEmpty()) {
                        UserUR newUserUR = (UserUR)new UserUR.Builder(before.getKey()).build();
                        userURs.add(newUserUR);
                        numberUR.getAndIncrement();
                    }
                }
                this.populateUserUR((UserUR)userURs.get(numberUR.get()), before, after, resources, (SCIMPatchOperation)op);
                return;
            }
            SCIMConf conf = this.confManager.get();
            if (conf == null) {
                return;
            }
            switch (op.getPath().getAttribute()) {
                case "externalId": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getExternalId(), (SCIMPatchOperation)op);
                    break;
                }
                case "userName": {
                    if (op.getOp() == PatchOp.remove || CollectionUtils.isEmpty((Collection)op.getValue())) break;
                    ((UserUR)userURs.get(numberUR.get())).setUsername((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value((Object)((Serializable)op.getValue().get(0)).toString())).build());
                    break;
                }
                case "password": {
                    if (op.getOp() == PatchOp.remove || CollectionUtils.isEmpty((Collection)op.getValue())) break;
                    ((UserUR)userURs.get(numberUR.get())).setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)((Serializable)op.getValue().get(0)).toString())).resources((Collection)resources).build());
                    break;
                }
                case "active": {
                    if (CollectionUtils.isEmpty((Collection)op.getValue())) break;
                    if (op.getValue().get(0) instanceof String) {
                        String a = (String)op.getValue().get(0);
                        op.setValue(List.of(Boolean.valueOf(BooleanUtils.toBoolean((String)a))));
                    }
                    statusR.set(new StatusR.Builder(before.getKey(), (Boolean)((Serializable)op.getValue().get(0)) != false ? StatusRType.REACTIVATE : StatusRType.SUSPEND).resources((Collection)resources).build());
                    break;
                }
                case "name": {
                    if (conf.getUserConf().getName() == null) break;
                    if (op.getPath().getSub() == null || "familyName".equals(op.getPath().getSub())) {
                        this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getName().getFamilyName(), (SCIMPatchOperation)op);
                    }
                    if (op.getPath().getSub() == null || "formatted".equals(op.getPath().getSub())) {
                        this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getName().getFormatted(), (SCIMPatchOperation)op);
                    }
                    if (op.getPath().getSub() == null || "givenName".equals(op.getPath().getSub())) {
                        this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getName().getGivenName(), (SCIMPatchOperation)op);
                    }
                    if (op.getPath().getSub() == null || "honorificPrefix".equals(op.getPath().getSub())) {
                        this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getName().getHonorificPrefix(), (SCIMPatchOperation)op);
                    }
                    if (op.getPath().getSub() == null || "honorificSuffix".equals(op.getPath().getSub())) {
                        this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getName().getHonorificSuffix(), (SCIMPatchOperation)op);
                    }
                    if (op.getPath().getSub() != null && !"middleName".equals(op.getPath().getSub())) break;
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getName().getMiddleName(), (SCIMPatchOperation)op);
                    break;
                }
                case "displayName": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getDisplayName(), (SCIMPatchOperation)op);
                    break;
                }
                case "nickName": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getNickName(), (SCIMPatchOperation)op);
                    break;
                }
                case "profileUrl": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getProfileUrl(), (SCIMPatchOperation)op);
                    break;
                }
                case "title": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getTitle(), (SCIMPatchOperation)op);
                    break;
                }
                case "userType": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getUserType(), (SCIMPatchOperation)op);
                    break;
                }
                case "preferredLanguage": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getPreferredLanguage(), (SCIMPatchOperation)op);
                    break;
                }
                case "locale": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getLocale(), (SCIMPatchOperation)op);
                    break;
                }
                case "timezone": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getTimezone(), (SCIMPatchOperation)op);
                    break;
                }
                case "emails": {
                    if (!CollectionUtils.isEmpty((Collection)op.getValue()) && op.getValue().get(0) instanceof SCIMUser) {
                        this.setAttribute(((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getEmails(), ((SCIMUser)op.getValue().get(0)).getEmails(), op.getOp());
                        break;
                    }
                    if (op.getPath().getFilter() == null) break;
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (List)conf.getUserConf().getEmails(), (SCIMPatchOperation)op);
                    break;
                }
                case "phoneNumbers": {
                    if (!CollectionUtils.isEmpty((Collection)op.getValue()) && op.getValue().get(0) instanceof SCIMUser) {
                        this.setAttribute(((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getPhoneNumbers(), ((SCIMUser)op.getValue().get(0)).getPhoneNumbers(), op.getOp());
                        break;
                    }
                    if (op.getPath().getFilter() == null) break;
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (List)conf.getUserConf().getPhoneNumbers(), (SCIMPatchOperation)op);
                    break;
                }
                case "ims": {
                    if (!CollectionUtils.isEmpty((Collection)op.getValue()) && op.getValue().get(0) instanceof SCIMUser) {
                        this.setAttribute(((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getIms(), ((SCIMUser)op.getValue().get(0)).getIms(), op.getOp());
                        break;
                    }
                    if (op.getPath().getFilter() == null) break;
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (List)conf.getUserConf().getIms(), (SCIMPatchOperation)op);
                    break;
                }
                case "photos": {
                    if (!CollectionUtils.isEmpty((Collection)op.getValue()) && op.getValue().get(0) instanceof SCIMUser) {
                        this.setAttribute(((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), conf.getUserConf().getPhotos(), ((SCIMUser)op.getValue().get(0)).getPhotos(), op.getOp());
                        break;
                    }
                    if (op.getPath().getFilter() == null) break;
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (List)conf.getUserConf().getPhotos(), (SCIMPatchOperation)op);
                    break;
                }
                case "addresses": {
                    if (!CollectionUtils.isEmpty((Collection)op.getValue()) && op.getValue().get(0) instanceof SCIMUser) {
                        SCIMUser after = (SCIMUser)op.getValue().get(0);
                        after.getAddresses().stream().filter(address -> address.getType() != null).forEach(address -> conf.getUserConf().getAddresses().stream().filter(object -> address.getType().equals(object.getType().name())).findFirst().ifPresent(addressConf -> this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (SCIMUserAddressConf)addressConf, (SCIMPatchOperation)op)));
                        break;
                    }
                    if (op.getPath().getFilter() == null) break;
                    conf.getUserConf().getAddresses().stream().filter(addressConf -> BooleanUtils.toBoolean((String)JexlUtils.evaluateExpr((String)SCIMDataBinder.filter2JexlExpression(op.getPath().getFilter()), (JexlContext)new MapContext(Map.of("type", addressConf.getType().name()))).toString())).findFirst().ifPresent(addressConf -> this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (SCIMUserAddressConf)addressConf, (SCIMPatchOperation)op));
                    break;
                }
                case "employeeNumber": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (String)Optional.ofNullable(conf.getEnterpriseUserConf()).map(SCIMEnterpriseUserConf::getEmployeeNumber).orElse(null), (SCIMPatchOperation)op);
                    break;
                }
                case "costCenter": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (String)Optional.ofNullable(conf.getEnterpriseUserConf()).map(SCIMEnterpriseUserConf::getCostCenter).orElse(null), (SCIMPatchOperation)op);
                    break;
                }
                case "organization": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (String)Optional.ofNullable(conf.getEnterpriseUserConf()).map(SCIMEnterpriseUserConf::getOrganization).orElse(null), (SCIMPatchOperation)op);
                    break;
                }
                case "division": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (String)Optional.ofNullable(conf.getEnterpriseUserConf()).map(SCIMEnterpriseUserConf::getDivision).orElse(null), (SCIMPatchOperation)op);
                    break;
                }
                case "department": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (String)Optional.ofNullable(conf.getEnterpriseUserConf()).map(SCIMEnterpriseUserConf::getDepartment).orElse(null), (SCIMPatchOperation)op);
                    break;
                }
                case "manager": {
                    this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (String)Optional.ofNullable(conf.getEnterpriseUserConf()).map(SCIMEnterpriseUserConf::getManager).map(SCIMManagerConf::getKey).orElse(null), (SCIMPatchOperation)op);
                    break;
                }
                default: {
                    Optional.ofNullable(conf.getExtensionUserConf()).flatMap(schema -> Optional.ofNullable((String)schema.asMap().get(op.getPath().getAttribute()))).ifPresent(schema -> this.setAttribute((Set<AttrPatch>)((UserUR)userURs.get(numberUR.get())).getPlainAttrs(), (String)schema, (SCIMPatchOperation)op));
                }
            }
        });
        return Pair.of(userURs, (Object)((StatusR)statusR.get()));
    }

    @Transactional(readOnly=true)
    public SCIMGroup toSCIMGroup(GroupTO groupTO, String location, List<String> attributes, List<String> excludedAttributes) {
        SCIMConf conf = this.confManager.get();
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(Resource.Group.schema());
        if (conf.getExtensionGroupConf() != null) {
            schemas.add(Resource.ExtensionGroup.schema());
        }
        SCIMGroup group = new SCIMGroup(groupTO.getKey(), schemas, new Meta(Resource.Group.name(), groupTO.getCreationDate(), Optional.ofNullable(groupTO.getLastChangeDate()).orElse(groupTO.getCreationDate()), groupTO.getETagValue(), location), this.output(attributes, excludedAttributes, "displayName", groupTO.getName()));
        HashMap attrs = new HashMap();
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)groupTO.getPlainAttrs()));
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)groupTO.getDerAttrs()));
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)groupTO.getVirAttrs()));
        if (this.output(attributes, excludedAttributes, "externalId") && conf.getGroupConf() != null && conf.getGroupConf().getExternalId() != null && attrs.containsKey(conf.getGroupConf().getExternalId())) {
            group.setExternalId((String)((Attr)attrs.get(conf.getGroupConf().getExternalId())).getValues().get(0));
        }
        MembershipCond membCond = new MembershipCond();
        membCond.setGroup(groupTO.getKey());
        SearchCond searchCond = SearchCond.getLeaf((AbstractSearchCond)membCond);
        if (conf.getExtensionGroupConf() != null) {
            SCIMExtensionInfo extensionInfo = new SCIMExtensionInfo();
            conf.getExtensionGroupConf().asMap().forEach((scimAttr, syncopeAttr) -> {
                if (this.output(attributes, excludedAttributes, (String)scimAttr) && attrs.containsKey(syncopeAttr)) {
                    extensionInfo.getAttributes().put(scimAttr, (String)((Attr)attrs.get(syncopeAttr)).getValues().get(0));
                }
            });
            if (!extensionInfo.isEmpty()) {
                group.setExtensionInfo(extensionInfo);
            }
        }
        if (this.output(attributes, excludedAttributes, "members")) {
            int count = (Integer)this.userLogic.search(searchCond, 1, 1, List.of(), "/", true, false).getLeft();
            for (int page = 1; page <= count / 500 + 1; ++page) {
                List users = this.groupDAO.findUMemberships(Optional.ofNullable((Group)this.groupDAO.find(groupTO.getKey())).orElseThrow(() -> new NotFoundException("Group " + groupTO.getKey())), page, 500);
                users.forEach(uMembership -> group.getMembers().add(new Member(((User)uMembership.getLeftEnd()).getKey(), StringUtils.substringBefore((String)location, (String)"/Groups") + "/Users/" + uMembership.getKey(), ((User)uMembership.getLeftEnd()).getUsername())));
            }
        }
        return group;
    }

    public GroupTO toGroupTO(SCIMGroup group, boolean checkSchemas) {
        SCIMConf conf = this.confManager.get();
        HashSet<String> expectedSchemas = new HashSet<String>();
        expectedSchemas.add(Resource.Group.schema());
        if (conf.getExtensionGroupConf() != null) {
            expectedSchemas.add(Resource.ExtensionGroup.schema());
        }
        if (!(!checkSchemas || group.getSchemas().containsAll(expectedSchemas) && expectedSchemas.containsAll(group.getSchemas()))) {
            throw new BadRequestException(ErrorType.invalidValue);
        }
        GroupTO groupTO = new GroupTO();
        groupTO.setRealm("/");
        groupTO.setKey(group.getId());
        groupTO.setName(group.getDisplayName());
        if (conf.getGroupConf() != null && conf.getGroupConf().getExternalId() != null && group.getExternalId() != null) {
            groupTO.getPlainAttrs().add(new Attr.Builder(conf.getGroupConf().getExternalId()).value(group.getExternalId()).build());
        }
        if (conf.getExtensionGroupConf() != null && group.getExtensionInfo() != null) {
            conf.getExtensionGroupConf().asMap().forEach((scimAttr, syncopeAttr) -> this.setAttribute(groupTO, (String)syncopeAttr, (String)group.getExtensionInfo().getAttributes().get(scimAttr)));
        }
        return groupTO;
    }

    public GroupCR toGroupCR(SCIMGroup group) {
        GroupTO groupTO = this.toGroupTO(group, true);
        GroupCR groupCR = new GroupCR();
        EntityTOUtils.toAnyCR((AnyTO)groupTO, (AnyCR)groupCR);
        return groupCR;
    }

    public GroupUR toGroupUR(GroupTO before, SCIMPatchOperation op) {
        if (op.getPath() == null) {
            throw new UnsupportedOperationException("Empty path not supported for Groups");
        }
        GroupUR groupUR = (GroupUR)new GroupUR.Builder(before.getKey()).build();
        if ("displayName".equals(op.getPath().getAttribute())) {
            StringReplacePatchItem.Builder name = (StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().operation(op.getOp() == PatchOp.remove ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE);
            if (!CollectionUtils.isEmpty((Collection)op.getValue())) {
                name.value((Object)((Serializable)op.getValue().get(0)).toString());
            }
            groupUR.setName((StringReplacePatchItem)name.build());
        } else {
            SCIMConf conf = this.confManager.get();
            if (conf.getGroupConf() != null && "externalId".equals(op.getPath().getAttribute())) {
                this.setAttribute((Set<AttrPatch>)groupUR.getPlainAttrs(), conf.getGroupConf().getExternalId(), op);
            }
            if (conf.getExtensionGroupConf() != null) {
                Optional.ofNullable(conf.getExtensionGroupConf()).flatMap(schema -> Optional.ofNullable((String)schema.asMap().get(op.getPath().getAttribute()))).ifPresent(schema -> this.setAttribute((Set<AttrPatch>)groupUR.getPlainAttrs(), (String)schema, op));
            }
        }
        return groupUR;
    }

    public SCIMAnyObject toSCIMAnyObject(AnyObjectTO anyObjectTO, String location, List<String> attributes, List<String> excludedAttributes) {
        SCIMConf conf = this.confManager.get();
        ArrayList<CallSite> schemas = new ArrayList<CallSite>();
        SCIMExtensionAnyObjectConf scimExtensionAnyObjectConf = conf.getExtensionAnyObjectsConf().stream().filter(scimExtAnyObjectConf -> scimExtAnyObjectConf.getType().equals(anyObjectTO.getType())).findFirst().orElseThrow(() -> new NotFoundException("SCIMExtensionAnyObjectConf not found"));
        schemas.add((CallSite)((Object)("urn:ietf:params:scim:schemas:extension:syncope:2.0:" + scimExtensionAnyObjectConf.getType())));
        SCIMAnyObject anyObject = new SCIMAnyObject(anyObjectTO.getKey(), schemas, new Meta("urn:ietf:params:scim:schemas:extension:syncope:2.0:" + scimExtensionAnyObjectConf.getType(), anyObjectTO.getCreationDate(), Optional.ofNullable(anyObjectTO.getLastChangeDate()).orElse(anyObjectTO.getCreationDate()), anyObjectTO.getETagValue(), location), this.output(attributes, excludedAttributes, "displayName", anyObjectTO.getName()));
        HashMap attrs = new HashMap();
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)anyObjectTO.getPlainAttrs()));
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)anyObjectTO.getDerAttrs()));
        attrs.putAll(EntityTOUtils.buildAttrMap((Collection)anyObjectTO.getVirAttrs()));
        if (this.output(attributes, excludedAttributes, "externalId") && scimExtensionAnyObjectConf.getExternalId() != null && attrs.containsKey(scimExtensionAnyObjectConf.getExternalId())) {
            anyObject.setExternalId((String)((Attr)attrs.get(scimExtensionAnyObjectConf.getExternalId())).getValues().get(0));
        }
        SCIMExtensionInfo extensionInfo = new SCIMExtensionInfo();
        scimExtensionAnyObjectConf.asMap().forEach((scimAttr, syncopeAttr) -> {
            if (this.output(attributes, excludedAttributes, (String)scimAttr) && attrs.containsKey(syncopeAttr)) {
                extensionInfo.getAttributes().put(scimAttr, (String)((Attr)attrs.get(syncopeAttr)).getValues().get(0));
            }
        });
        if (!extensionInfo.isEmpty()) {
            anyObject.setExtensionInfo(extensionInfo);
        }
        return anyObject;
    }

    public AnyObjectTO toAnyObjectTO(SCIMAnyObject anyObject, boolean checkSchemas) {
        SCIMConf conf = this.confManager.get();
        HashSet expectedSchemas = new HashSet();
        Optional<SCIMExtensionAnyObjectConf> scimExtensionAnyObjectConf = conf.getExtensionAnyObjectsConf().stream().filter(scimExtAnyObjectConf -> scimExtAnyObjectConf.getType().equals(anyObject.getExtensionUrn().substring(anyObject.getExtensionUrn().lastIndexOf(58) + 1))).findFirst();
        scimExtensionAnyObjectConf.ifPresent(scimExtAnyObjectConf -> expectedSchemas.add("urn:ietf:params:scim:schemas:extension:syncope:2.0:" + scimExtAnyObjectConf.getType()));
        if (!(!checkSchemas || anyObject.getSchemas().containsAll(expectedSchemas) && expectedSchemas.containsAll(anyObject.getSchemas()))) {
            throw new BadRequestException(ErrorType.invalidValue);
        }
        AnyObjectTO anyObjectTO = new AnyObjectTO();
        anyObjectTO.setRealm("/");
        anyObjectTO.setKey(anyObject.getId());
        anyObjectTO.setName(anyObject.getDisplayName());
        anyObjectTO.setType(anyObject.getExtensionUrn().substring(anyObject.getExtensionUrn().lastIndexOf(58) + 1));
        if (scimExtensionAnyObjectConf.isPresent() && scimExtensionAnyObjectConf.get().getExternalId() != null && anyObject.getExternalId() != null) {
            anyObjectTO.getPlainAttrs().add(new Attr.Builder(scimExtensionAnyObjectConf.get().getExternalId()).value(anyObject.getExternalId()).build());
        }
        if (scimExtensionAnyObjectConf.isPresent() && anyObject.getExtensionInfo() != null) {
            scimExtensionAnyObjectConf.get().asMap().forEach((scimAttr, syncopeAttr) -> this.setAttribute(anyObjectTO, (String)syncopeAttr, (String)anyObject.getExtensionInfo().getAttributes().get(scimAttr)));
        }
        return anyObjectTO;
    }

    public AnyObjectCR toAnyObjectCR(SCIMAnyObject anyObject) {
        AnyObjectTO anyObjectTO = this.toAnyObjectTO(anyObject, true);
        AnyObjectCR anyObjectCR = new AnyObjectCR();
        EntityTOUtils.toAnyCR((AnyTO)anyObjectTO, (AnyCR)anyObjectCR);
        return anyObjectCR;
    }

    public AnyObjectUR toAnyObjectUR(AnyObjectTO before, SCIMPatchOperation op) {
        if (op.getPath() == null) {
            throw new UnsupportedOperationException("Empty path not supported for AnyObjects");
        }
        AnyObjectUR anyObjectUR = (AnyObjectUR)new AnyObjectUR.Builder(before.getKey()).build();
        if ("displayName".equals(op.getPath().getAttribute())) {
            StringReplacePatchItem.Builder name = (StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().operation(op.getOp() == PatchOp.remove ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE);
            if (!CollectionUtils.isEmpty((Collection)op.getValue())) {
                name.value((Object)((Serializable)op.getValue().get(0)).toString());
            }
            anyObjectUR.setName((StringReplacePatchItem)name.build());
        } else {
            SCIMConf conf = this.confManager.get();
            Optional<SCIMExtensionAnyObjectConf> scimExtensionAnyObjectConf = conf.getExtensionAnyObjectsConf().stream().filter(scimExtAnyObjectConf -> scimExtAnyObjectConf.getType().equals(before.getType())).findFirst();
            if (scimExtensionAnyObjectConf.isPresent() && "externalId".equals(op.getPath().getAttribute())) {
                this.setAttribute((Set<AttrPatch>)anyObjectUR.getPlainAttrs(), scimExtensionAnyObjectConf.get().getExternalId(), op);
            }
            scimExtensionAnyObjectConf.flatMap(extensionAnyObjectConf -> Optional.of(extensionAnyObjectConf).flatMap(schema -> Optional.ofNullable((String)schema.asMap().get(op.getPath().getAttribute())))).ifPresent(schema -> this.setAttribute((Set<AttrPatch>)anyObjectUR.getPlainAttrs(), (String)schema, op));
        }
        return anyObjectUR;
    }
}

