/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.opensearch.client;

import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class SyncopeOpenSearchHealthContributor
implements HealthIndicator {
    protected final OpenSearchClient client;

    public SyncopeOpenSearchHealthContributor(OpenSearchClient client) {
        this.client = client;
    }

    public Health health() {
        Health.Builder builder = new Health.Builder();
        try {
            HealthResponse health = this.client.cluster().health();
            switch (health.status()) {
                case Green: 
                case Yellow: {
                    builder.up();
                    break;
                }
                default: {
                    builder.down();
                }
            }
            builder.withDetail("cluster_name", (Object)health.clusterName());
            builder.withDetail("status", (Object)health.status().jsonValue());
            builder.withDetail("timed_out", (Object)health.timedOut());
            builder.withDetail("number_of_nodes", (Object)health.numberOfNodes());
            builder.withDetail("number_of_data_nodes", (Object)health.numberOfDataNodes());
            builder.withDetail("active_primary_shards", (Object)health.activePrimaryShards());
            builder.withDetail("relocating_shards", (Object)health.relocatingShards());
            builder.withDetail("initializing_shards", (Object)health.initializingShards());
            builder.withDetail("unassigned_shards", (Object)health.unassignedShards());
            builder.withDetail("delayed_unassigned_shards", (Object)health.delayedUnassignedShards());
            builder.withDetail("number_of_pending_tasks", (Object)health.numberOfPendingTasks());
            builder.withDetail("number_of_in_flight_fetch", (Object)health.numberOfInFlightFetch());
            builder.withDetail("task_max_waiting_in_queue_millis", (Object)health.taskMaxWaitingInQueueMillis());
            builder.withDetail("active_shards_percent_as_number", (Object)health.activeShardsPercentAsNumber());
        }
        catch (Exception e) {
            builder.down((Throwable)e);
        }
        return builder.build();
    }
}

