/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.opensearch.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AuditEvent;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.apache.syncope.ext.opensearch.client.OpenSearchUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.analysis.CustomNormalizer;
import org.opensearch.client.opensearch._types.analysis.Normalizer;
import org.opensearch.client.opensearch._types.mapping.DynamicTemplate;
import org.opensearch.client.opensearch._types.mapping.KeywordProperty;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.TextProperty;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.CreateIndexResponse;
import org.opensearch.client.opensearch.indices.DeleteIndexRequest;
import org.opensearch.client.opensearch.indices.DeleteIndexResponse;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.IndexSettingsAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.event.TransactionalEventListener;

public class OpenSearchIndexManager {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchIndexManager.class);
    protected final OpenSearchClient client;
    protected final OpenSearchUtils openSearchUtils;
    protected final String numberOfShards;
    protected final String numberOfReplicas;

    public OpenSearchIndexManager(OpenSearchClient client, OpenSearchUtils ppenSearchUtils, String numberOfShards, String numberOfReplicas) {
        this.client = client;
        this.openSearchUtils = ppenSearchUtils;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
    }

    public boolean existsAnyIndex(String domain, AnyTypeKind kind) throws IOException {
        return this.client.indices().exists(new ExistsRequest.Builder().index(OpenSearchUtils.getAnyIndex(domain, kind), new String[0]).build()).value();
    }

    public boolean existsRealmIndex(String domain) throws IOException {
        return this.client.indices().exists(new ExistsRequest.Builder().index(OpenSearchUtils.getRealmIndex(domain), new String[0]).build()).value();
    }

    public boolean existsAuditIndex(String domain) throws IOException {
        return this.client.indices().exists(new ExistsRequest.Builder().index(OpenSearchUtils.getAuditIndex(domain), new String[0]).build()).value();
    }

    public IndexSettings defaultSettings() {
        return new IndexSettings.Builder().analysis(new IndexSettingsAnalysis.Builder().normalizer("string_lowercase", (Normalizer)new Normalizer.Builder().custom(new CustomNormalizer.Builder().charFilter(List.of()).filter("lowercase", new String[0]).build()).build()).build()).numberOfShards(this.numberOfShards).numberOfReplicas(this.numberOfReplicas).build();
    }

    public TypeMapping defaultAnyMapping() {
        return new TypeMapping.Builder().dynamicTemplates(List.of(Map.of("strings", new DynamicTemplate.Builder().matchMappingType("string").mapping((Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("string_lowercase").build()).build()).build()))).build();
    }

    public TypeMapping defaultRealmMapping() {
        return new TypeMapping.Builder().dynamicTemplates(List.of(Map.of("strings", new DynamicTemplate.Builder().matchMappingType("string").mapping((Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("string_lowercase").build()).build()).build()))).build();
    }

    public TypeMapping defaultAuditMapping() {
        return new TypeMapping.Builder().dynamicTemplates(List.of(Map.of("strings", new DynamicTemplate.Builder().matchMappingType("string").mapping((Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("string_lowercase").build()).build()).build()))).properties("before", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).properties("inputs", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).properties("output", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).properties("throwable", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).build();
    }

    protected CreateIndexResponse doCreateAnyIndex(String domain, AnyTypeKind kind, IndexSettings settings, TypeMapping mappings) throws IOException {
        return this.client.indices().create(new CreateIndexRequest.Builder().index(OpenSearchUtils.getAnyIndex(domain, kind)).settings(settings).mappings(mappings).build());
    }

    public void createAnyIndex(String domain, AnyTypeKind kind, IndexSettings settings, TypeMapping mappings) throws IOException {
        try {
            CreateIndexResponse response = this.doCreateAnyIndex(domain, kind, settings, mappings);
            LOG.debug("Successfully created {} for {}: {}", new Object[]{OpenSearchUtils.getAnyIndex(domain, kind), kind.name(), response});
        }
        catch (OpenSearchException e) {
            LOG.debug("Could not create index {} because it already exists", (Object)OpenSearchUtils.getAnyIndex(domain, kind), (Object)e);
            this.removeAnyIndex(domain, kind);
            this.doCreateAnyIndex(domain, kind, settings, mappings);
        }
    }

    public void removeAnyIndex(String domain, AnyTypeKind kind) throws IOException {
        DeleteIndexResponse response = this.client.indices().delete(new DeleteIndexRequest.Builder().index(OpenSearchUtils.getAnyIndex(domain, kind), new String[0]).build());
        LOG.debug("Successfully removed {}: {}", (Object)OpenSearchUtils.getAnyIndex(domain, kind), (Object)response);
    }

    protected CreateIndexResponse doCreateRealmIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        return this.client.indices().create(new CreateIndexRequest.Builder().index(OpenSearchUtils.getRealmIndex(domain)).settings(settings).mappings(mappings).build());
    }

    public void createRealmIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        try {
            CreateIndexResponse response = this.doCreateRealmIndex(domain, settings, mappings);
            LOG.debug("Successfully created realm index {}: {}", (Object)OpenSearchUtils.getRealmIndex(domain), (Object)response);
        }
        catch (OpenSearchException e) {
            LOG.debug("Could not create realm index {} because it already exists", (Object)OpenSearchUtils.getRealmIndex(domain), (Object)e);
            this.removeRealmIndex(domain);
            this.doCreateRealmIndex(domain, settings, mappings);
        }
    }

    public void removeRealmIndex(String domain) throws IOException {
        DeleteIndexResponse response = this.client.indices().delete(new DeleteIndexRequest.Builder().index(OpenSearchUtils.getRealmIndex(domain), new String[0]).build());
        LOG.debug("Successfully removed {}: {}", (Object)OpenSearchUtils.getRealmIndex(domain), (Object)response);
    }

    protected CreateIndexResponse doCreateAuditIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        return this.client.indices().create(new CreateIndexRequest.Builder().index(OpenSearchUtils.getAuditIndex(domain)).settings(settings).mappings(mappings).build());
    }

    public void createAuditIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        try {
            CreateIndexResponse response = this.doCreateAuditIndex(domain, settings, mappings);
            LOG.debug("Successfully created audit index {}: {}", (Object)OpenSearchUtils.getAuditIndex(domain), (Object)response);
        }
        catch (OpenSearchException e) {
            LOG.debug("Could not create audit index {} because it already exists", (Object)OpenSearchUtils.getAuditIndex(domain), (Object)e);
            this.removeAuditIndex(domain);
            this.doCreateAuditIndex(domain, settings, mappings);
        }
    }

    public void removeAuditIndex(String domain) throws IOException {
        DeleteIndexResponse response = this.client.indices().delete(new DeleteIndexRequest.Builder().index(OpenSearchUtils.getAuditIndex(domain), new String[0]).build());
        LOG.debug("Successfully removed {}: {}", (Object)OpenSearchUtils.getAuditIndex(domain), (Object)response);
    }

    @TransactionalEventListener
    public void entity(EntityLifecycleEvent<Entity> event) throws IOException {
        LOG.debug("About to {} index for {}", (Object)event.getType().name(), (Object)event.getEntity());
        Entity entity = event.getEntity();
        if (entity instanceof Any) {
            Any any = (Any)entity;
            if (event.getType() == SyncDeltaType.DELETE) {
                request = new DeleteRequest.Builder().index(OpenSearchUtils.getAnyIndex(event.getDomain(), any.getType().getKind())).id(any.getKey()).build();
                DeleteResponse response = this.client.delete((DeleteRequest)request);
                LOG.debug("Index successfully deleted for {}[{}]: {}", new Object[]{any.getType().getKind(), any.getKey(), response});
            } else {
                request = new IndexRequest.Builder().index(OpenSearchUtils.getAnyIndex(event.getDomain(), any.getType().getKind())).id(any.getKey()).document(this.openSearchUtils.document(any)).build();
                IndexResponse response = this.client.index((IndexRequest)request);
                LOG.debug("Index successfully created or updated for {}: {}", (Object)any, (Object)response);
            }
        } else {
            request = event.getEntity();
            if (request instanceof Realm) {
                Realm realm = (Realm)request;
                if (event.getType() == SyncDeltaType.DELETE) {
                    request = new DeleteRequest.Builder().index(OpenSearchUtils.getRealmIndex(event.getDomain())).id(realm.getKey()).refresh(Refresh.True).build();
                    DeleteResponse response = this.client.delete((DeleteRequest)request);
                    LOG.debug("Index successfully deleted for {}: {}", (Object)realm, (Object)response);
                } else {
                    request = new IndexRequest.Builder().index(OpenSearchUtils.getRealmIndex(event.getDomain())).id(realm.getKey()).document(this.openSearchUtils.document(realm)).refresh(Refresh.True).build();
                    IndexResponse response = this.client.index((IndexRequest)request);
                    LOG.debug("Index successfully created or updated for {}: {}", (Object)realm, (Object)response);
                }
            }
        }
    }

    public void audit(String domain, AuditEvent auditEvent) throws IOException {
        LOG.debug("About to audit");
        IndexRequest request = new IndexRequest.Builder().index(OpenSearchUtils.getAuditIndex(domain)).id(SecureRandomUtils.generateRandomUUID().toString()).document(this.openSearchUtils.document(auditEvent)).build();
        IndexResponse response = this.client.index(request);
        LOG.debug("Audit successfully created: {}", (Object)response);
    }
}

