/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.ConditionMetadata;
import org.apache.syncope.ext.openfga.client.model.ConditionParamTypeRef;

@JsonPropertyOrder(value={"name", "expression", "parameters", "metadata"})
public class Condition {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    @Nonnull
    private String expression;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    @Nullable
    private Map<String, ConditionParamTypeRef> parameters = new HashMap<String, ConditionParamTypeRef>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private ConditionMetadata metadata;

    public Condition name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Condition expression(@Nonnull String expression) {
        this.expression = expression;
        return this;
    }

    @Nonnull
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpression(@Nonnull String expression) {
        this.expression = expression;
    }

    public Condition parameters(@Nullable Map<String, ConditionParamTypeRef> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Condition putParametersItem(String key, ConditionParamTypeRef parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, ConditionParamTypeRef>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, ConditionParamTypeRef> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameters(@Nullable Map<String, ConditionParamTypeRef> parameters) {
        this.parameters = parameters;
    }

    public Condition metadata(@Nullable ConditionMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConditionMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable ConditionMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.name, condition.name) && Objects.equals(this.expression, condition.expression) && Objects.equals(this.parameters, condition.parameters) && Objects.equals(this.metadata, condition.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.parameters, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getName()))));
        }
        if (this.getExpression() != null) {
            joiner.add(String.format("%sexpression%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getExpression()))));
        }
        if (this.getParameters() != null) {
            for (String _key : this.getParameters().keySet()) {
                if (this.getParameters().get(_key) == null) continue;
                joiner.add(this.getParameters().get(_key).toUrlQueryString(String.format("%sparameters%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getMetadata() != null) {
            joiner.add(this.getMetadata().toUrlQueryString((String)prefix + JSON_PROPERTY_METADATA + suffix));
        }
        return joiner.toString();
    }
}

