/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.Configuration;
import org.apache.syncope.ext.openfga.client.Pair;
import org.apache.syncope.ext.openfga.client.model.ReadAuthorizationModelResponse;
import org.apache.syncope.ext.openfga.client.model.ReadAuthorizationModelsResponse;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelRequest;
import org.apache.syncope.ext.openfga.client.model.WriteAuthorizationModelResponse;

public class AuthorizationModelsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public AuthorizationModelsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationModelsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public ReadAuthorizationModelResponse readAuthorizationModel(@Nonnull String storeId, @Nonnull String id) throws ApiException {
        ApiResponse<ReadAuthorizationModelResponse> localVarResponse = this.readAuthorizationModelWithHttpInfo(storeId, id);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadAuthorizationModelResponse> readAuthorizationModelWithHttpInfo(@Nonnull String storeId, @Nonnull String id) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readAuthorizationModelRequestBuilder(storeId, id);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("readAuthorizationModel", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (ReadAuthorizationModelResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadAuthorizationModelResponse>(this){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readAuthorizationModelRequestBuilder(@Nonnull String storeId, @Nonnull String id) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling readAuthorizationModel");
        }
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling readAuthorizationModel");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/authorization-models/{id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{id}", ApiClient.urlEncode(id.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ReadAuthorizationModelsResponse readAuthorizationModels(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken) throws ApiException {
        ApiResponse<ReadAuthorizationModelsResponse> localVarResponse = this.readAuthorizationModelsWithHttpInfo(storeId, pageSize, continuationToken);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadAuthorizationModelsResponse> readAuthorizationModelsWithHttpInfo(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readAuthorizationModelsRequestBuilder(storeId, pageSize, continuationToken);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("readAuthorizationModels", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (ReadAuthorizationModelsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadAuthorizationModelsResponse>(this){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readAuthorizationModelsRequestBuilder(@Nonnull String storeId, @Nullable Integer pageSize, @Nullable String continuationToken) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling readAuthorizationModels");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/authorization-models".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "page_size";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page_size", pageSize));
        localVarQueryParameterBaseName = "continuation_token";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("continuation_token", continuationToken));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public WriteAuthorizationModelResponse writeAuthorizationModel(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body) throws ApiException {
        ApiResponse<WriteAuthorizationModelResponse> localVarResponse = this.writeAuthorizationModelWithHttpInfo(storeId, body);
        return localVarResponse.getData();
    }

    public ApiResponse<WriteAuthorizationModelResponse> writeAuthorizationModelWithHttpInfo(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.writeAuthorizationModelRequestBuilder(storeId, body);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("writeAuthorizationModel", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            localVarResponse.body().close();
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (responseBody.isBlank() ? null : (WriteAuthorizationModelResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<WriteAuthorizationModelResponse>(this){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder writeAuthorizationModelRequestBuilder(@Nonnull String storeId, @Nonnull WriteAuthorizationModelRequest body) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling writeAuthorizationModel");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling writeAuthorizationModel");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/authorization-models".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

