/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client;

import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.OpenFGAClient;
import org.apache.syncope.ext.openfga.client.OpenFGAClientFactory;
import org.apache.syncope.ext.openfga.client.model.ListStoresResponse;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class OpenFGAHealthIndicator
implements HealthIndicator {
    protected final DomainHolder<?> domainHolder;
    protected final OpenFGAClientFactory clientFactory;

    public OpenFGAHealthIndicator(DomainHolder<?> domainHolder, OpenFGAClientFactory clientFactory) {
        this.domainHolder = domainHolder;
        this.clientFactory = clientFactory;
    }

    public Health health() {
        Health.Builder builder = new Health.Builder();
        builder.withDetail("baseUri", (Object)this.clientFactory.getBaseUri());
        MutableObject anyDown = new MutableObject((Object)Boolean.FALSE);
        this.domainHolder.getDomains().keySet().forEach(arg_0 -> this.lambda$health$0(builder, (Mutable)anyDown, arg_0));
        builder.status((Boolean)anyDown.getValue() != false ? Status.DOWN : Status.UP);
        return builder.build();
    }

    private /* synthetic */ void lambda$health$0(Health.Builder builder, Mutable anyDown, String domain) {
        try {
            OpenFGAClient client = this.clientFactory.get(domain);
            ApiResponse<ListStoresResponse> response = client.listStoresWithHttpInfo();
            if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
                builder.withDetail(domain, Map.of("storeId", client.getStoreId(), "status", Status.UP.getCode()));
            } else {
                builder.withDetail(domain, (Object)Status.DOWN);
                anyDown.setValue((Object)true);
            }
        }
        catch (Exception e) {
            builder.withDetail(domain, (Object)Status.DOWN).withException((Throwable)e);
            anyDown.setValue((Object)true);
        }
    }
}

