/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.rest;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.syncope.common.rest.api.service.BpmnProcessService;

public class BpmnProcessRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 5049285686167071017L;

    private BpmnProcessService getService(MediaType mediaType) {
        BpmnProcessService service = (BpmnProcessService)this.getService(BpmnProcessService.class);
        Client client = WebClient.client((Object)service);
        client.type(mediaType);
        return service;
    }

    public List<BpmnProcess> getDefinitions() {
        return ((BpmnProcessService)this.getService(BpmnProcessService.class)).list();
    }

    public InputStream getDefinition(MediaType mediaType, String key) {
        Response response = this.getService(mediaType).get(key);
        SyncopeEnduserSession.get().resetClient(BpmnProcessService.class);
        return (InputStream)response.getEntity();
    }

    public byte[] getDiagram(String key) {
        byte[] diagram;
        BpmnProcessService service = (BpmnProcessService)this.getService(BpmnProcessService.class);
        WebClient.client((Object)service).accept(new String[]{"image/png"});
        Response response = service.exportDiagram(key);
        try {
            diagram = IOUtils.readBytesFromStream((InputStream)((InputStream)response.getEntity()));
        }
        catch (Exception e) {
            LOG.error("Could not get workflow diagram", (Throwable)e);
            diagram = new byte[]{};
        }
        return diagram;
    }
}

