/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.form.FormPropertyType;
import org.apache.syncope.common.lib.form.FormPropertyValue;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.flowable.api.DropdownValueProvider;
import org.apache.syncope.core.flowable.api.UserRequestHandler;
import org.apache.syncope.core.flowable.impl.FlowableRuntimeUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.form.FormProperty;
import org.flowable.engine.form.FormType;
import org.flowable.engine.form.TaskFormData;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.flowable.engine.runtime.NativeProcessInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public class FlowableUserRequestHandler
implements UserRequestHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(UserRequestHandler.class);
    protected final UserDataBinder dataBinder;
    protected final String adminUser;
    protected final DomainProcessEngine engine;
    protected final UserDAO userDAO;
    protected final EntityFactory entityFactory;

    public FlowableUserRequestHandler(UserDataBinder dataBinder, String adminUser, DomainProcessEngine engine, UserDAO userDAO, EntityFactory entityFactory) {
        this.dataBinder = dataBinder;
        this.adminUser = adminUser;
        this.engine = engine;
        this.userDAO = userDAO;
        this.entityFactory = entityFactory;
    }

    protected StringBuilder createProcessInstanceQuery(String userKey) {
        StringBuilder query = new StringBuilder().append("SELECT DISTINCT ID_,BUSINESS_KEY_,PROC_DEF_ID_,PROC_INST_ID_,START_TIME_ FROM ").append(this.engine.getManagementService().getTableName(ExecutionEntity.class)).append(" WHERE BUSINESS_KEY_ NOT LIKE '").append(FlowableRuntimeUtils.getProcBusinessKey("userWorkflow", "%")).append('\'');
        if (userKey != null) {
            query.append(" AND BUSINESS_KEY_ LIKE '").append(FlowableRuntimeUtils.getProcBusinessKey("%", userKey)).append('\'');
        }
        query.append(" AND PARENT_ID_ IS NULL");
        return query;
    }

    protected long countProcessInstances(StringBuilder processInstanceQuery) {
        return ((NativeProcessInstanceQuery)this.engine.getRuntimeService().createNativeProcessInstanceQuery().sql("SELECT COUNT(ID_) FROM " + StringUtils.substringAfter((String)processInstanceQuery.toString(), (String)" FROM "))).count();
    }

    protected UserRequest getUserRequest(ProcessInstance procInst) {
        Pair<String, String> split = FlowableRuntimeUtils.splitProcBusinessKey(procInst.getBusinessKey());
        UserRequest userRequest = new UserRequest();
        userRequest.setBpmnProcess((String)split.getLeft());
        userRequest.setStartTime(procInst.getStartTime());
        this.userDAO.findUsername((String)split.getRight()).ifPresent(arg_0 -> ((UserRequest)userRequest).setUsername(arg_0));
        userRequest.setExecutionId(procInst.getId());
        Task task = (Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(procInst.getProcessInstanceId())).singleResult();
        userRequest.setActivityId(task.getTaskDefinitionKey());
        userRequest.setTaskId(task.getId());
        userRequest.setHasForm(StringUtils.isNotBlank((CharSequence)task.getFormKey()));
        return userRequest;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<UserRequest> getUserRequests(String userKey, Pageable pageable) {
        StringBuilder query = this.createProcessInstanceQuery(userKey);
        long count = this.countProcessInstances(query);
        if (!pageable.getSort().isEmpty()) {
            query.append(" ORDER BY");
            for (Sort.Order clause : pageable.getSort()) {
                boolean sorted = true;
                switch (clause.getProperty().trim()) {
                    case "bpmnProcess": {
                        query.append(" PROC_DEF_ID_");
                        break;
                    }
                    case "startTime": {
                        query.append(" START_TIME_");
                        break;
                    }
                    case "executionId": {
                        query.append(" PROC_INST_ID_");
                        break;
                    }
                    default: {
                        LOG.warn("User request sort request by {}: unsupported, ignoring", (Object)clause.getProperty().trim());
                        sorted = false;
                    }
                }
                if (!sorted) continue;
                if (clause.getDirection() == Sort.Direction.ASC) {
                    query.append(" ASC,");
                    continue;
                }
                query.append(" DESC,");
            }
            query.setLength(query.length() - 1);
        }
        List<UserRequest> result = ((NativeProcessInstanceQuery)this.engine.getRuntimeService().createNativeProcessInstanceQuery().sql(query.toString())).listPage(pageable.getPageSize() * pageable.getPageNumber(), pageable.getPageSize()).stream().map(this::getUserRequest).toList();
        return new SyncopePage(result, pageable, count);
    }

    protected User lazyLoad(User user) {
        BeanUtils.copyProperties((Object)user, (Object)this.entityFactory.newEntity(User.class));
        return user;
    }

    @Override
    public UserRequest start(String bpmnProcess, User user, WorkflowTaskExecInput inputVariables) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("wfExecutor", AuthContextUtils.getUsername());
        variables.put("user", (String)this.lazyLoad(user));
        variables.put("userTO", (String)this.dataBinder.getUserTO(user, true));
        if (inputVariables != null) {
            variables.putAll(inputVariables.getVariables());
        }
        ProcessInstance procInst = null;
        try {
            procInst = this.engine.getRuntimeService().startProcessInstanceByKey(bpmnProcess, variables);
        }
        catch (FlowableException e) {
            FlowableRuntimeUtils.throwException(e, "While starting " + bpmnProcess + " instance");
        }
        this.engine.getRuntimeService().updateBusinessKey(Objects.requireNonNull(procInst).getProcessInstanceId(), FlowableRuntimeUtils.getProcBusinessKey(bpmnProcess, user.getKey()));
        return this.getUserRequest((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInst.getProcessInstanceId()).singleResult());
    }

    @Override
    public Pair<ProcessInstance, String> parse(String executionId) {
        ProcessInstance procInst = null;
        try {
            procInst = (ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(executionId).singleResult();
            if (procInst == null) {
                throw new FlowableIllegalArgumentException("ProcessInstance with id " + executionId);
            }
        }
        catch (FlowableException e) {
            LOG.error("Could find execution ProcessInstance with id {}", (Object)executionId, (Object)e);
            throw new NotFoundException("User request execution with id " + executionId);
        }
        return Pair.of((Object)procInst, (Object)this.getUserKey(procInst.getProcessInstanceId()));
    }

    @Override
    public void cancel(ProcessInstance procInst, String reason) {
        if ("userWorkflow".equals(procInst.getProcessDefinitionKey())) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Cannot cancel a userWorkflow execution"));
        }
        this.engine.getRuntimeService().deleteProcessInstance(procInst.getId(), reason);
    }

    @Override
    public void cancelByProcessDefinition(String processDefinitionId) {
        this.engine.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinitionId).list().forEach(procInst -> this.engine.getRuntimeService().deleteProcessInstance(procInst.getId(), "Cascade Delete process definition " + processDefinitionId));
    }

    @Override
    public void cancelByUser(EntityLifecycleEvent<Entity> event) {
        Entity entity;
        if (AuthContextUtils.getDomain().equals(event.getDomain()) && event.getType() == SyncDeltaType.DELETE && (entity = event.getEntity()) instanceof User) {
            User user = (User)entity;
            ((NativeProcessInstanceQuery)this.engine.getRuntimeService().createNativeProcessInstanceQuery().sql(this.createProcessInstanceQuery(user.getKey()).toString())).list().forEach(procInst -> this.engine.getRuntimeService().deleteProcessInstance(procInst.getId(), "Cascade Delete user " + user.getUsername()));
        }
    }

    protected static FormPropertyType fromFlowableFormType(FormType flowableFormType) {
        FormPropertyType result = FormPropertyType.String;
        if (null != flowableFormType.getName()) {
            switch (flowableFormType.getName()) {
                case "long": {
                    result = FormPropertyType.Long;
                    break;
                }
                case "enum": {
                    result = FormPropertyType.Enum;
                    break;
                }
                case "date": {
                    result = FormPropertyType.Date;
                    break;
                }
                case "boolean": {
                    result = FormPropertyType.Boolean;
                    break;
                }
                case "dropdown": {
                    result = FormPropertyType.Dropdown;
                    break;
                }
                case "password": {
                    result = FormPropertyType.Password;
                    break;
                }
            }
        }
        return result;
    }

    protected UserRequestForm getForm(Task task) {
        return Optional.ofNullable(task).map(t -> this.getForm((Task)t, this.engine.getFormService().getTaskFormData(t.getId()))).orElse(null);
    }

    protected UserRequestForm getForm(Task task, TaskFormData fd) {
        UserRequestForm formTO = this.getForm(task.getProcessInstanceId(), task.getId(), fd.getFormKey(), fd.getFormProperties());
        formTO.setCreateTime(task.getCreateTime());
        formTO.setDueDate(task.getDueDate());
        formTO.setExecutionId(task.getExecutionId());
        formTO.setFormKey(task.getFormKey());
        formTO.setAssignee(task.getAssignee());
        return formTO;
    }

    protected UserRequestForm getForm(HistoricTaskInstance task) {
        List<HistoricFormPropertyEntity> props = this.engine.getHistoryService().createHistoricDetailQuery().taskId(task.getId()).list().stream().filter(HistoricFormPropertyEntity.class::isInstance).map(HistoricFormPropertyEntity.class::cast).toList();
        UserRequestForm formTO = this.getHistoricFormTO(task.getProcessInstanceId(), task.getId(), task.getFormKey(), props);
        formTO.setCreateTime(task.getCreateTime());
        formTO.setDueDate(task.getDueDate());
        formTO.setExecutionId(task.getExecutionId());
        formTO.setFormKey(task.getFormKey());
        formTO.setAssignee(task.getAssignee());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.engine.getHistoryService().createHistoricActivityInstanceQuery().executionId(task.getExecutionId()).activityType("userTask").activityName(task.getName()).singleResult();
        if (historicActivityInstance != null) {
            formTO.setCreateTime(historicActivityInstance.getStartTime());
            formTO.setDueDate(historicActivityInstance.getEndTime());
        }
        return formTO;
    }

    protected String getUserKey(String procInstId) {
        String procBusinessKey = ((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getBusinessKey();
        return StringUtils.substringAfter((String)procBusinessKey, (String)":");
    }

    protected UserRequestForm getHistoricFormTO(String procInstId, String taskId, String formKey, List<HistoricFormPropertyEntity> props) {
        UserRequestForm formTO = new UserRequestForm();
        formTO.setBpmnProcess(((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getProcessDefinitionKey());
        User user = (User)this.userDAO.findById(this.getUserKey(procInstId)).orElseThrow(() -> new NotFoundException("User for process instance id " + procInstId));
        formTO.setUsername(user.getUsername());
        formTO.setTaskId(taskId);
        formTO.setFormKey(formKey);
        formTO.setUserTO((UserTO)this.engine.getRuntimeService().getVariable(procInstId, "userTO", UserTO.class));
        formTO.setUserUR((UserUR)this.engine.getRuntimeService().getVariable(procInstId, "userUR", UserUR.class));
        formTO.getProperties().addAll(props.stream().map(prop -> {
            org.apache.syncope.common.lib.form.FormProperty propertyTO = new org.apache.syncope.common.lib.form.FormProperty();
            propertyTO.setId(prop.getPropertyId());
            propertyTO.setName(prop.getPropertyId());
            propertyTO.setValue(prop.getPropertyValue());
            return propertyTO;
        }).toList());
        return formTO;
    }

    protected UserRequestForm getForm(String procInstId, String taskId, String formKey, List<FormProperty> props) {
        UserRequestForm formTO = new UserRequestForm();
        formTO.setBpmnProcess(((ProcessInstance)this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult()).getProcessDefinitionKey());
        User user = (User)this.userDAO.findById(this.getUserKey(procInstId)).orElseThrow(() -> new NotFoundException("User for process instance id " + procInstId));
        formTO.setUsername(user.getUsername());
        formTO.setTaskId(taskId);
        formTO.setFormKey(formKey);
        formTO.setUserTO((UserTO)this.engine.getRuntimeService().getVariable(procInstId, "userTO", UserTO.class));
        formTO.setUserUR((UserUR)this.engine.getRuntimeService().getVariable(procInstId, "userUR", UserUR.class));
        formTO.getProperties().addAll(props.stream().map(fProp -> {
            org.apache.syncope.common.lib.form.FormProperty propertyTO = new org.apache.syncope.common.lib.form.FormProperty();
            propertyTO.setId(fProp.getId());
            propertyTO.setName(fProp.getName());
            propertyTO.setReadable(fProp.isReadable());
            propertyTO.setRequired(fProp.isRequired());
            propertyTO.setWritable(fProp.isWritable());
            propertyTO.setValue(fProp.getValue());
            propertyTO.setType(FlowableUserRequestHandler.fromFlowableFormType(fProp.getType()));
            switch (propertyTO.getType()) {
                case Date: {
                    propertyTO.setDatePattern((String)fProp.getType().getInformation("datePattern"));
                    break;
                }
                case Enum: {
                    ((Map)fProp.getType().getInformation("values")).forEach((key, value) -> propertyTO.getEnumValues().add(new FormPropertyValue(key, value)));
                    break;
                }
                case Dropdown: {
                    String valueProviderBean = (String)fProp.getType().getInformation("dropdownValueProvider");
                    try {
                        DropdownValueProvider valueProvider = (DropdownValueProvider)ApplicationContextProvider.getApplicationContext().getBean(valueProviderBean, DropdownValueProvider.class);
                        valueProvider.getValues().forEach((key, value) -> propertyTO.getDropdownValues().add(new FormPropertyValue(key, value)));
                    }
                    catch (Exception e) {
                        LOG.error("Could not find bean {} of type {} for form property {}", new Object[]{valueProviderBean, DropdownValueProvider.class.getName(), propertyTO.getId(), e});
                    }
                    break;
                }
            }
            return propertyTO;
        }).toList());
        return formTO;
    }

    @Override
    public UserRequestForm getForm(String userKey, String taskId) {
        String authUser;
        TaskQuery query = (TaskQuery)this.engine.getTaskService().createTaskQuery().taskId(taskId);
        if (userKey != null) {
            query.processInstanceBusinessKeyLike(FlowableRuntimeUtils.getProcBusinessKey("%", userKey));
        }
        return this.adminUser.equals(authUser = AuthContextUtils.getUsername()) ? this.getForm(this.getTask(taskId)) : this.getForm((Task)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)query.or()).taskCandidateUser(authUser)).taskAssignee(authUser)).endOr()).singleResult());
    }

    @Override
    @Transactional(readOnly=true)
    public Page<UserRequestForm> getForms(String userKey, Pageable pageable) {
        String authUser;
        TaskQuery query = (TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey();
        if (userKey != null) {
            query.processInstanceBusinessKeyLike(FlowableRuntimeUtils.getProcBusinessKey("%", userKey));
        }
        return this.adminUser.equals(authUser = AuthContextUtils.getUsername()) ? this.getForms(query, pageable) : this.getForms((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)query.or()).taskCandidateUser(authUser)).taskAssignee(authUser)).endOr(), pageable);
    }

    protected Page<UserRequestForm> getForms(TaskQuery query, Pageable pageable) {
        for (Sort.Order clause : pageable.getSort()) {
            boolean sorted = true;
            switch (clause.getProperty().trim()) {
                case "bpmnProcess": {
                    query.orderByProcessDefinitionId();
                    break;
                }
                case "executionId": {
                    query.orderByExecutionId();
                    break;
                }
                case "taskId": {
                    query.orderByTaskId();
                    break;
                }
                case "createTime": {
                    query.orderByTaskCreateTime();
                    break;
                }
                case "dueDate": {
                    query.orderByTaskDueDate();
                    break;
                }
                case "assignee": {
                    query.orderByTaskAssignee();
                    break;
                }
                default: {
                    LOG.warn("Form sort request by {}: unsupported, ignoring", (Object)clause.getProperty().trim());
                    sorted = false;
                }
            }
            if (!sorted) continue;
            if (clause.getDirection() == Sort.Direction.ASC) {
                query.asc();
                continue;
            }
            query.desc();
        }
        List<UserRequestForm> result = query.listPage(pageable.getPageSize() * pageable.getPageNumber(), pageable.getPageSize()).stream().map(task -> {
            UserRequestForm userRequestForm;
            if (task instanceof HistoricTaskInstance) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)task;
                userRequestForm = this.getForm(historicTaskInstance);
            } else {
                userRequestForm = this.getForm((Task)task);
            }
            return userRequestForm;
        }).toList();
        return new SyncopePage(result, pageable, query.count());
    }

    protected Pair<Task, TaskFormData> parseTask(String taskId) {
        TaskFormData formData;
        Task task = this.getTask(taskId);
        try {
            formData = this.engine.getFormService().getTaskFormData(task.getId());
        }
        catch (FlowableException e) {
            throw new NotFoundException("Form for Flowable Task " + taskId, (Exception)((Object)e));
        }
        return Pair.of((Object)task, (Object)formData);
    }

    protected Task getTask(String taskId) throws NotFoundException {
        Task task;
        try {
            task = (Task)((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).singleResult();
            if (task == null) {
                throw new FlowableException("NULL result");
            }
        }
        catch (FlowableException e) {
            throw new NotFoundException("Flowable Task " + taskId, (Exception)((Object)e));
        }
        return task;
    }

    @Override
    public UserRequestForm claimForm(String taskId) {
        Task task;
        List tasksForUser;
        Pair<Task, TaskFormData> parsed = this.parseTask(taskId);
        String authUser = AuthContextUtils.getUsername();
        if (!this.adminUser.equals(authUser) && (tasksForUser = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).or()).taskCandidateUser(authUser)).taskAssignee(authUser)).endOr()).list()).isEmpty()) {
            throw new WorkflowException((Throwable)new IllegalArgumentException(authUser + " is not candidate nor assignee of task " + taskId));
        }
        boolean hasAssignees = this.engine.getTaskService().getIdentityLinksForTask(taskId).stream().anyMatch(identityLink -> "assignee".equals(identityLink.getType()));
        if (hasAssignees) {
            try {
                this.engine.getTaskService().unclaim(taskId);
            }
            catch (FlowableException e) {
                throw new WorkflowException("While unclaiming task " + taskId, (Throwable)e);
            }
        }
        try {
            this.engine.getTaskService().claim(taskId, authUser);
            task = (Task)((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While reading task " + taskId, (Throwable)e);
        }
        return this.getForm(task, (TaskFormData)parsed.getRight());
    }

    @Override
    public UserRequestForm unclaimForm(String taskId) {
        Task task;
        Pair<Task, TaskFormData> parsed = this.parseTask(taskId);
        try {
            this.engine.getTaskService().unclaim(taskId);
            task = (Task)((TaskQuery)((TaskQuery)this.engine.getTaskService().createTaskQuery().taskWithFormKey()).taskId(taskId)).singleResult();
        }
        catch (FlowableException e) {
            throw new WorkflowException("While unclaiming task " + taskId, (Throwable)e);
        }
        return this.getForm(task, (TaskFormData)parsed.getRight());
    }

    protected Map<String, String> getPropertiesForSubmit(UserRequestForm form) {
        HashMap props = new HashMap();
        form.getProperties().stream().filter(org.apache.syncope.common.lib.form.FormProperty::isWritable).forEach(prop -> props.put(prop.getId(), prop.getValue()));
        return Collections.unmodifiableMap(props);
    }

    protected <T> T getHistoricVariable(List<HistoricVariableInstance> historicVariables, String name, Class<T> valueRef) {
        return historicVariables.stream().filter(v -> name.equals(v.getVariableName())).findFirst().map(v -> valueRef.cast(v.getValue())).orElse(null);
    }

    @Override
    public UserWorkflowResult<UserUR> submitForm(UserRequestForm form) {
        UserUR userUR;
        PropagationByResource propByLinkedAccount;
        PropagationByResource propByRes;
        Pair<Task, TaskFormData> parsed = this.parseTask(form.getTaskId());
        String authUser = AuthContextUtils.getUsername();
        if (!((Task)parsed.getLeft()).getAssignee().equals(authUser)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Task " + form.getTaskId() + " assigned to " + ((Task)parsed.getLeft()).getAssignee() + " but submitted by " + authUser));
        }
        String procInstId = ((Task)parsed.getLeft()).getProcessInstanceId();
        User user = (User)this.userDAO.findById(this.getUserKey(procInstId)).orElseThrow(() -> new NotFoundException("User for process instance id " + procInstId));
        Set<String> preTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstId);
        this.engine.getRuntimeService().setVariable(procInstId, "task", (Object)"submit");
        this.engine.getRuntimeService().setVariable(procInstId, "formSubmitter", (Object)authUser);
        this.engine.getRuntimeService().setVariable(procInstId, "user", (Object)this.lazyLoad(user));
        try {
            this.engine.getFormService().submitTaskFormData(form.getTaskId(), this.getPropertiesForSubmit(form));
        }
        catch (FlowableException e) {
            FlowableRuntimeUtils.throwException(e, "While submitting form for task " + form.getTaskId());
        }
        Set<String> postTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstId);
        postTasks.removeAll(preTasks);
        postTasks.add(form.getTaskId());
        if (procInstId.equals(FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey()))) {
            FlowableRuntimeUtils.updateStatus(this.engine, procInstId, user);
        }
        user = (User)this.userDAO.save((Entity)user);
        String clearPassword = null;
        if (this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstId).singleResult() == null) {
            List historicVariables = this.engine.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(procInstId).list();
            propByRes = this.getHistoricVariable(historicVariables, "propByResource", PropagationByResource.class);
            propByLinkedAccount = this.getHistoricVariable(historicVariables, "propByLinkedAccount", PropagationByResource.class);
            String encryptedPwd = this.getHistoricVariable(historicVariables, "encryptedPwd", String.class);
            if (StringUtils.isNotBlank((CharSequence)encryptedPwd)) {
                clearPassword = FlowableRuntimeUtils.decrypt(encryptedPwd);
            }
            userUR = this.getHistoricVariable(historicVariables, "userUR", UserUR.class);
        } else {
            this.engine.getRuntimeService().removeVariable(procInstId, "task");
            this.engine.getRuntimeService().removeVariable(procInstId, "formSubmitter");
            this.engine.getRuntimeService().removeVariable(procInstId, "user");
            this.engine.getRuntimeService().removeVariable(procInstId, "userTO");
            propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstId, "propByResource", PropagationByResource.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "propByResource");
            propByLinkedAccount = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstId, "propByLinkedAccount", PropagationByResource.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "propByLinkedAccount");
            String encryptedPwd = (String)this.engine.getRuntimeService().getVariable(procInstId, "encryptedPwd", String.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "encryptedPwd");
            if (StringUtils.isNotBlank((CharSequence)encryptedPwd)) {
                clearPassword = FlowableRuntimeUtils.decrypt(encryptedPwd);
            }
            Boolean enabled = (Boolean)this.engine.getRuntimeService().getVariable(procInstId, "enabled", Boolean.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "enabled");
            FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstId, this.dataBinder.getUserTO(user, true), clearPassword, enabled, (PropagationByResource<String>)propByRes, (PropagationByResource<Pair<String, String>>)propByLinkedAccount);
            userUR = (UserUR)this.engine.getRuntimeService().getVariable(procInstId, "userUR", UserUR.class);
            this.engine.getRuntimeService().removeVariable(procInstId, "userUR");
        }
        if (userUR == null) {
            userUR = new UserUR();
            userUR.setKey(user.getKey());
            userUR.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).value((Object)clearPassword)).build());
            HashSet<String> pwdResources = new HashSet<String>();
            if (propByRes != null) {
                pwdResources.addAll(propByRes.get(ResourceOperation.CREATE));
            }
            if (propByLinkedAccount != null) {
                pwdResources.addAll(propByLinkedAccount.get(ResourceOperation.CREATE).stream().map(Pair::getLeft).toList());
            }
            userUR.getPassword().getResources().addAll(pwdResources);
        }
        return new UserWorkflowResult((Object)userUR, propByRes, propByLinkedAccount, postTasks);
    }
}

