/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.elasticsearch.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplate;
import co.elastic.clients.elasticsearch._types.mapping.KeywordProperty;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TextProperty;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexResponse;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.IndexSettingsAnalysis;
import co.elastic.clients.util.NamedValue;
import java.io.IOException;
import java.util.List;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AuditEvent;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.ext.elasticsearch.client.ElasticsearchUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.event.TransactionalEventListener;

public class ElasticsearchIndexManager {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchIndexManager.class);
    protected final ElasticsearchClient client;
    protected final ElasticsearchUtils elasticsearchUtils;
    protected final String numberOfShards;
    protected final String numberOfReplicas;

    public ElasticsearchIndexManager(ElasticsearchClient client, ElasticsearchUtils elasticsearchUtils, String numberOfShards, String numberOfReplicas) {
        this.client = client;
        this.elasticsearchUtils = elasticsearchUtils;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
    }

    public boolean existsAnyIndex(String domain, AnyTypeKind kind) throws IOException {
        return this.client.indices().exists(new ExistsRequest.Builder().index(ElasticsearchUtils.getAnyIndex(domain, kind), new String[0]).build()).value();
    }

    public boolean existsRealmIndex(String domain) throws IOException {
        return this.client.indices().exists(new ExistsRequest.Builder().index(ElasticsearchUtils.getRealmIndex(domain), new String[0]).build()).value();
    }

    public boolean existsAuditIndex(String domain) throws IOException {
        return this.client.indices().exists(new ExistsRequest.Builder().index(ElasticsearchUtils.getAuditIndex(domain), new String[0]).build()).value();
    }

    public IndexSettings defaultSettings() {
        return new IndexSettings.Builder().analysis(new IndexSettingsAnalysis.Builder().build()).numberOfShards(this.numberOfShards).numberOfReplicas(this.numberOfReplicas).build();
    }

    public TypeMapping defaultAnyMapping() {
        return new TypeMapping.Builder().dynamicTemplates(List.of(new NamedValue("strings", (Object)new DynamicTemplate.Builder().matchMappingType("string", new String[0]).mapping((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build()).build()))).build();
    }

    public TypeMapping defaultRealmMapping() {
        return new TypeMapping.Builder().dynamicTemplates(List.of(new NamedValue("strings", (Object)new DynamicTemplate.Builder().matchMappingType("string", new String[0]).mapping((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build()).build()))).build();
    }

    public TypeMapping defaultAuditMapping() {
        return new TypeMapping.Builder().dynamicTemplates(List.of(new NamedValue("strings", (Object)new DynamicTemplate.Builder().matchMappingType("string", new String[0]).mapping((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build()).build()))).properties("before", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).properties("inputs", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).properties("output", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).properties("throwable", (Property)new Property.Builder().text(new TextProperty.Builder().analyzer("standard").build()).build()).build();
    }

    protected CreateIndexResponse doCreateAnyIndex(String domain, AnyTypeKind kind, IndexSettings settings, TypeMapping mappings) throws IOException {
        return this.client.indices().create(new CreateIndexRequest.Builder().index(ElasticsearchUtils.getAnyIndex(domain, kind)).settings(settings).mappings(mappings).build());
    }

    public void createAnyIndex(String domain, AnyTypeKind kind, IndexSettings settings, TypeMapping mappings) throws IOException {
        try {
            CreateIndexResponse response = this.doCreateAnyIndex(domain, kind, settings, mappings);
            LOG.debug("Successfully created {} for {}: {}", new Object[]{ElasticsearchUtils.getAnyIndex(domain, kind), kind.name(), response});
        }
        catch (ElasticsearchException e) {
            LOG.debug("Could not create index {} because it already exists", (Object)ElasticsearchUtils.getAnyIndex(domain, kind), (Object)e);
            this.removeAnyIndex(domain, kind);
            this.doCreateAnyIndex(domain, kind, settings, mappings);
        }
    }

    public void removeAnyIndex(String domain, AnyTypeKind kind) throws IOException {
        DeleteIndexResponse response = this.client.indices().delete(new DeleteIndexRequest.Builder().index(ElasticsearchUtils.getAnyIndex(domain, kind), new String[0]).build());
        LOG.debug("Successfully removed {}: {}", (Object)ElasticsearchUtils.getAnyIndex(domain, kind), (Object)response);
    }

    protected CreateIndexResponse doCreateRealmIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        return this.client.indices().create(new CreateIndexRequest.Builder().index(ElasticsearchUtils.getRealmIndex(domain)).settings(settings).mappings(mappings).build());
    }

    public void createRealmIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        try {
            CreateIndexResponse response = this.doCreateRealmIndex(domain, settings, mappings);
            LOG.debug("Successfully created realm index {}: {}", (Object)ElasticsearchUtils.getRealmIndex(domain), (Object)response);
        }
        catch (ElasticsearchException e) {
            LOG.debug("Could not create realm index {} because it already exists", (Object)ElasticsearchUtils.getRealmIndex(domain), (Object)e);
            this.removeRealmIndex(domain);
            this.doCreateRealmIndex(domain, settings, mappings);
        }
    }

    public void removeRealmIndex(String domain) throws IOException {
        DeleteIndexResponse response = this.client.indices().delete(new DeleteIndexRequest.Builder().index(ElasticsearchUtils.getRealmIndex(domain), new String[0]).build());
        LOG.debug("Successfully removed {}: {}", (Object)ElasticsearchUtils.getRealmIndex(domain), (Object)response);
    }

    protected CreateIndexResponse doCreateAuditIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        return this.client.indices().create(new CreateIndexRequest.Builder().index(ElasticsearchUtils.getAuditIndex(domain)).settings(settings).mappings(mappings).build());
    }

    public void createAuditIndex(String domain, IndexSettings settings, TypeMapping mappings) throws IOException {
        try {
            CreateIndexResponse response = this.doCreateAuditIndex(domain, settings, mappings);
            LOG.debug("Successfully created audit index {}: {}", (Object)ElasticsearchUtils.getAuditIndex(domain), (Object)response);
        }
        catch (ElasticsearchException e) {
            LOG.debug("Could not create audit index {} because it already exists", (Object)ElasticsearchUtils.getAuditIndex(domain), (Object)e);
            this.removeAuditIndex(domain);
            this.doCreateAuditIndex(domain, settings, mappings);
        }
    }

    public void removeAuditIndex(String domain) throws IOException {
        DeleteIndexResponse response = this.client.indices().delete(new DeleteIndexRequest.Builder().index(ElasticsearchUtils.getAuditIndex(domain), new String[0]).build());
        LOG.debug("Successfully removed {}: {}", (Object)ElasticsearchUtils.getAuditIndex(domain), (Object)response);
    }

    @TransactionalEventListener
    public void entity(EntityLifecycleEvent<Entity> event) throws IOException {
        LOG.debug("About to {} index for {}", (Object)event.getType().name(), (Object)event.getEntity());
        Entity entity = event.getEntity();
        if (entity instanceof Any) {
            Any any = (Any)entity;
            if (event.getType() == SyncDeltaType.DELETE) {
                request = new DeleteRequest.Builder().index(ElasticsearchUtils.getAnyIndex(event.getDomain(), any.getType().getKind())).id(any.getKey()).build();
                DeleteResponse response = this.client.delete((DeleteRequest)request);
                LOG.debug("Index successfully deleted for {}[{}]: {}", new Object[]{any.getType().getKind(), any.getKey(), response});
            } else {
                request = new IndexRequest.Builder().index(ElasticsearchUtils.getAnyIndex(event.getDomain(), any.getType().getKind())).id(any.getKey()).document(this.elasticsearchUtils.document(any)).build();
                IndexResponse response = this.client.index((IndexRequest)request);
                LOG.debug("Index successfully created or updated for {}: {}", (Object)any, (Object)response);
            }
        } else {
            request = event.getEntity();
            if (request instanceof Realm) {
                Realm realm = (Realm)request;
                if (event.getType() == SyncDeltaType.DELETE) {
                    request = new DeleteRequest.Builder().index(ElasticsearchUtils.getRealmIndex(event.getDomain())).id(realm.getKey()).refresh(Refresh.True).build();
                    DeleteResponse response = this.client.delete((DeleteRequest)request);
                    LOG.debug("Index successfully deleted for {}: {}", (Object)realm, (Object)response);
                } else {
                    request = new IndexRequest.Builder().index(ElasticsearchUtils.getRealmIndex(event.getDomain())).id(realm.getKey()).document(this.elasticsearchUtils.document(realm)).refresh(Refresh.True).build();
                    IndexResponse response = this.client.index((IndexRequest)request);
                    LOG.debug("Index successfully created or updated for {}: {}", (Object)realm, (Object)response);
                }
            }
        }
    }

    public void audit(String domain, AuditEvent auditEvent) throws IOException {
        LOG.debug("About to audit");
        IndexRequest request = new IndexRequest.Builder().index(ElasticsearchUtils.getAuditIndex(domain)).document(this.elasticsearchUtils.document(auditEvent)).build();
        IndexResponse response = this.client.index(request);
        LOG.debug("Audit successfully created: {}", (Object)response);
    }
}

