/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.elasticsearch.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.springframework.transaction.annotation.Transactional;

public class ElasticsearchUtils {
    protected static final char[] ELASTICSEARCH_REGEX_CHARS = new char[]{'.', '?', '+', '*', '|', '{', '}', '[', ']', '(', ')', '\"', '\\', '&'};
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;

    public static String getAnyIndex(String domain, AnyTypeKind kind) {
        return domain.toLowerCase() + "_" + kind.name().toLowerCase();
    }

    public static String getRealmIndex(String domain) {
        return domain.toLowerCase() + "_realm";
    }

    public static String getAuditIndex(String domain) {
        return domain.toLowerCase() + "_audit";
    }

    public static String escapeForLikeRegex(char c) {
        StringBuilder output = new StringBuilder();
        if (ArrayUtils.contains((char[])ELASTICSEARCH_REGEX_CHARS, (char)c)) {
            output.append('\\');
        }
        output.append(c);
        return output.toString();
    }

    public ElasticsearchUtils(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO) {
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
    }

    @Transactional
    public Map<String, Object> document(Any<?> any) {
        Collection resources;
        Collection collection = any instanceof User ? this.userDAO.findAllResourceKeys(any.getKey()) : (resources = any instanceof AnyObject ? this.anyObjectDAO.findAllResourceKeys(any.getKey()) : this.groupDAO.findAllResourceKeys(any.getKey()));
        List dynRealms = any instanceof User ? this.userDAO.findDynRealms(any.getKey()) : (any instanceof AnyObject ? this.anyObjectDAO.findDynRealms(any.getKey()) : this.groupDAO.findDynRealms(any.getKey()));
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.put("id", any.getKey());
        builder.put("realm", any.getRealm().getKey());
        builder.put("anyType", any.getType().getKey());
        builder.put("creationDate", any.getCreationDate());
        builder.put("creationContext", any.getCreationContext());
        builder.put("creator", any.getCreator());
        builder.put("lastChangeDate", any.getLastChangeDate());
        builder.put("lastModifier", any.getLastModifier());
        builder.put("lastChangeContext", any.getLastChangeContext());
        builder.put("status", any.getStatus());
        builder.put("auxClasses", any.getAuxClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
        builder.put("resources", resources);
        builder.put("dynRealms", dynRealms);
        if (any instanceof AnyObject) {
            AnyObject anyObject = (AnyObject)any;
            builder.put("name", anyObject.getName());
            builder.put("memberships", this.anyObjectDAO.findAllGroupKeys(anyObject));
            ArrayList relationships = new ArrayList();
            ArrayList relationshipTypes = new ArrayList();
            this.anyObjectDAO.findAllRelationships(anyObject).forEach(relationship -> {
                relationships.add(((AnyObject)relationship.getRightEnd()).getKey());
                relationshipTypes.add(relationship.getType().getKey());
            });
            builder.put("relationships", relationships);
            builder.put("relationshipTypes", relationshipTypes);
            this.customizeDocument(builder, anyObject);
        } else if (any instanceof Group) {
            Group group = (Group)any;
            builder.put("name", group.getName());
            Optional.ofNullable(group.getUserOwner()).ifPresent(uo -> builder.put("userOwner", uo.getKey()));
            Optional.ofNullable(group.getGroupOwner()).ifPresent(go -> builder.put("groupOwner", go.getKey()));
            HashSet members = new HashSet();
            members.addAll(this.groupDAO.findUMemberships(group).stream().map(membership -> ((User)membership.getLeftEnd()).getKey()).collect(Collectors.toList()));
            members.addAll(this.groupDAO.findUDynMembers(group));
            members.addAll(this.groupDAO.findAMemberships(group).stream().map(membership -> ((AnyObject)membership.getLeftEnd()).getKey()).collect(Collectors.toList()));
            members.addAll(this.groupDAO.findADynMembers(group));
            builder.put("members", members);
            this.customizeDocument(builder, group);
        } else if (any instanceof User) {
            User user = (User)any;
            builder.put("username", user.getUsername());
            builder.put("token", user.getToken());
            builder.put("tokenExpireTime", user.getTokenExpireTime());
            builder.put("changePwdDate", user.getChangePwdDate());
            builder.put("failedLogins", user.getFailedLogins());
            builder.put("lastLoginDate", user.getLastLoginDate());
            builder.put("suspended", user.isSuspended());
            builder.put("mustChangePassword", user.isMustChangePassword());
            ArrayList roles = new ArrayList();
            HashSet privileges = new HashSet();
            this.userDAO.findAllRoles(user).forEach(role -> {
                roles.add(role.getKey());
                privileges.addAll(role.getPrivileges().stream().map(Entity::getKey).collect(Collectors.toSet()));
            });
            builder.put("roles", roles);
            builder.put("privileges", privileges);
            builder.put("memberships", this.userDAO.findAllGroupKeys(user));
            ArrayList relationships = new ArrayList();
            HashSet relationshipTypes = new HashSet();
            user.getRelationships().forEach(relationship -> {
                relationships.add(((AnyObject)relationship.getRightEnd()).getKey());
                relationshipTypes.add(relationship.getType().getKey());
            });
            builder.put("relationships", relationships);
            builder.put("relationshipTypes", relationshipTypes);
            this.customizeDocument(builder, user);
        }
        for (PlainAttr plainAttr : any.getPlainAttrs()) {
            List values = plainAttr.getValues().stream().map(PlainAttrValue::getValue).collect(Collectors.toList());
            Optional.ofNullable(plainAttr.getUniqueValue()).ifPresent(v -> values.add(v.getValue()));
            builder.put(plainAttr.getSchema().getKey(), values.size() == 1 ? values.get(0) : values);
        }
        if (any instanceof GroupableRelatable) {
            GroupableRelatable groupable = (GroupableRelatable)GroupableRelatable.class.cast(any);
            groupable.getMemberships().forEach(m -> groupable.getPlainAttrs(m).forEach(mAttr -> {
                List values = mAttr.getValues().stream().map(PlainAttrValue::getValue).collect(Collectors.toList());
                Optional.ofNullable(mAttr.getUniqueValue()).ifPresent(v -> values.add(v.getValue()));
                Object attr = builder.computeIfAbsent(mAttr.getSchema().getKey(), k -> new HashSet());
                if (attr instanceof Collection) {
                    ((Collection)attr).addAll(values);
                } else {
                    values.add(attr);
                    builder.put(mAttr.getSchema().getKey(), values.size() == 1 ? values.get(0) : values);
                }
            }));
        }
        return builder;
    }

    protected void customizeDocument(Map<String, Object> builder, AnyObject anyObject) {
    }

    protected void customizeDocument(Map<String, Object> builder, Group group) {
    }

    protected void customizeDocument(Map<String, Object> builder, User user) {
    }

    public Map<String, Object> document(Realm realm) {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.put("id", realm.getKey());
        builder.put("name", realm.getName());
        builder.put("parent_id", realm.getParent() == null ? null : realm.getParent().getKey());
        builder.put("fullPath", realm.getFullPath());
        this.customizeDocument(builder, realm);
        return builder;
    }

    protected void customizeDocument(Map<String, Object> builder, Realm realm) {
    }

    public Map<String, Object> document(long instant, JsonNode message, String domain) throws IOException {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.put("instant", instant);
        builder.put("message", message);
        this.customizeDocument(builder, instant, message, domain);
        return builder;
    }

    protected void customizeDocument(Map<String, Object> builder, long instant, JsonNode message, String domain) throws IOException {
    }
}

