/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.resources.BaseUserSelfResource;
import org.apache.syncope.client.enduser.util.Validation;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="userSelfUpdate", path="/api/self/update")
public class UserSelfUpdateResource
extends BaseUserSelfResource {
    private static final long serialVersionUID = -2721621682300247583L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("text/plain");
        try {
            Map<String, CustomAttributesInfo> customFormAttributes;
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            if (!this.captchaCheck(request.getHeader("captcha"), request.getSession().getAttribute("captcha"))) {
                throw new IllegalArgumentException("Entered captcha is not matching");
            }
            UserTO userTO = (UserTO)MAPPER.readValue(request.getReader().readLine(), UserTO.class);
            if (Validation.isCompliant(userTO, customFormAttributes = SyncopeEnduserApplication.get().getCustomFormAttributes(), false)) {
                UserPatch userPatch;
                HashSet membAttrs = new HashSet();
                userTO.getPlainAttrs().stream().filter(attr -> attr.getSchema().contains("#")).forEachOrdered(attr -> {
                    String[] simpleAttrs = attr.getSchema().split("#");
                    MembershipTO membership = userTO.getMemberships().stream().filter(item -> simpleAttrs[0].equals(item.getGroupName())).findFirst().orElse(null);
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership);
                    }
                    AttrTO clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership.getPlainAttrs().add(clone);
                    membAttrs.add(attr);
                });
                userTO.getPlainAttrs().removeAll(membAttrs);
                SyncopeEnduserSession.get().getDatePlainSchemas().stream().map(plainSchema -> {
                    this.millisToDate(userTO.getPlainAttrs(), (PlainSchemaTO)plainSchema);
                    return plainSchema;
                }).forEachOrdered(plainSchema -> userTO.getMemberships().forEach(membership -> this.millisToDate(membership.getPlainAttrs(), (PlainSchemaTO)plainSchema)));
                membAttrs.clear();
                userTO.getDerAttrs().stream().filter(attr -> attr.getSchema().contains("#")).forEachOrdered(attr -> {
                    String[] simpleAttrs = attr.getSchema().split("#");
                    MembershipTO membership = userTO.getMemberships().stream().filter(item -> simpleAttrs[0].equals(item.getGroupName())).findFirst().orElse(null);
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership);
                    }
                    AttrTO clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership.getDerAttrs().add(clone);
                    membAttrs.add(attr);
                });
                userTO.getDerAttrs().removeAll(membAttrs);
                membAttrs.clear();
                userTO.getVirAttrs().stream().filter(attr -> attr.getSchema().contains("#")).forEachOrdered(attr -> {
                    String[] simpleAttrs = attr.getSchema().split("#");
                    MembershipTO membership = userTO.getMemberships().stream().filter(item -> simpleAttrs[0].equals(item.getGroupName())).findFirst().orElse(null);
                    if (membership == null) {
                        membership = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership);
                    }
                    AttrTO clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership.getVirAttrs().add(clone);
                    membAttrs.add(attr);
                });
                userTO.getVirAttrs().removeAll(membAttrs);
                UserTO selfTO = SyncopeEnduserSession.get().getSelfTO();
                if (customFormAttributes != null && !customFormAttributes.isEmpty()) {
                    this.completeUserObject(userTO, selfTO);
                }
                if ((userPatch = AnyOperations.diff((UserTO)userTO, (UserTO)selfTO, (boolean)false)).isEmpty()) {
                    this.buildResponse(response, Response.Status.OK.getStatusCode(), "No need to update [" + selfTO.getUsername() + "]");
                } else {
                    Response coreResponse = SyncopeEnduserSession.get().getService(userTO.getETagValue(), UserSelfService.class).update(userPatch);
                    this.buildResponse(response, coreResponse.getStatus(), coreResponse.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL ? "User [" + selfTO.getUsername() + "] successfully updated" : "ErrorMessage{{ " + coreResponse.getStatusInfo().getReasonPhrase() + " }}");
                }
            } else {
                LOG.warn("Incoming update request [{}] is not compliant with form customization rules. Update NOT allowed", (Object)userTO.getUsername());
                this.buildResponse(response, Response.Status.OK.getStatusCode(), "User: " + userTO.getUsername() + " successfully created");
            }
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private void completeUserObject(UserTO userTO, UserTO selfTO) {
        userTO.getMemberships().forEach(updatedTOMemb -> selfTO.getMemberships().stream().filter(oldTOMemb -> updatedTOMemb.getGroupKey().equals(oldTOMemb.getGroupKey())).findFirst().ifPresent(oldTOMatchedMemb -> {
            if (!updatedTOMemb.getPlainAttrs().isEmpty()) {
                this.completeAttrs(updatedTOMemb.getPlainAttrs(), oldTOMatchedMemb.getPlainAttrs());
            }
            if (!updatedTOMemb.getVirAttrs().isEmpty()) {
                this.completeAttrs(updatedTOMemb.getVirAttrs(), oldTOMatchedMemb.getVirAttrs());
            }
        }));
        this.completeAttrs(userTO.getPlainAttrs(), selfTO.getPlainAttrs());
        this.completeAttrs(userTO.getVirAttrs(), selfTO.getVirAttrs());
    }

    private void completeAttrs(Set<AttrTO> userTOAttrs, Set<AttrTO> selfTOAttrs) {
        Map userTOAttrsMap = EntityTOUtils.buildAttrMap(userTOAttrs);
        selfTOAttrs.stream().filter(selfTOAttr -> !userTOAttrsMap.containsKey(selfTOAttr.getSchema())).forEachOrdered(selfTOAttr -> userTOAttrs.add((AttrTO)selfTOAttr));
    }
}

