/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.model.CustomAttributesInfo;
import org.apache.syncope.client.enduser.resources.BaseUserSelfResource;
import org.apache.syncope.client.enduser.util.Validation;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="userSelfUpdate", path="/api/self/update")
public class UserSelfUpdateResource
extends BaseUserSelfResource {
    private static final long serialVersionUID = -2721621682300247583L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("text/plain");
        try {
            Map<String, CustomAttributesInfo> customFormAttributes;
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            if (!this.captchaCheck(request.getHeader("captcha"), request.getSession().getAttribute("captcha"))) {
                throw new IllegalArgumentException("Entered captcha is not matching");
            }
            UserTO userTO = (UserTO)MAPPER.readValue(request.getReader().readLine(), UserTO.class);
            if (Validation.isCompliant(userTO, customFormAttributes = SyncopeEnduserApplication.get().getCustomFormAttributes(), false)) {
                UserPatch userPatch;
                String[] simpleAttrs;
                AttrTO clone;
                MembershipTO membership2;
                HashSet<AttrTO> membAttrs = new HashSet<AttrTO>();
                for (AttrTO attr : userTO.getPlainAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    final String[] compositeSchemaKey = attr.getSchema().split("#");
                    membership2 = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return compositeSchemaKey[0].equals(item.getGroupName());
                        }
                    });
                    if (membership2 == null) {
                        membership2 = new MembershipTO.Builder().group(null, (String)compositeSchemaKey[0]).build();
                        userTO.getMemberships().add(membership2);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema((String)compositeSchemaKey[1]);
                    membership2.getPlainAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getPlainAttrs().removeAll(membAttrs);
                for (PlainSchemaTO plainSchema : SyncopeEnduserSession.get().getDatePlainSchemas()) {
                    this.millisToDate(userTO.getPlainAttrs(), plainSchema);
                    for (MembershipTO membership2 : userTO.getMemberships()) {
                        this.millisToDate(membership2.getPlainAttrs(), plainSchema);
                    }
                }
                membAttrs.clear();
                for (AttrTO attr : userTO.getDerAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    simpleAttrs = attr.getSchema().split("#");
                    membership2 = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return simpleAttrs[0].equals(item.getGroupName());
                        }
                    });
                    if (membership2 == null) {
                        membership2 = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership2);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership2.getDerAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getDerAttrs().removeAll(membAttrs);
                membAttrs.clear();
                for (AttrTO attr : userTO.getVirAttrs()) {
                    if (!attr.getSchema().contains("#")) continue;
                    simpleAttrs = attr.getSchema().split("#");
                    membership2 = (MembershipTO)IterableUtils.find((Iterable)userTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                        public boolean evaluate(MembershipTO item) {
                            return simpleAttrs[0].equals(item.getGroupName());
                        }
                    });
                    if (membership2 == null) {
                        membership2 = new MembershipTO.Builder().group(null, simpleAttrs[0]).build();
                        userTO.getMemberships().add(membership2);
                    }
                    clone = (AttrTO)SerializationUtils.clone((Serializable)attr);
                    clone.setSchema(simpleAttrs[1]);
                    membership2.getVirAttrs().add(clone);
                    membAttrs.add(attr);
                }
                userTO.getVirAttrs().removeAll(membAttrs);
                UserTO selfTO = SyncopeEnduserSession.get().getSelfTO();
                if (customFormAttributes != null && !customFormAttributes.isEmpty()) {
                    this.completeUserObject(userTO, selfTO);
                }
                if ((userPatch = AnyOperations.diff((UserTO)userTO, (UserTO)selfTO, (boolean)false)).isEmpty()) {
                    this.buildResponse(response, Response.Status.OK.getStatusCode(), "No need to update [" + selfTO.getUsername() + "]");
                } else {
                    Response coreResponse = SyncopeEnduserSession.get().getService(userTO.getETagValue(), UserSelfService.class).update(userPatch);
                    this.buildResponse(response, coreResponse.getStatus(), coreResponse.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL ? "User [" + selfTO.getUsername() + "] successfully updated" : "ErrorMessage{{ " + coreResponse.getStatusInfo().getReasonPhrase() + " }}");
                }
            } else {
                LOG.warn("Incoming update request [{}] is not compliant with form customization rules. Update NOT allowed", (Object)userTO.getUsername());
                this.buildResponse(response, Response.Status.OK.getStatusCode(), "User: " + userTO.getUsername() + " successfully created");
            }
        }
        catch (Exception e) {
            LOG.error("Error while updating user", (Throwable)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }

    private void completeUserObject(UserTO userTO, UserTO selfTO) {
        for (final MembershipTO updatedTOMemb : userTO.getMemberships()) {
            MembershipTO oldTOMatchedMemb = (MembershipTO)IterableUtils.find((Iterable)selfTO.getMemberships(), (Predicate)new Predicate<MembershipTO>(){

                public boolean evaluate(MembershipTO oldTOMemb) {
                    return updatedTOMemb.getGroupKey().equals(oldTOMemb.getGroupKey());
                }
            });
            if (oldTOMatchedMemb == null) continue;
            if (!updatedTOMemb.getPlainAttrs().isEmpty()) {
                this.completeAttrs(updatedTOMemb.getPlainAttrs(), oldTOMatchedMemb.getPlainAttrs());
            }
            if (updatedTOMemb.getVirAttrs().isEmpty()) continue;
            this.completeAttrs(updatedTOMemb.getVirAttrs(), oldTOMatchedMemb.getVirAttrs());
        }
        this.completeAttrs(userTO.getPlainAttrs(), selfTO.getPlainAttrs());
        this.completeAttrs(userTO.getVirAttrs(), selfTO.getVirAttrs());
    }

    private void completeAttrs(Set<AttrTO> userTOAttrs, Set<AttrTO> selfTOAttrs) {
        Map userTOAttrsMap = EntityTOUtils.buildAttrMap(userTOAttrs);
        for (AttrTO selfTOAttr : selfTOAttrs) {
            if (userTOAttrsMap.containsKey(selfTOAttr.getSchema())) continue;
            userTOAttrs.add(selfTOAttr);
        }
    }
}

