/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class SelectableRecorder<T>
extends Recorder<T> {
    private static final long serialVersionUID = -3009044376132921879L;
    private boolean attached = false;
    private static final String[] EMPTY_IDS = new String[0];
    private String[] ids;
    private String selectedId;

    public SelectableRecorder(String id, Palette<T> palette) {
        super(id, palette);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.getForm().hasError()) {
            this.initIds();
        } else if (this.ids == null) {
            this.ids = EMPTY_IDS;
        }
        this.attached = true;
    }

    private void initIds() {
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        StringBuilder modelStringBuffer = new StringBuilder();
        Collection modelCollection = this.getPalette().getModelCollection();
        if (modelCollection == null) {
            throw new WicketRuntimeException("Expected getPalette().getModelCollection() to return a non-null value. Please make sure you have model object assigned to the palette");
        }
        Iterator selection = modelCollection.iterator();
        int i = 0;
        while (selection.hasNext()) {
            modelStringBuffer.append(renderer.getIdValue(selection.next(), i++));
            if (!selection.hasNext()) continue;
            modelStringBuffer.append(",");
        }
        String modelString = modelStringBuffer.toString();
        this.setDefaultModel((IModel)new Model((Serializable)((Object)modelString)));
        this.updateIds(modelString);
    }

    public T getSelectedItem() {
        if (this.selectedId == null) {
            return null;
        }
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        T selected = null;
        for (Object choice : this.getPalette().getChoices()) {
            if (!renderer.getIdValue(choice, 0).equals(this.selectedId)) continue;
            selected = (T)choice;
            break;
        }
        return selected;
    }

    public List<T> getSelectedList() {
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        if (this.ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList selected = new ArrayList(this.ids.length);
        block0: for (String id : this.ids) {
            for (Object choice : this.getPalette().getChoices()) {
                if (!renderer.getIdValue(choice, 0).equals(id)) continue;
                selected.add(choice);
                continue block0;
            }
        }
        return selected;
    }

    public List<T> getUnselectedList() {
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        Collection choices = this.getPalette().getChoices();
        if (choices.size() - this.ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList unselected = new ArrayList(Math.max(1, choices.size() - this.ids.length));
        for (Object choice : choices) {
            String choiceId = renderer.getIdValue(choice, 0);
            boolean selected = false;
            for (String id : this.ids) {
                if (!id.equals(choiceId)) continue;
                selected = true;
                break;
            }
            if (selected) continue;
            unselected.add(choice);
        }
        return unselected;
    }

    protected void onValid() {
        super.onValid();
        if (this.attached) {
            this.updateIds();
        }
    }

    protected void onInvalid() {
        super.onInvalid();
        if (this.attached) {
            this.updateIds();
        }
    }

    private void updateIds() {
        this.updateIds(this.getValue());
    }

    private void updateIds(String value) {
        if (Strings.isEmpty((CharSequence)value)) {
            this.ids = EMPTY_IDS;
        } else if (value.indexOf(124) == -1) {
            this.ids = value.split(",");
            this.selectedId = null;
        } else {
            String[] splitted = value.split("\\|");
            this.selectedId = splitted[0];
            this.ids = splitted[1].split(",");
        }
    }
}

