/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.io.Serializable;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.NotificationPanel;
import org.apache.syncope.client.console.rest.UserSelfRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MustChangePassword
extends WebPage {
    private static final long serialVersionUID = 5889157642852559004L;
    private static final Logger LOG = LoggerFactory.getLogger(MustChangePassword.class);
    private final StatelessForm<Void> form;
    private final TextField<String> usernameField;
    private final AjaxPasswordFieldPanel passwordField;
    private final AjaxPasswordFieldPanel confirmPasswordField;
    private final UserSelfRestClient restClient = new UserSelfRestClient();

    public MustChangePassword(PageParameters parameters) {
        super(parameters);
        final NotificationPanel notificationPanel = new NotificationPanel("feedback");
        this.add(new Component[]{notificationPanel});
        this.form = new StatelessForm("changePassword");
        this.form.setOutputMarkupId(true);
        this.usernameField = new TextField("username", (IModel)new Model((Serializable)((Object)SyncopeConsoleSession.get().getSelfTO().getUsername())));
        this.usernameField.setMarkupId("username");
        this.usernameField.setEnabled(false);
        this.form.add(new Component[]{this.usernameField});
        this.passwordField = new AjaxPasswordFieldPanel("password", "password", (IModel<String>)new Model());
        this.passwordField.setRequired(true);
        this.passwordField.setMarkupId("password");
        this.passwordField.setPlaceholder("password");
        ((PasswordTextField)this.passwordField.getField()).setResetPassword(true);
        this.form.add(new Component[]{this.passwordField});
        this.confirmPasswordField = new AjaxPasswordFieldPanel("confirmPassword", "confirmPassword", (IModel<String>)new Model());
        this.confirmPasswordField.setRequired(true);
        this.confirmPasswordField.setMarkupId("confirmPassword");
        this.confirmPasswordField.setPlaceholder("confirmPassword");
        ((PasswordTextField)this.confirmPasswordField.getField()).setResetPassword(true);
        this.form.add(new Component[]{this.confirmPasswordField});
        this.form.add((IFormValidator)new EqualPasswordInputValidator(this.passwordField.getField(), this.confirmPasswordField.getField()));
        AjaxButton submitButton = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = 429178684321093953L;

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    MustChangePassword.this.restClient.changePassword((String)MustChangePassword.this.passwordField.getModelObject());
                    SyncopeConsoleSession.get().invalidate();
                    this.setResponsePage(this.getApplication().getHomePage());
                }
                catch (Exception e) {
                    LOG.error("While changing password for {}", (Object)SyncopeConsoleSession.get().getSelfTO().getUsername(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                    notificationPanel.refresh((IPartialPageRequestHandler)target);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                notificationPanel.refresh((IPartialPageRequestHandler)target);
            }
        };
        this.form.add(new Component[]{submitButton});
        this.form.setDefaultButton((IFormSubmittingComponent)submitButton);
        this.add(new Component[]{this.form});
    }
}

