/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import jakarta.ws.rs.NotAuthorizedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.pages.SelfPasswordReset;
import org.apache.syncope.client.enduser.pages.SelfRegistration;
import org.apache.syncope.client.ui.commons.BaseLogin;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class Login
extends BaseLogin {
    private static final long serialVersionUID = 5889157642852559004L;
    private final BookmarkablePageLink<Void> selfPwdReset = new BookmarkablePageLink("self-pwd-reset", SelfPasswordReset.class);
    private final BookmarkablePageLink<Void> selfRegistration;

    public Login(PageParameters parameters) {
        super(parameters);
        this.selfPwdReset.getPageParameters().add("domain", (Object)SyncopeEnduserSession.get().getDomain());
        this.selfPwdReset.setVisible(SyncopeEnduserSession.get().getPlatformInfo().isPwdResetAllowed());
        this.add(new Component[]{this.selfPwdReset.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
        this.selfRegistration = new BookmarkablePageLink("self-registration", SelfRegistration.class);
        this.selfRegistration.getPageParameters().add("domain", (Object)SyncopeEnduserSession.get().getDomain());
        this.selfRegistration.setVisible(SyncopeEnduserSession.get().getPlatformInfo().isSelfRegAllowed());
        this.add(new Component[]{this.selfRegistration.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
    }

    protected Collection<Component> getLanguageOnChangeComponents() {
        return Stream.concat(super.getLanguageOnChangeComponents().stream(), Stream.of(this.selfRegistration, this.selfPwdReset)).collect(Collectors.toList());
    }

    protected BaseSession getBaseSession() {
        return SyncopeEnduserSession.get();
    }

    protected List<Panel> getSSOLoginFormPanels() {
        ArrayList<Panel> ssoLoginFormPanels = new ArrayList<Panel>();
        SyncopeWebApplication.get().getLookup().getSSOLoginFormPanels().forEach(ssoLoginFormPanel -> {
            try {
                ssoLoginFormPanels.add((Panel)ssoLoginFormPanel.getConstructor(String.class, BaseSession.class).newInstance(new Object[]{"ssoLogin", SyncopeEnduserSession.get()}));
            }
            catch (Exception e) {
                LOG.error("Could not initialize the provided SSO login form panel", (Throwable)e);
            }
        });
        return ssoLoginFormPanels;
    }

    protected void sendError(String error) {
        SyncopeEnduserSession.get().error((Serializable)((Object)error));
    }

    protected void authenticate(String username, String password, AjaxRequestTarget target) throws NotAuthorizedException {
        if (SyncopeWebApplication.get().getAnonymousUser().equals(username) || SyncopeWebApplication.get().getAdminUser().equals(username)) {
            throw new NotAuthorizedException((Object)"Illegal username", new Object[0]);
        }
        if (SyncopeEnduserSession.get().authenticate(username, password)) {
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        } else {
            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("login-error")));
            this.notificationPanel.refresh((IPartialPageRequestHandler)target);
        }
    }
}

