/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.enduser.pages.Logout;
import org.apache.syncope.client.enduser.panels.Sidebar;
import org.apache.syncope.client.enduser.wicket.markup.head.MetaHeaderItem;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class BasePage
extends BaseWebPage {
    private static final long serialVersionUID = 1571997737305598502L;
    protected static final HeaderItem META_IE_EDGE = new MetaHeaderItem("X-UA-Compatible", "IE=edge");
    @SpringBean
    private ClassPathScanImplementationLookup lookup;
    protected final Sidebar sidebar;
    protected final WebMarkupContainer contentWrapper;
    protected final WebMarkupContainer navbar;
    protected final AjaxLink<Void> collapse;

    public BasePage() {
        this(null, null);
    }

    public BasePage(PageParameters parameters, String name) {
        super(parameters);
        Boolean b;
        Serializable leftMenuCollapse = SyncopeEnduserSession.get().getAttribute("MENU_COLLAPSE");
        if (leftMenuCollapse instanceof Boolean && (b = (Boolean)leftMenuCollapse).booleanValue()) {
            this.body.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" sidebar-collapse"))});
        }
        Class<? extends Sidebar> clazz = SyncopeWebApplication.get().getSidebar();
        try {
            this.sidebar = clazz.getConstructor(String.class, PageReference.class, List.class).newInstance("sidebar", this.getPageReference(), this.lookup.getExtPageClasses());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not instantiate " + clazz.getName(), e);
        }
        this.sidebar.setOutputMarkupPlaceholderTag(true);
        this.body.add(new Component[]{this.sidebar});
        this.contentWrapper = new WebMarkupContainer("contentWrapper");
        this.contentWrapper.setOutputMarkupPlaceholderTag(true);
        this.body.add(new Component[]{this.contentWrapper});
        this.navbar = new WebMarkupContainer("navbar");
        this.navbar.setOutputMarkupPlaceholderTag(true);
        this.navbar.setOutputMarkupId(true);
        this.body.add(new Component[]{this.navbar});
        this.addPageTitle(name);
        this.collapse = new AjaxLink<Void>("collapse"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Session.get().setAttribute("MENU_COLLAPSE", (Serializable)Boolean.valueOf(Session.get().getAttribute("MENU_COLLAPSE") == null ? true : (Boolean)Session.get().getAttribute("MENU_COLLAPSE") == false));
            }
        };
        this.collapse.setOutputMarkupPlaceholderTag(true);
        this.navbar.add(new Component[]{this.collapse});
        final Class beforeLogout = (Class)Session.get().getAttribute("beforeLogoutPage");
        if (beforeLogout == null) {
            this.navbar.add(new Component[]{new BookmarkablePageLink("logout", Logout.class)});
        } else {
            this.navbar.add(new Component[]{new AjaxLink<Page>("logout"){
                private static final long serialVersionUID = -7978723352517770644L;

                protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                    super.updateAjaxAttributes(attributes);
                    AjaxCallListener ajaxCallListener = new AjaxCallListener();
                    ajaxCallListener.onPrecondition((CharSequence)("return confirm('" + this.getString("confirmGlobalLogout") + "');"));
                    attributes.getAjaxCallListeners().add(ajaxCallListener);
                }

                public void onClick(AjaxRequestTarget target) {
                    this.setResponsePage(beforeLogout);
                }
            }});
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem(META_IE_EDGE));
    }

    protected void addPageTitle(String title) {
        this.contentWrapper.addOrReplace(new Component[]{new Label("pageTitle", (IModel)new ResourceModel(title, title))});
    }

    protected void disableSidebarAndNavbar() {
        this.sidebar.setVisible(false);
        this.collapse.setVisible(false);
        this.navbar.setVisible(false);
        this.contentWrapper.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"margin-left: 0px"))});
    }

    protected void setDomain(PageParameters parameters) {
        if (parameters != null && !parameters.get("domain").isEmpty()) {
            ((BaseSession)BaseSession.class.cast(Session.get())).setDomain(parameters.get("domain").toString());
        }
    }
}

