/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import org.apache.syncope.client.console.ConsoleProperties;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.AccessPolicyConfProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionLinksProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionsProvider;
import org.apache.syncope.client.console.commons.AnyWizardBuilderAdditionalSteps;
import org.apache.syncope.client.console.commons.ExternalResourceProvider;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.commons.PolicyTabProvider;
import org.apache.syncope.client.console.commons.StatusProvider;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.wizards.any.UserFormFinalizer;
import org.apache.syncope.client.ui.commons.DynamicMenuStringResourceLoader;
import org.apache.syncope.client.ui.commons.actuate.SyncopeCoreHealthIndicator;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStart;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.apache.wicket.request.resource.IResource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ConsoleProperties.class})
@EnableCaching
public class SyncopeConsoleApplication
extends SpringBootServletInitializer {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{SyncopeConsoleApplication.class}).properties(new String[]{"spring.config.name:console"}).build().run(args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.properties(Map.of("wicket.external.websocket.registerServerEndpoint.enabled", false, "spring.config.name", "console")).sources(new Class[]{SyncopeConsoleApplication.class});
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeWebApplication syncopeWebApplication(ConsoleProperties props, ClassPathScanImplementationLookup lookup, ServiceOps serviceOps, ExternalResourceProvider resourceProvider, AnyDirectoryPanelAdditionalActionsProvider anyDirectoryPanelAdditionalActionsProvider, AnyDirectoryPanelAdditionalActionLinksProvider anyDirectoryPanelAdditionalActionLinksProvider, AnyWizardBuilderAdditionalSteps anyWizardBuilderAdditionalSteps, StatusProvider statusProvider, ImplementationInfoProvider implementationInfoProvider, AccessPolicyConfProvider accessPolicyConfProvider, List<PolicyTabProvider> policyTabProviders, List<UserFormFinalizer> userFormFinalizers, List<IResource> resources, @Qualifier(value="loggedoutSessionIdCache") Cache<String, OffsetDateTime> loggedoutSessionIdCache, @Qualifier(value="destroyedSessionIdCache") Cache<String, OffsetDateTime> destroyedSessionIdCache, DynamicMenuStringResourceLoader dynamicMenuStringResourceLoader) {
        return new SyncopeWebApplication(props, lookup, serviceOps, resourceProvider, anyDirectoryPanelAdditionalActionsProvider, anyDirectoryPanelAdditionalActionLinksProvider, anyWizardBuilderAdditionalSteps, statusProvider, implementationInfoProvider, accessPolicyConfProvider, policyTabProviders, userFormFinalizers, resources, loggedoutSessionIdCache, destroyedSessionIdCache, dynamicMenuStringResourceLoader);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreHealthIndicator syncopeCoreHealthIndicator(ServiceOps serviceOps, ConsoleProperties props) {
        return new SyncopeCoreHealthIndicator(serviceOps, props.getAnonymousUser(), props.getAnonymousKey(), props.isUseGZIPCompression());
    }

    @ConditionalOnProperty(prefix="keymaster", name={"enableAutoRegistration"}, havingValue="true", matchIfMissing=true)
    @Bean
    public KeymasterStart keymasterStart() {
        return new KeymasterStart(NetworkService.Type.CONSOLE);
    }

    @ConditionalOnProperty(prefix="keymaster", name={"enableAutoRegistration"}, havingValue="true", matchIfMissing=true)
    @Bean
    public KeymasterStop keymasterStop() {
        return new KeymasterStop(NetworkService.Type.CONSOLE);
    }
}

