/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.UUID;
import org.apache.syncope.client.console.panels.ConfParam;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.panels.ToggleableTarget;
import org.apache.syncope.client.console.policies.PolicyRuleWrapper;
import org.apache.syncope.client.console.tasks.CommandWrapper;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.any.AnyObjectWrapper;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.wizards.any.EntityWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.command.CommandTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.NamedEntityTO;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.ResourceModel;

public class ActionLinksTogglePanel<T extends Serializable>
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -2025535531121434056L;
    private final WebMarkupContainer container;

    public ActionLinksTogglePanel(String id, PageReference pageRef) {
        super(id, UUID.randomUUID().toString(), pageRef);
        this.modal.size(Modal.Size.Large);
        this.setFooterVisibility(false);
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupPlaceholderTag(true);
        this.addInnerObject(new Component[]{this.container});
        this.container.add(new Component[]{this.getEmptyFragment()});
    }

    public void updateHeader(AjaxRequestTarget target, Serializable modelObject) {
        String header;
        if (modelObject instanceof UserTO) {
            UserTO userTO = (UserTO)modelObject;
            header = userTO.getUsername();
        } else if (modelObject instanceof UserWrapper) {
            UserWrapper userWrapper = (UserWrapper)modelObject;
            header = ((UserTO)userWrapper.getInnerObject()).getUsername();
        } else if (modelObject instanceof GroupTO) {
            GroupTO groupTO = (GroupTO)modelObject;
            header = groupTO.getName();
        } else if (modelObject instanceof GroupWrapper) {
            GroupWrapper groupWrapper = (GroupWrapper)((Object)modelObject);
            header = ((GroupTO)groupWrapper.getInnerObject()).getName();
        } else if (modelObject instanceof AnyObjectTO) {
            AnyObjectTO anyObjectTO = (AnyObjectTO)modelObject;
            header = anyObjectTO.getName();
        } else if (modelObject instanceof AnyObjectWrapper) {
            AnyObjectWrapper anyObjectWrapper = (AnyObjectWrapper)((Object)modelObject);
            header = ((AnyObjectTO)anyObjectWrapper.getInnerObject()).getName();
        } else if (modelObject instanceof Attr) {
            Attr attr = (Attr)modelObject;
            header = attr.getSchema();
        } else if (modelObject instanceof ConfParam) {
            ConfParam confParam = (ConfParam)modelObject;
            header = confParam.getSchema();
        } else if (modelObject instanceof PolicyTO) {
            PolicyTO policyTO = (PolicyTO)modelObject;
            header = policyTO.getName();
        } else if (modelObject instanceof SecurityQuestionTO) {
            SecurityQuestionTO securityQuestionTO = (SecurityQuestionTO)modelObject;
            header = securityQuestionTO.getContent();
        } else if (modelObject instanceof AccessTokenTO) {
            AccessTokenTO accessTokenTO = (AccessTokenTO)modelObject;
            header = accessTokenTO.getOwner();
        } else if (modelObject instanceof ExecTO) {
            ExecTO execTO = (ExecTO)modelObject;
            header = execTO.getKey();
        } else if (modelObject instanceof StatusBean) {
            StatusBean statusBean = (StatusBean)modelObject;
            header = statusBean.getResource();
        } else if (modelObject instanceof PolicyRuleWrapper) {
            PolicyRuleWrapper policyRuleWrapper = (PolicyRuleWrapper)modelObject;
            header = policyRuleWrapper.getImplementationKey();
        } else if (modelObject instanceof CommandWrapper) {
            CommandWrapper commandWrapper = (CommandWrapper)modelObject;
            header = commandWrapper.getCommand().getKey();
        } else if (modelObject instanceof JobTO) {
            JobTO jobTO = (JobTO)modelObject;
            header = jobTO.getRefKey() == null ? jobTO.getRefDesc() : jobTO.getRefKey();
        } else if (modelObject instanceof ToggleableTarget) {
            ToggleableTarget toggleableTarget = (ToggleableTarget)modelObject;
            header = toggleableTarget.getAnyType();
        } else if (modelObject instanceof Domain) {
            Domain domain = (Domain)modelObject;
            header = domain.getKey();
        } else if (modelObject instanceof CommandTO) {
            CommandTO commandTO = (CommandTO)modelObject;
            header = commandTO.getKey();
        } else if (modelObject instanceof NamedEntityTO) {
            NamedEntityTO entity = (NamedEntityTO)modelObject;
            header = entity.getName();
        } else if (modelObject instanceof EntityTO) {
            EntityTO entityTO = (EntityTO)modelObject;
            header = entityTO.getKey();
        } else if (modelObject instanceof EntityWrapper) {
            String string;
            EntityWrapper entityWrapper = (EntityWrapper)modelObject;
            EntityTO inner = entityWrapper.getInnerObject();
            if (inner instanceof NamedEntityTO) {
                NamedEntityTO namedEntityTO = (NamedEntityTO)inner;
                string = namedEntityTO.getName();
            } else {
                string = inner.getKey();
            }
            header = string;
        } else {
            header = new ResourceModel("actions", "").getObject();
        }
        this.setHeader(target, header);
    }

    public void toggleWithContent(AjaxRequestTarget target, ActionsPanel<T> actionsPanel, T modelObject) {
        this.updateHeader(target, (Serializable)modelObject);
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)t -> this.modal.show(false));
        Fragment frag = new Fragment("actions", "actionsFragment", (MarkupContainer)this);
        frag.setOutputMarkupId(true);
        frag.add(new Component[]{actionsPanel});
        this.container.addOrReplace(new Component[]{frag});
        target.add(new Component[]{this.container});
        this.toggle(target, (Serializable)modelObject, true);
    }

    private Fragment getEmptyFragment() {
        return new Fragment("actions", "emptyFragment", (MarkupContainer)this);
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ActionLinkToggleCloseEventPayload) {
            this.close(((ActionLinkToggleCloseEventPayload)ActionLinkToggleCloseEventPayload.class.cast(event.getPayload())).getTarget());
        }
    }

    public static class ActionLinkToggleCloseEventPayload {
        private final AjaxRequestTarget target;

        public ActionLinkToggleCloseEventPayload(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

