/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public class DatePropertyColumn<T>
extends PropertyColumn<T, String> {
    private static final long serialVersionUID = 3527840552172947705L;

    public DatePropertyColumn(IModel<String> displayModel, String sortProperty, String propertyExpression) {
        super(displayModel, (Object)sortProperty, propertyExpression);
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        IModel date = this.getDataModel(rowModel);
        String convertedDate = "";
        Object object = date.getObject();
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            convertedDate = SyncopeConsoleSession.get().getDateFormat().format(offsetDateTime);
        } else {
            object = date.getObject();
            if (object instanceof ZonedDateTime) {
                ZonedDateTime zonedDateTime = (ZonedDateTime)object;
                convertedDate = SyncopeConsoleSession.get().getDateFormat().format(zonedDateTime);
            } else {
                object = date.getObject();
                if (object instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)object;
                    convertedDate = SyncopeConsoleSession.get().getDateFormat().format(localDateTime);
                } else {
                    object = date.getObject();
                    if (object instanceof Date) {
                        Date date1 = (Date)object;
                        convertedDate = SyncopeConsoleSession.get().getDateFormat().format(date1);
                    }
                }
            }
        }
        item.add(new Component[]{new Label(componentId, (Serializable)((Object)convertedDate))});
    }
}

