/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.layout;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.ui.commons.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.ui.commons.wizards.any.AnyForm;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.PageReference;

public final class AnyLayoutUtils {
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();

    private static void setUserIfEmpty(AnyLayout anyLayout) {
        if (anyLayout.getUser() == null) {
            anyLayout.setUser(new UserFormLayoutInfo());
        }
    }

    private static void setGroupIfEmpty(AnyLayout anyLayout) {
        if (anyLayout.getGroup() == null) {
            anyLayout.setGroup(new GroupFormLayoutInfo());
        }
    }

    private static void setAnyObjectsIfEmpty(AnyLayout anyLayout, List<String> anyTypes) {
        if (anyLayout.getAnyObjects().isEmpty()) {
            anyLayout.getAnyObjects().putAll(anyTypes.stream().filter(anyType -> !anyType.equals(AnyTypeKind.USER.name()) && !anyType.equals(AnyTypeKind.GROUP.name())).collect(Collectors.toMap(Function.identity(), anyType -> new AnyObjectFormLayoutInfo())));
        }
    }

    private static AnyLayout empty(List<String> anyTypes) {
        AnyLayout anyLayout = new AnyLayout();
        AnyLayoutUtils.setUserIfEmpty(anyLayout);
        AnyLayoutUtils.setGroupIfEmpty(anyLayout);
        AnyLayoutUtils.setAnyObjectsIfEmpty(anyLayout, anyTypes);
        return anyLayout;
    }

    public static AnyLayout fetch(RoleRestClient roleRestClient, List<String> anyTypes) {
        List ownedRoles = Stream.concat(SyncopeConsoleSession.get().getSelfTO().getRoles().stream(), SyncopeConsoleSession.get().getSelfTO().getDynRoles().stream()).distinct().toList();
        try {
            AnyLayout anyLayout = null;
            for (int i = 0; i < ownedRoles.size() && anyLayout == null; ++i) {
                String anyLayoutJSON = roleRestClient.readAnyLayout((String)ownedRoles.get(i));
                if (!StringUtils.isNotBlank((CharSequence)anyLayoutJSON)) continue;
                anyLayout = (AnyLayout)MAPPER.readValue(anyLayoutJSON, AnyLayout.class);
            }
            if (anyLayout == null) {
                anyLayout = AnyLayoutUtils.empty(anyTypes);
            }
            AnyLayoutUtils.setUserIfEmpty(anyLayout);
            AnyLayoutUtils.setGroupIfEmpty(anyLayout);
            AnyLayoutUtils.setAnyObjectsIfEmpty(anyLayout, anyTypes);
            return anyLayout;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("While parsing console layout for " + SyncopeConsoleSession.get().getSelfTO().getUsername(), e);
        }
    }

    public static String defaultIfEmpty(String content, List<String> anyTypes) {
        String result;
        if (StringUtils.isBlank((CharSequence)content)) {
            AnyLayout anyLayout = AnyLayoutUtils.empty(anyTypes);
            try {
                result = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)anyLayout);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("While generating default console layout for " + SyncopeConsoleSession.get().getSelfTO().getUsername(), e);
            }
        }
        try {
            result = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)MAPPER.readTree(content));
        }
        catch (IOException e) {
            result = content;
        }
        return result;
    }

    public static <A extends AnyTO, F extends AnyForm<A>, FL extends AbstractAnyFormLayout<A, F>> F newLayoutInfo(A anyTO, List<String> anyTypeClasses, FL anyFormLayout, AbstractAnyRestClient<?> anyRestClient, PageReference pageRef) {
        try {
            if (anyTO instanceof UserTO) {
                return (F)((AnyForm)anyFormLayout.getFormClass().getConstructor(anyTO.getClass(), anyTO.getClass(), List.class, anyFormLayout.getClass(), UserRestClient.class, pageRef.getClass()).newInstance(null, anyTO, anyTypeClasses, anyFormLayout, anyRestClient, pageRef));
            }
            if (anyTO instanceof GroupTO) {
                return (F)((AnyForm)anyFormLayout.getFormClass().getConstructor(anyTO.getClass(), List.class, anyFormLayout.getClass(), GroupRestClient.class, pageRef.getClass()).newInstance(anyTO, anyTypeClasses, anyFormLayout, anyRestClient, pageRef));
            }
            return (F)((AnyForm)anyFormLayout.getFormClass().getConstructor(anyTO.getClass(), List.class, anyFormLayout.getClass(), AnyObjectRestClient.class, pageRef.getClass()).newInstance(anyTO, anyTypeClasses, anyFormLayout, anyRestClient, pageRef));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not instantiate " + anyFormLayout.getFormClass().getName(), e);
        }
    }

    private AnyLayoutUtils() {
    }
}

