/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.KeywordSearchEvent;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.SchemaTypeWizardBuilder;
import org.apache.syncope.client.console.panels.TypesDirectoryPanel;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.springframework.util.ReflectionUtils;

public class SchemaTypePanel
extends TypesDirectoryPanel<SchemaTO, SchemaProvider, SchemaRestClient> {
    private static final long serialVersionUID = 3905038169553185171L;
    protected static final Map<SchemaType, List<String>> COL_NAMES = Map.of(SchemaType.PLAIN, List.of("key", "type", "mandatoryCondition", "uniqueConstraint", "multivalue", "readonly"), SchemaType.DERIVED, List.of("key", "expression"));
    protected final SchemaType schemaType;
    protected String keyword;

    public SchemaTypePanel(String id, SchemaRestClient restClient, SchemaType schemaType, PageReference pageRef) {
        super(id, restClient, true, pageRef);
        this.schemaType = schemaType;
        this.disableCheckBoxes();
        try {
            this.addNewItemPanelBuilder(new SchemaTypeWizardBuilder((SchemaTO)schemaType.getToClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), restClient, pageRef), true);
        }
        catch (Exception e) {
            LOG.error("Error creating instance of {}", (Object)schemaType, (Object)e);
        }
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"SCHEMA_CREATE");
    }

    @Override
    protected void setWindowClosedReloadCallback(BaseModal<?> modal) {
        modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            target.add(new Component[]{this});
            modal.show(false);
        });
    }

    @Override
    protected SchemaProvider dataProvider() {
        return new SchemaProvider(this.rows, this.schemaType);
    }

    @Override
    protected String paginatorRowsKey() {
        return "anytype.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected List<IColumn<SchemaTO, String>> getColumns() {
        ArrayList<IColumn<SchemaTO, String>> columns = new ArrayList<IColumn<SchemaTO, String>>();
        for (final String field : COL_NAMES.get(this.schemaType)) {
            Field clazzField = ReflectionUtils.findField((Class)this.schemaType.getToClass(), (String)field);
            if (clazzField == null || clazzField.isSynthetic()) continue;
            if (clazzField.getType().equals(Boolean.class) || clazzField.getType().equals(Boolean.TYPE)) {
                columns.add((IColumn<SchemaTO, String>)new BooleanPropertyColumn((IModel<String>)new ResourceModel(field), field, field));
                continue;
            }
            PropertyColumn<SchemaTO, String> column = new PropertyColumn<SchemaTO, String>((IModel)new ResourceModel(field), field, field){
                private static final long serialVersionUID = 3282547854226892169L;

                public String getCssClass() {
                    Object css = super.getCssClass();
                    if ("key".equals(field)) {
                        css = StringUtils.isBlank((CharSequence)css) ? "col-xs-1" : (String)css + " col-xs-1";
                    }
                    return css;
                }
            };
            columns.add((IColumn<SchemaTO, String>)column);
        }
        return columns;
    }

    @Override
    public ActionsPanel<SchemaTO> getActions(final IModel<SchemaTO> model) {
        ActionsPanel<SchemaTO> panel = super.getActions(model);
        panel.add(new ActionLink<SchemaTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, SchemaTO ignore) {
                SchemaTypePanel.this.send((IEventSink)SchemaTypePanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent(((SchemaRestClient)SchemaTypePanel.this.restClient).read(SchemaTypePanel.this.schemaType, ((SchemaTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "SCHEMA_UPDATE");
        panel.add(new ActionLink<SchemaTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, SchemaTO ignore) {
                try {
                    ((SchemaRestClient)SchemaTypePanel.this.restClient).delete(SchemaTypePanel.this.schemaType, ((SchemaTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)SchemaTypePanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{SchemaTypePanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", model.getObject(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)SchemaTypePanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "SCHEMA_DELETE", true);
        return panel;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof KeywordSearchEvent) {
            KeywordSearchEvent payload = (KeywordSearchEvent)KeywordSearchEvent.class.cast(event.getPayload());
            this.keyword = payload.getKeyword();
            if (StringUtils.isNotBlank((CharSequence)this.keyword)) {
                if (!StringUtils.startsWith((CharSequence)this.keyword, (CharSequence)"*")) {
                    this.keyword = "*" + this.keyword;
                }
                if (!StringUtils.endsWith((CharSequence)this.keyword, (CharSequence)"*")) {
                    this.keyword = this.keyword + "*";
                }
            }
            this.updateResultTable(payload.getTarget());
        } else {
            super.onEvent(event);
        }
    }

    protected final class SchemaProvider
    extends DirectoryDataProvider<SchemaTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final SortableDataProviderComparator<SchemaTO> comparator;
        private final SchemaType schemaType;

        private SchemaProvider(int paginatorRows, SchemaType schemaType) {
            super(paginatorRows);
            this.schemaType = schemaType;
            this.comparator = new SortableDataProviderComparator<SchemaTO>(this);
        }

        public Iterator<SchemaTO> iterator(long first, long count) {
            List schemas = ((SchemaRestClient)SchemaTypePanel.this.restClient).getSchemas(this.schemaType, SchemaTypePanel.this.keyword, new String[0]);
            schemas.sort(this.comparator);
            return schemas.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((SchemaRestClient)SchemaTypePanel.this.restClient).getSchemas(this.schemaType, SchemaTypePanel.this.keyword, new String[0]).size();
        }

        public IModel<SchemaTO> model(SchemaTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

