/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Base64;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.ConfParam;
import org.apache.syncope.client.console.panels.ParametersWizardPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.bouncycastle.util.io.pem.PemReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParametersModalPanel
extends AbstractModalPanel<ConfParam> {
    private static final long serialVersionUID = 4024126489500665435L;
    private static final JsonMapper JSON_MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private static final SAXParserFactory SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private final ParametersWizardPanel.ParametersForm form;

    private static boolean isDate(String value) {
        try {
            DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse(value);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private static boolean isBase64(String value) {
        try {
            Base64.getDecoder().decode(value);
            return value.length() % 4 == 0;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private static boolean isJSON(String value) {
        try {
            JSON_MAPPER.readTree(value);
            return true;
        }
        catch (JsonProcessingException jpe) {
            return false;
        }
    }

    private static boolean isXML(String value) {
        try {
            SAX_PARSER_FACTORY.newSAXParser().getXMLReader().parse(new InputSource(new StringReader(value)));
            return true;
        }
        catch (IOException | ParserConfigurationException | SAXException xmle) {
            return false;
        }
    }

    private static boolean isPEM(String value) {
        boolean bl;
        PemReader reader = new PemReader((Reader)new StringReader(value));
        try {
            bl = reader.readPemObject() != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public ParametersModalPanel(BaseModal<ConfParam> modal, ConfParam param, ConfParamOps confParamOps, AjaxWizard.Mode mode, PageReference pageRef) {
        super(modal, pageRef);
        PlainSchemaTO schema = new PlainSchemaTO();
        schema.setMultivalue(param.isMultivalue());
        schema.setMimeType("application/octet-stream");
        if (param.getSchema() != null) {
            if (param.isInstance(Boolean.class)) {
                schema.setType(AttrSchemaType.Boolean);
            } else if (param.isInstance(Integer.class) || param.isInstance(Long.class)) {
                schema.setType(AttrSchemaType.Long);
            } else if (param.isInstance(Float.class) || param.isInstance(Double.class)) {
                schema.setType(AttrSchemaType.Double);
            } else if (!param.getValues().isEmpty()) {
                if (ParametersModalPanel.isDate(param.getValues().getFirst().toString())) {
                    schema.setType(AttrSchemaType.Date);
                } else if (ParametersModalPanel.isBase64(param.getValues().getFirst().toString())) {
                    schema.setType(AttrSchemaType.Binary);
                    String value = new String(Base64.getDecoder().decode(param.getValues().getFirst().toString()));
                    if (ParametersModalPanel.isJSON(value)) {
                        schema.setMimeType("application/json");
                    } else if (ParametersModalPanel.isXML(value)) {
                        schema.setMimeType("application/xml");
                    } else if (ParametersModalPanel.isPEM(value)) {
                        schema.setMimeType("application/x-pem-file");
                    }
                } else {
                    schema.setType(AttrSchemaType.String);
                }
            }
        }
        if (schema.getType() == AttrSchemaType.Binary) {
            modal.size(Modal.Size.Extra_large);
        } else {
            modal.size(Modal.Size.Default);
        }
        this.form = new ParametersWizardPanel.ParametersForm(schema, param);
        this.add(new Component[]{new ParametersWizardPanel(this.form, confParamOps, pageRef).build("parametersCreateWizardPanel", mode)});
    }

    @Override
    public final ConfParam getItem() {
        return this.form.getParam();
    }
}

