/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggle;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggleConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.commons.LinkedAccountPlainAttrProperty;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.EntityWrapper;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class LinkedAccountPlainAttrsPanel
extends AbstractAttrsWizardStep<PlainSchemaTO> {
    private static final long serialVersionUID = -6664931684253730934L;
    protected final LinkedAccountTO linkedAccountTO;
    protected final UserTO userTO;
    protected final Set<Attr> fixedAttrs = new HashSet<Attr>();
    protected final List<LinkedAccountPlainAttrProperty> accountPlainAttrProperties = new ArrayList<LinkedAccountPlainAttrProperty>();

    public <T extends AnyTO> LinkedAccountPlainAttrsPanel(EntityWrapper<LinkedAccountTO> modelObject, UserTO userTO, List<String> anyTypeClasses, List<String> whichPlainAttrs) throws IllegalArgumentException {
        super((AttributableTO)userTO, AjaxWizard.Mode.EDIT, anyTypeClasses, whichPlainAttrs);
        this.linkedAccountTO = (LinkedAccountTO)modelObject.getInnerObject();
        this.fixedAttrs.addAll(this.linkedAccountTO.getPlainAttrs().stream().filter(attrTO -> this.checkIsReadonlyAttr(attrTO.getSchema())).toList());
        this.userTO = userTO;
        this.add(new Component[]{new Accordion("plainSchemas", List.of(new AbstractTab((IModel)new ResourceModel("attributes.accordion", "Plain Attributes")){
            private static final long serialVersionUID = -7078941093668723016L;

            public WebMarkupContainer getPanel(String panelId) {
                return new PlainSchemasOwn(panelId, LinkedAccountPlainAttrsPanel.this.schemas, (IModel<List<Attr>>)LinkedAccountPlainAttrsPanel.this.attrs);
            }
        }), (IModel)Model.of((Serializable)Integer.valueOf(0))).setOutputMarkupId(true)});
    }

    protected FormComponent<?> checkboxToggle(Attr attrTO, final AbstractFieldPanel<?> panel, final boolean isMultivalue) {
        final LinkedAccountPlainAttrProperty property = this.accountPlainAttrProperties.stream().filter(existingProperty -> existingProperty.getSchema().equals(attrTO.getSchema())).findFirst().orElseGet(() -> {
            LinkedAccountPlainAttrProperty newProperty = new LinkedAccountPlainAttrProperty();
            newProperty.setOverridable(this.linkedAccountTO.getPlainAttr(attrTO.getSchema()).isPresent());
            newProperty.setSchema(attrTO.getSchema());
            newProperty.getValues().addAll(attrTO.getValues());
            this.accountPlainAttrProperties.add(newProperty);
            return newProperty;
        });
        BootstrapToggleConfig config = new BootstrapToggleConfig().withOnStyle(BootstrapToggleConfig.Style.success).withOffStyle(BootstrapToggleConfig.Style.danger).withSize(BootstrapToggleConfig.Size.mini);
        return new BootstrapToggle("externalAction", (IModel)new PropertyModel((Object)property, "overridable"), config){
            private static final long serialVersionUID = -875219845189261873L;

            protected CheckBox newCheckBox(String id, final IModel<Boolean> model) {
                CheckBox checkBox = super.newCheckBox(id, model);
                checkBox.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        if (isMultivalue) {
                            ((MultiFieldPanel)MultiFieldPanel.class.cast(panel)).setFormReadOnly((Boolean)model.getObject() == false);
                        } else {
                            ((FieldPanel)FieldPanel.class.cast(panel)).setReadOnly((Boolean)model.getObject() == false);
                        }
                        LinkedAccountPlainAttrsPanel.this.updateAccountPlainSchemas(property, (Boolean)model.getObject());
                        target.add(new Component[]{panel});
                    }
                }});
                return checkBox;
            }

            protected IModel<String> getOnLabel() {
                return Model.of((Serializable)((Object)"Override"));
            }

            protected IModel<String> getOffLabel() {
                return Model.of((Serializable)((Object)"Override?"));
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("class", (CharSequence)"overridable", " ");
            }
        };
    }

    private void updateAccountPlainSchemas(LinkedAccountPlainAttrProperty property, Boolean modelObject) {
        HashSet withoutCurrentSchema = new HashSet(this.linkedAccountTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getSchema().equals(property.getSchema()) && this.checkIsReadonlyAttr(attrTO.getSchema())).collect(Collectors.toSet()));
        this.linkedAccountTO.getPlainAttrs().clear();
        this.linkedAccountTO.getPlainAttrs().addAll(withoutCurrentSchema);
        if (modelObject.booleanValue()) {
            this.linkedAccountTO.getPlainAttrs().add(this.fixedAttrs.stream().filter(attrTO -> attrTO.getSchema().equals(property.getSchema())).findFirst().orElseGet(() -> new Attr.Builder(property.getSchema()).values((Collection)property.getValues()).build()));
        }
    }

    protected SchemaType getSchemaType() {
        return SchemaType.PLAIN;
    }

    protected void setAttrs() {
        ArrayList<Attr> attrs = new ArrayList<Attr>();
        List<PlainSchemaTO> notReadonlyValues = this.schemas.values().stream().filter(schema -> this.checkIsReadonlyAttr(schema.getKey())).collect(Collectors.toList());
        this.setFixedAttr(notReadonlyValues);
        Map attrMap = EntityTOUtils.buildAttrMap(this.fixedAttrs);
        attrs.addAll(notReadonlyValues.stream().map(schema -> {
            Attr attrTO = new Attr();
            attrTO.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((Attr)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attrTO.getValues().add("");
            } else {
                attrTO = (Attr)attrMap.get(schema.getKey());
            }
            return attrTO;
        }).toList());
        this.fixedAttrs.clear();
        this.fixedAttrs.addAll(attrs);
    }

    protected List<Attr> getAttrsFromTO() {
        return this.fixedAttrs.stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    private void setFixedAttr(Collection<PlainSchemaTO> values) {
        values.forEach(schema -> this.linkedAccountTO.getPlainAttr(schema.getKey()).ifPresentOrElse(this.fixedAttrs::add, () -> this.userTO.getPlainAttr(schema.getKey()).ifPresent(this.fixedAttrs::add)));
    }

    private boolean checkIsReadonlyAttr(String schema) {
        return this.schemas.isEmpty() ? true : !((PlainSchemaTO)this.schemas.get(schema)).isReadonly();
    }

    private class PlainSchemasOwn
    extends AbstractAttrsWizardStep.PlainSchemas<List<Attr>> {
        private static final long serialVersionUID = -4730563859116024676L;

        PlainSchemasOwn(String id, final Map<String, PlainSchemaTO> schemas, IModel<List<Attr>> attrTOs) {
            super((AbstractAttrsWizardStep)LinkedAccountPlainAttrsPanel.this, id);
            this.add(new Component[]{new ListView<Attr>("schemas", attrTOs){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<Attr> item) {
                    Attr attrTO = (Attr)item.getModelObject();
                    boolean isMultivalue = ((PlainSchemaTO)schemas.get(attrTO.getSchema())).isMultivalue();
                    AbstractFieldPanel panel = PlainSchemasOwn.this.setPanel(schemas, item, LinkedAccountPlainAttrsPanel.this.linkedAccountTO.getPlainAttr(attrTO.getSchema()).isEmpty());
                    panel.showExternAction(LinkedAccountPlainAttrsPanel.this.checkboxToggle(attrTO, panel, isMultivalue));
                }
            }});
        }
    }
}

