/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.debug;

import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;
import org.apache.synapse.transport.nhttp.debug.AbstractConnectionDebug;
import org.apache.synapse.transport.nhttp.debug.ServerConnectionDebug;

public class ClientConnectionDebug
extends AbstractConnectionDebug {
    private long connectionCreationTime;
    private long lastRequestStartTime;
    private String lastRequestEPR;
    private String lastRequestProtocol;
    private String lastRequestHTTPMethod;
    private StringBuffer previousRequestAttempts;
    private long requestCompletionTime;
    private long responseStartTime;
    private long responseCompletionTime = -1L;
    private String responseLine;
    private ServerConnectionDebug serverConnectionDebug;

    public ClientConnectionDebug(ServerConnectionDebug serverConnectionDebug) {
        this.serverConnectionDebug = serverConnectionDebug;
    }

    public void recordRequestStartTime(NHttpClientConnection conn, Axis2HttpRequest axis2Req) {
        if (conn != null) {
            this.connectionCreationTime = (Long)conn.getContext().getAttribute("synapse.connectionCreationTime");
            try {
                HttpRequest request = axis2Req.getRequest();
                RequestLine requestLine = request.getRequestLine();
                this.lastRequestProtocol = requestLine.getProtocolVersion().toString();
                this.lastRequestHTTPMethod = requestLine.getMethod();
                this.headers = request.getAllHeaders();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lastRequestStartTime != 0L) {
            if (this.previousRequestAttempts == null) {
                this.previousRequestAttempts = new StringBuffer();
            } else {
                this.previousRequestAttempts.append(this.fieldSeparator);
            }
            this.previousRequestAttempts.append("Attempt-Info").append(this.keyValueSeparator).append("{");
            this.previousRequestAttempts.append("Req-Start-Time").append(this.keyValueSeparator).append(this.format(this.lastRequestStartTime));
            this.previousRequestAttempts.append(this.fieldSeparator);
            this.previousRequestAttempts.append("Req-URL").append(this.keyValueSeparator).append(this.lastRequestEPR).append("}");
        }
        this.lastRequestStartTime = System.currentTimeMillis();
        this.lastRequestEPR = axis2Req.getEpr().toString();
    }

    public void recordResponseCompletionTime() {
        this.responseCompletionTime = System.currentTimeMillis();
    }

    public void recordRequestCompletionTime() {
        this.requestCompletionTime = System.currentTimeMillis();
    }

    public void recordResponseStartTime(String responseLine) {
        this.responseStartTime = System.currentTimeMillis();
        this.responseLine = responseLine;
    }

    public long getLastRequestStartTime() {
        return this.lastRequestStartTime;
    }

    public long getResponseCompletionTime() {
        return this.responseCompletionTime;
    }

    public long getResponseStartTime() {
        return this.responseStartTime;
    }

    @Override
    public String dump() {
        StringBuffer sb = new StringBuffer(25);
        sb.append("E2S-Req-Start").append(this.keyValueSeparator).append(this.format(this.lastRequestStartTime));
        sb.append(this.fieldSeparator);
        sb.append("E2S-Req-End").append(this.keyValueSeparator).append(this.format(this.requestCompletionTime));
        sb.append(this.fieldSeparator);
        sb.append("E2S-Req-ConnCreateTime").append(this.keyValueSeparator).append(this.format(this.connectionCreationTime));
        sb.append(this.statementSeparator);
        sb.append("E2S-Req-URL").append(this.keyValueSeparator).append(this.lastRequestEPR);
        sb.append(this.fieldSeparator);
        sb.append("E2S-Req-Protocol").append(this.keyValueSeparator).append(this.lastRequestProtocol);
        sb.append(this.fieldSeparator);
        sb.append("E2S-Req-Method").append(this.keyValueSeparator).append(this.lastRequestHTTPMethod);
        sb.append(this.statementSeparator);
        if (this.previousRequestAttempts != null) {
            sb.append("E2S-Previous-Attempts").append(this.keyValueSeparator).append(this.previousRequestAttempts);
            sb.append(this.statementSeparator);
        }
        sb.append("S2E-Resp-Start").append(this.keyValueSeparator).append(this.format(this.responseStartTime));
        sb.append(this.fieldSeparator);
        sb.append("S2E-Resp-End").append(this.keyValueSeparator).append(this.responseCompletionTime != -1L ? this.format(this.responseCompletionTime) : "NOT-COMPLETED");
        sb.append(this.statementSeparator);
        sb.append("S2E-Resp-Status").append(this.keyValueSeparator).append(this.responseLine);
        if (!this.printNoHeaders) {
            sb.append(this.fieldSeparator);
            sb.append("S2E-Resp-Info").append(this.keyValueSeparator).append("{").append(this.headersToString()).append("}");
        }
        sb.append(this.statementSeparator);
        return sb.toString();
    }

    public ServerConnectionDebug getServerConnectionDebug() {
        return this.serverConnectionDebug;
    }
}

