/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleOutputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.ServerWorker;
import org.apache.synapse.transport.passthru.SourceContext;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.SourceResponse;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.apache.synapse.transport.passthru.jmx.LatencyView;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.util.PassThroughTransportUtils;

public class SourceHandler
implements NHttpServerEventHandler {
    private static final Log log = LogFactory.getLog(SourceHandler.class);
    private final SourceConfiguration sourceConfiguration;
    private PassThroughTransportMetricsCollector metrics = null;
    private LatencyView latencyView = null;
    private LatencyView s2sLatencyView = null;

    public SourceHandler(SourceConfiguration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
        this.metrics = sourceConfiguration.getMetrics();
        try {
            if (!sourceConfiguration.isSsl()) {
                this.latencyView = new LatencyView(sourceConfiguration.isSsl());
            } else {
                this.s2sLatencyView = new LatencyView(sourceConfiguration.isSsl());
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error while initializing latency view calculators", (Throwable)e);
        }
    }

    public void connected(NHttpServerConnection conn) {
        this.sourceConfiguration.getSourceConnections().addConnection(conn);
        SourceContext.create((NHttpConnection)conn, ProtocolState.REQUEST_READY, this.sourceConfiguration);
        this.metrics.connected();
    }

    public void requestReceived(NHttpServerConnection conn) {
        try {
            String method;
            conn.getContext().setAttribute("REQ_ARRIVAL_TIME", (Object)System.currentTimeMillis());
            if (!SourceContext.assertState((NHttpConnection)conn, ProtocolState.REQUEST_READY) && !SourceContext.assertState((NHttpConnection)conn, ProtocolState.GET_REQUEST_COMPLETE)) {
                this.handleInvalidState(conn, "Request received");
                return;
            }
            this.sourceConfiguration.getSourceConnections().useConnection(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_HEAD);
            SourceRequest request = new SourceRequest(this.sourceConfiguration, conn.getHttpRequest(), conn);
            SourceContext.setRequest((NHttpConnection)conn, request);
            request.start(conn);
            this.metrics.incrementMessagesReceived();
            String string = method = request.getRequest() != null ? request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
            if ("GET".equals(method)) {
                HttpContext context = request.getConnection().getContext();
                SimpleOutputBuffer outputBuffer = new SimpleOutputBuffer(8192, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE);
                context.setAttribute("synapse.response-source-buffer", (Object)outputBuffer);
            }
            this.sourceConfiguration.getWorkerPool().execute((Runnable)new ServerWorker(request, this.sourceConfiguration));
        }
        catch (HttpException e) {
            log.error((Object)"HTTP exception while processing request", (Throwable)e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState != ProtocolState.REQUEST_HEAD && protocolState != ProtocolState.REQUEST_BODY) {
                this.handleInvalidState(conn, "Request message body data received");
                return;
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.REQUEST_BODY);
            SourceRequest request = SourceContext.getRequest((NHttpConnection)conn);
            int readBytes = request.read(conn, decoder);
            if (readBytes > 0) {
                this.metrics.incrementBytesReceived(readBytes);
            }
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informReaderError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void responseReady(NHttpServerConnection conn) {
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState.compareTo(ProtocolState.REQUEST_DONE) < 0) {
                return;
            }
            if (protocolState.compareTo(ProtocolState.CLOSING) >= 0) {
                return;
            }
            if (protocolState != ProtocolState.REQUEST_DONE) {
                this.handleInvalidState(conn, "Writing a response");
                return;
            }
            SourceResponse response = SourceContext.getResponse((NHttpConnection)conn);
            if (response != null) {
                response.start(conn);
                this.metrics.incrementMessagesSent();
            }
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
        catch (HttpException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        try {
            ProtocolState protocolState = SourceContext.getState((NHttpConnection)conn);
            if (protocolState == ProtocolState.GET_REQUEST_COMPLETE) {
                SimpleOutputBuffer outBuf = (SimpleOutputBuffer)conn.getContext().getAttribute("synapse.response-source-buffer");
                HttpContext httpContext = conn.getContext();
                synchronized (httpContext) {
                    int bytesWritten = outBuf.produceContent(encoder);
                    if (this.metrics != null && bytesWritten > 0) {
                        this.metrics.incrementBytesSent(bytesWritten);
                    }
                    conn.requestInput();
                    if (!outBuf.hasData() && encoder.isCompleted()) {
                        PassThroughTransportUtils.finishUsingSourceConnection(conn.getHttpResponse(), conn, this.sourceConfiguration.getSourceConnections());
                    }
                }
                return;
            }
            if (protocolState != ProtocolState.RESPONSE_HEAD && protocolState != ProtocolState.RESPONSE_BODY) {
                log.warn((Object)("Illegal incoming connection state: " + (Object)((Object)protocolState) + " . Possibly two send backs " + "are happening for the same request"));
                this.handleInvalidState(conn, "Trying to write response body");
                return;
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_BODY);
            SourceResponse response = SourceContext.getResponse((NHttpConnection)conn);
            int bytesSent = response.write(conn, encoder);
            if (encoder.isCompleted()) {
                HttpContext context = conn.getContext();
                if (context.getAttribute("REQ_ARRIVAL_TIME") != null && context.getAttribute("REQ_DEPARTURE_TIME") != null && context.getAttribute("RES_HEADER_ARRIVAL_TIME") != null) {
                    if (this.latencyView != null) {
                        this.latencyView.notifyTimes((Long)context.getAttribute("REQ_ARRIVAL_TIME"), (Long)context.getAttribute("REQ_DEPARTURE_TIME"), (Long)context.getAttribute("RES_HEADER_ARRIVAL_TIME"), System.currentTimeMillis());
                    } else if (this.s2sLatencyView != null) {
                        this.s2sLatencyView.notifyTimes((Long)context.getAttribute("REQ_ARRIVAL_TIME"), (Long)context.getAttribute("REQ_DEPARTURE_TIME"), (Long)context.getAttribute("RES_HEADER_ARRIVAL_TIME"), System.currentTimeMillis());
                    }
                }
                context.removeAttribute("REQ_ARRIVAL_TIME");
                context.removeAttribute("REQ_DEPARTURE_TIME");
                context.removeAttribute("RES_HEADER_ARRIVAL_TIME");
            }
            this.metrics.incrementBytesSent(bytesSent);
        }
        catch (IOException e) {
            this.logIOException(e);
            this.informWriterError(conn);
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void endOfInput(NHttpServerConnection conn) throws IOException {
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        boolean isError = false;
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keep-Alive connection was closed by the client: " + conn));
            }
        } else if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            isError = true;
            this.informReaderError(conn);
            log.warn((Object)("Connection closed by the client while reading the request: " + conn));
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            isError = true;
            this.informWriterError(conn);
            log.warn((Object)("Connection closed by the client end while writing the response: " + conn));
        } else if (state == ProtocolState.REQUEST_DONE) {
            isError = true;
            log.warn((Object)("Connection closed by the client after request is read: " + conn));
        }
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, isError);
    }

    public void exception(NHttpServerConnection conn, Exception e) {
        if (e instanceof HttpException) {
            this.exception(conn, (HttpException)((Object)e));
        } else if (e instanceof IOException) {
            this.exception(conn, (IOException)e);
        } else {
            log.error((Object)"Unexpected exception encountered in SourceHandler", (Throwable)e);
            this.metrics.incrementFaultsReceiving();
            ProtocolState state = SourceContext.getState((NHttpConnection)conn);
            if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
                this.informReaderError(conn);
            } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
                this.informWriterError(conn);
            } else if (state == ProtocolState.REQUEST_DONE) {
                this.informWriterError(conn);
            } else if (state == ProtocolState.RESPONSE_DONE) {
                this.informWriterError(conn);
            }
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void exception(NHttpServerConnection conn, IOException e) {
        this.logIOException(e);
        this.metrics.incrementFaultsReceiving();
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            this.informReaderError(conn);
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            this.informWriterError(conn);
        } else if (state == ProtocolState.REQUEST_DONE) {
            this.informWriterError(conn);
        } else if (state == ProtocolState.RESPONSE_DONE) {
            this.informWriterError(conn);
        }
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
    }

    private void logIOException(IOException e) {
        if (e == null) {
            return;
        }
        if (e instanceof ConnectionClosedException || e.getMessage() != null && (e.getMessage().toLowerCase().contains("connection reset by peer") || e.getMessage().toLowerCase().contains("forcibly closed"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I/O error (Probably a keep-alive connection was closed):" + e.getMessage()));
            }
        } else if (e.getMessage() != null) {
            String msg = e.getMessage().toLowerCase();
            if (msg.contains("broken")) {
                log.warn((Object)("I/O error (Probably the connection was closed by the remote party):" + e.getMessage()));
            } else {
                log.error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
            }
            this.metrics.incrementFaultsReceiving();
        } else {
            log.error((Object)("Unexpected I/O error: " + e.getClass().getName()), (Throwable)e);
            this.metrics.incrementFaultsReceiving();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(NHttpServerConnection conn, HttpException e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"HTTP protocol error encountered in SourceHandler", (Throwable)e);
        }
        if (conn.isResponseSubmitted()) {
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
            return;
        }
        HttpContext httpContext = conn.getContext();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 400, "Bad request");
        response.addHeader("Connection", "Close");
        httpContext.setAttribute("http.connection", (Object)conn);
        httpContext.setAttribute("http.request", null);
        httpContext.setAttribute("http.response", (Object)response);
        try {
            this.sourceConfiguration.getHttpProcessor().process((HttpResponse)response, httpContext);
            conn.submitResponse((HttpResponse)response);
        }
        catch (Exception ex) {
            log.error((Object)"Error while handling HttpException", (Throwable)ex);
        }
        finally {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
        }
    }

    public void timeout(NHttpServerConnection conn) {
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keep-Alive connection was time out: " + conn));
            }
        } else if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            this.metrics.incrementTimeoutsReceiving();
            this.informReaderError(conn);
            log.warn((Object)("Connection time out while reading the request: " + conn));
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            this.informWriterError(conn);
            log.warn((Object)("Connection time out while writing the response: " + conn));
        } else if (state == ProtocolState.REQUEST_DONE) {
            log.warn((Object)("Connection time out after request is read: " + conn));
        }
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
    }

    public void closed(NHttpServerConnection conn) {
        ProtocolState state = SourceContext.getState((NHttpConnection)conn);
        boolean isFault = false;
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Keep-Alive connection was closed: " + conn));
            }
        } else if (state == ProtocolState.REQUEST_BODY || state == ProtocolState.REQUEST_HEAD) {
            isFault = true;
            this.informReaderError(conn);
            log.warn((Object)("Connection closed while reading the request: " + conn));
        } else if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.RESPONSE_HEAD) {
            isFault = true;
            this.informWriterError(conn);
            log.warn((Object)("Connection closed while writing the response: " + conn));
        } else if (state == ProtocolState.REQUEST_DONE) {
            isFault = true;
            log.warn((Object)("Connection closed after request is read: " + conn));
        }
        this.metrics.disconnected();
        if (state != ProtocolState.CLOSED) {
            SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, isFault);
        }
    }

    private void handleInvalidState(NHttpServerConnection conn, String action) {
        log.warn((Object)(action + " while the handler is in an inconsistent state " + (Object)((Object)SourceContext.getState((NHttpConnection)conn))));
        SourceContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.sourceConfiguration.getSourceConnections().shutDownConnection(conn, true);
    }

    private void informReaderError(NHttpServerConnection conn) {
        Pipe reader = SourceContext.get((NHttpConnection)conn).getReader();
        this.metrics.incrementFaultsReceiving();
        if (reader != null) {
            reader.producerError();
        }
    }

    private void informWriterError(NHttpServerConnection conn) {
        Pipe writer = SourceContext.get((NHttpConnection)conn).getWriter();
        this.metrics.incrementFaultsSending();
        if (writer != null) {
            writer.consumerError();
        }
    }

    private void handleException(String msg, Exception e, NHttpServerConnection conn) {
        String errorMessage = conn != null ? "[" + conn + "] " + msg : msg;
        log.error((Object)errorMessage, (Throwable)e);
    }

    public void commitResponseHideExceptions(NHttpServerConnection conn, HttpResponse response) {
        try {
            conn.suspendInput();
            this.sourceConfiguration.getHttpProcessor().process(response, conn.getContext());
            conn.submitResponse(response);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error : " + e.getMessage(), (Exception)((Object)e), conn);
        }
        catch (IOException e) {
            this.handleException("IO error submitting response : " + e.getMessage(), e, conn);
        }
    }
}

