/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DBPoolView;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.DataSourceRepository;
import org.apache.synapse.commons.datasource.DatasourceMBeanRepository;
import org.apache.synapse.commons.datasource.factory.DataSourceFactory;
import org.apache.synapse.commons.jmx.MBeanRepository;

public class InMemoryDataSourceRepository
implements DataSourceRepository {
    private static final Log log = LogFactory.getLog(InMemoryDataSourceRepository.class);
    private final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();
    private static final MBeanRepository REPOSITORY = DatasourceMBeanRepository.getInstance();

    public void register(DataSourceInformation dataSourceInformation) {
        if (dataSourceInformation == null) {
            throw new SynapseCommonsException("DataSourceInformation cannot be found.", log);
        }
        DataSource dataSource = DataSourceFactory.createDataSource(dataSourceInformation);
        if (dataSource == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("DataSource cannot be created or found for DataSource Information " + dataSourceInformation));
            }
            return;
        }
        String name = dataSourceInformation.getDatasourceName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering a DatSource with name : " + name + " in Local Pool"));
        }
        REPOSITORY.addMBean(name, new DBPoolView(name));
        this.dataSources.put(name, dataSource);
    }

    public void unRegister(String name) {
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("Name of the datasource to be removed is empty or null", log);
        }
        this.dataSources.remove(name);
        REPOSITORY.removeMBean(name);
    }

    public DataSource lookUp(String name) {
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("Name of the datasource to be looked up is empty ornull", log);
        }
        return this.dataSources.get(name);
    }

    public void init(Properties properties) {
    }

    public boolean isInitialized() {
        return true;
    }

    public void clear() {
        if (!this.dataSources.isEmpty()) {
            log.info((Object)"Clearing all in-memory datasources ");
            this.dataSources.clear();
        }
        REPOSITORY.clear();
    }
}

