/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.lang.StringUtils;
import org.apache.submarine.commons.utils.SubmarineConfVars;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmarineConfiguration
extends XMLConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SubmarineConfiguration.class);
    private static final long serialVersionUID = 4749303235693848035L;
    private static final String SUBMARINE_SITE_XML = "submarine-site.xml";
    public static final String SUBMARINE_RUNTIME_APP_TYPE = "SUBMARINE";
    private static volatile SubmarineConfiguration conf;
    private final Map<String, String> properties = new HashMap<String, String>();
    public static final String SUBMARINE_VERSION;

    public static String getSubmarineVersion() {
        return SUBMARINE_VERSION;
    }

    private SubmarineConfiguration(URL url) throws ConfigurationException {
        this.setDelimiterParsingDisabled(true);
        this.load(url);
        this.initProperties();
    }

    private void initProperties() {
        List nodes = this.getRootNode().getChildren();
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (ConfigurationNode p : nodes) {
            String name = (String)((ConfigurationNode)p.getChildren("name").get(0)).getValue();
            String value = (String)((ConfigurationNode)p.getChildren("value").get(0)).getValue();
            if (StringUtils.isEmpty((String)name)) continue;
            this.properties.put(name, value);
        }
    }

    private SubmarineConfiguration() {
        SubmarineConfVars.ConfVars[] vars;
        for (SubmarineConfVars.ConfVars v : vars = SubmarineConfVars.ConfVars.values()) {
            if (v.getType() == SubmarineConfVars.ConfVars.VarType.BOOLEAN) {
                this.setProperty(v.getVarName(), v.getBooleanValue());
                continue;
            }
            if (v.getType() == SubmarineConfVars.ConfVars.VarType.LONG) {
                this.setProperty(v.getVarName(), v.getLongValue());
                continue;
            }
            if (v.getType() == SubmarineConfVars.ConfVars.VarType.INT) {
                this.setProperty(v.getVarName(), v.getIntValue());
                continue;
            }
            if (v.getType() == SubmarineConfVars.ConfVars.VarType.FLOAT) {
                this.setProperty(v.getVarName(), Float.valueOf(v.getFloatValue()));
                continue;
            }
            if (v.getType() == SubmarineConfVars.ConfVars.VarType.STRING) {
                this.setProperty(v.getVarName(), v.getStringValue());
                continue;
            }
            throw new RuntimeException("Unsupported VarType");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubmarineConfiguration getInstance() {
        if (conf != null) return conf;
        Class<SubmarineConfiguration> clazz = SubmarineConfiguration.class;
        synchronized (SubmarineConfiguration.class) {
            if (conf != null) return conf;
            conf = SubmarineConfiguration.newInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return conf;
        }
    }

    public static SubmarineConfiguration newInstance() {
        SubmarineConfiguration submarineConfig;
        ClassLoader cl;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = SubmarineConfiguration.class.getResource(SUBMARINE_SITE_XML);
        if (url == null && (cl = SubmarineConfiguration.class.getClassLoader()) != null) {
            url = cl.getResource(SUBMARINE_SITE_XML);
        }
        if (url == null) {
            url = classLoader.getResource(SUBMARINE_SITE_XML);
        }
        if (url == null) {
            LOG.warn("Failed to load configuration, proceeding with a default");
            submarineConfig = new SubmarineConfiguration();
        } else {
            try {
                LOG.info("Load configuration from " + url);
                submarineConfig = new SubmarineConfiguration(url);
            }
            catch (ConfigurationException e) {
                LOG.warn("Failed to load configuration from " + url + " proceeding with a default", (Throwable)e);
                submarineConfig = new SubmarineConfiguration();
            }
        }
        return submarineConfig;
    }

    public String getServerAddress() {
        return this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_ADDR);
    }

    public boolean useSsl() {
        return this.getBoolean(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL);
    }

    public int getServerPort() {
        return this.getInt(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_PORT);
    }

    @VisibleForTesting
    public void setServerPort(int port) {
        this.properties.put(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_PORT.getVarName(), String.valueOf(port));
    }

    public int getServerSslPort() {
        return this.getInt(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_PORT);
    }

    public String getKeyStorePath() {
        String path = this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_KEYSTORE_PATH);
        return path;
    }

    public String getKeyStoreType() {
        return this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_KEYSTORE_TYPE);
    }

    public String getKeyStorePassword() {
        return this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_KEYSTORE_PASSWORD);
    }

    public String getKeyManagerPassword() {
        String password = this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_KEY_MANAGER_PASSWORD);
        if (password == null) {
            return this.getKeyStorePassword();
        }
        return password;
    }

    public boolean useClientAuth() {
        return this.getBoolean(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_CLIENT_AUTH);
    }

    public String getTrustStorePath() {
        String path = this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_TRUSTSTORE_PATH);
        if (path == null) {
            path = this.getKeyStorePath();
        }
        return path;
    }

    public String getTrustStoreType() {
        String type = this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_TRUSTSTORE_TYPE);
        if (type == null) {
            return this.getKeyStoreType();
        }
        return type;
    }

    public String getTrustStorePassword() {
        String password = this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SSL_TRUSTSTORE_PASSWORD);
        if (password == null) {
            return this.getKeyStorePassword();
        }
        return password;
    }

    public Integer getJettyRequestHeaderSize() {
        return this.getInt(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_JETTY_REQUEST_HEADER_SIZE);
    }

    public String getRelativeDir(SubmarineConfVars.ConfVars c) {
        return this.getRelativeDir(this.getString(c));
    }

    public String getRelativeDir(String path) {
        if (path != null && path.startsWith(File.separator) || this.isWindowsPath(path)) {
            return path;
        }
        return this.getString("./") + File.separator + path;
    }

    public boolean isWindowsPath(String path) {
        return path.matches("^[A-Za-z]:\\\\.*");
    }

    public String getJdbcDriverClassName() {
        return this.getString(SubmarineConfVars.ConfVars.JDBC_DRIVERCLASSNAME);
    }

    public String getJdbcUrl() {
        return this.getString(SubmarineConfVars.ConfVars.JDBC_URL);
    }

    public String getMetastoreJdbcUrl() {
        return this.getString(SubmarineConfVars.ConfVars.METASTORE_JDBC_URL);
    }

    @VisibleForTesting
    public void setMetastoreJdbcUrl(String testMetastoreJdbcUrl) {
        this.properties.put(SubmarineConfVars.ConfVars.METASTORE_JDBC_URL.getVarName(), testMetastoreJdbcUrl);
    }

    @VisibleForTesting
    public void setJdbcDriverClassName(String driverClassName) {
        this.properties.put(SubmarineConfVars.ConfVars.JDBC_DRIVERCLASSNAME.getVarName(), driverClassName);
    }

    @VisibleForTesting
    public void setJdbcUrl(String testJdbcUrl) {
        this.properties.put(SubmarineConfVars.ConfVars.JDBC_URL.getVarName(), testJdbcUrl);
    }

    public String getJdbcUserName() {
        return this.getString(SubmarineConfVars.ConfVars.JDBC_USERNAME);
    }

    public String getMetastoreJdbcUserName() {
        return this.getString(SubmarineConfVars.ConfVars.METASTORE_JDBC_USERNAME);
    }

    @VisibleForTesting
    public void setJdbcUserName(String userName) {
        this.properties.put(SubmarineConfVars.ConfVars.JDBC_USERNAME.getVarName(), userName);
    }

    @VisibleForTesting
    public void setMetastoreJdbcUserName(String metastoreUserName) {
        this.properties.put(SubmarineConfVars.ConfVars.METASTORE_JDBC_USERNAME.getVarName(), metastoreUserName);
    }

    public String getJdbcPassword() {
        return this.getString(SubmarineConfVars.ConfVars.JDBC_PASSWORD);
    }

    public String getMetastoreJdbcPassword() {
        return this.getString(SubmarineConfVars.ConfVars.METASTORE_JDBC_PASSWORD);
    }

    @VisibleForTesting
    public void setJdbcPassword(String password) {
        this.properties.put(SubmarineConfVars.ConfVars.JDBC_PASSWORD.getVarName(), password);
    }

    @VisibleForTesting
    public void setMetastoreJdbcPassword(String metastorePassword) {
        this.properties.put(SubmarineConfVars.ConfVars.METASTORE_JDBC_PASSWORD.getVarName(), metastorePassword);
    }

    public String getClusterAddress() {
        return this.getString(SubmarineConfVars.ConfVars.SUBMARINE_CLUSTER_ADDR);
    }

    public void setClusterAddress(String clusterAddr) {
        this.properties.put(SubmarineConfVars.ConfVars.SUBMARINE_CLUSTER_ADDR.getVarName(), clusterAddr);
    }

    public boolean isClusterMode() {
        String clusterAddr = this.getString(SubmarineConfVars.ConfVars.SUBMARINE_CLUSTER_ADDR);
        return !StringUtils.isEmpty((String)clusterAddr);
    }

    public int getClusterHeartbeatInterval() {
        return this.getInt(SubmarineConfVars.ConfVars.CLUSTER_HEARTBEAT_INTERVAL);
    }

    public int getClusterHeartbeatTimeout() {
        return this.getInt(SubmarineConfVars.ConfVars.CLUSTER_HEARTBEAT_TIMEOUT);
    }

    public String getWebsocketMaxTextMessageSize() {
        return this.getString(SubmarineConfVars.ConfVars.WORKBENCH_WEBSOCKET_MAX_TEXT_MESSAGE_SIZE);
    }

    public String getServerServiceName() {
        return this.getString(SubmarineConfVars.ConfVars.SUBMARINE_SERVER_SERVICE_NAME);
    }

    private String getStringValue(String name, String d) {
        String value = this.properties.get(name);
        if (value != null) {
            return value;
        }
        return d;
    }

    private int getIntValue(String name, int d) {
        String value = this.properties.get(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return d;
    }

    private long getLongValue(String name, long d) {
        String value = this.properties.get(name);
        if (value != null) {
            return Long.parseLong(value);
        }
        return d;
    }

    private float getFloatValue(String name, float d) {
        String value = this.properties.get(name);
        if (value != null) {
            return Float.parseFloat(value);
        }
        return d;
    }

    private boolean getBooleanValue(String name, boolean d) {
        String value = this.properties.get(name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return d;
    }

    public String getString(SubmarineConfVars.ConfVars c) {
        return this.getString(c.name(), c.getVarName(), c.getStringValue());
    }

    public String getString(String envName, String propertyName, String defaultValue) {
        if (System.getenv(envName) != null) {
            return System.getenv(envName);
        }
        if (System.getProperty(propertyName) != null) {
            return System.getProperty(propertyName);
        }
        return this.getStringValue(propertyName, defaultValue);
    }

    public void setString(SubmarineConfVars.ConfVars c, String value) {
        this.properties.put(c.getVarName(), value);
    }

    public int getInt(SubmarineConfVars.ConfVars c) {
        return this.getInt(c.name(), c.getVarName(), c.getIntValue());
    }

    public void setInt(SubmarineConfVars.ConfVars c, int value) {
        this.properties.put(c.getVarName(), String.valueOf(value));
    }

    public int getInt(String envName, String propertyName, int defaultValue) {
        if (System.getenv(envName) != null) {
            return Integer.parseInt(System.getenv(envName));
        }
        if (System.getProperty(propertyName) != null) {
            return Integer.parseInt(System.getProperty(propertyName));
        }
        return this.getIntValue(propertyName, defaultValue);
    }

    public long getLong(SubmarineConfVars.ConfVars c) {
        return this.getLong(c.name(), c.getVarName(), c.getLongValue());
    }

    public void setLong(SubmarineConfVars.ConfVars c, long value) {
        this.properties.put(c.getVarName(), String.valueOf(value));
    }

    public long getLong(String envName, String propertyName, long defaultValue) {
        if (System.getenv(envName) != null) {
            return Long.parseLong(System.getenv(envName));
        }
        if (System.getProperty(propertyName) != null) {
            return Long.parseLong(System.getProperty(propertyName));
        }
        return this.getLongValue(propertyName, defaultValue);
    }

    public float getFloat(SubmarineConfVars.ConfVars c) {
        return this.getFloat(c.name(), c.getVarName(), c.getFloatValue());
    }

    public float getFloat(String envName, String propertyName, float defaultValue) {
        if (System.getenv(envName) != null) {
            return Float.parseFloat(System.getenv(envName));
        }
        if (System.getProperty(propertyName) != null) {
            return Float.parseFloat(System.getProperty(propertyName));
        }
        return this.getFloatValue(propertyName, defaultValue);
    }

    public boolean getBoolean(SubmarineConfVars.ConfVars c) {
        return this.getBoolean(c.name(), c.getVarName(), c.getBooleanValue());
    }

    public boolean getBoolean(String envName, String propertyName, boolean defaultValue) {
        if (System.getenv(envName) != null) {
            return Boolean.parseBoolean(System.getenv(envName));
        }
        if (System.getProperty(propertyName) != null) {
            return Boolean.parseBoolean(System.getProperty(propertyName));
        }
        return this.getBooleanValue(propertyName, defaultValue);
    }

    public void updateConfiguration(String name, String value) {
        this.properties.put(name, value);
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(SubmarineConfiguration.class.getClassLoader().getResourceAsStream("submarine.properties"));
            SUBMARINE_VERSION = properties.getProperty("project.version");
        }
        catch (IOException e) {
            throw new RuntimeException("Can not get submarine version!");
        }
    }
}

