/*
 * Decompiled with CFR 0.152.
 */
package org.apache.submarine.commons.utils;

public abstract class AbstractUniqueIdGenerator<T>
implements Comparable<T> {
    private static final int ID_MIN_DIGITS = 4;
    private int id;
    private long serverTimestamp;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public void setServerTimestamp(long timestamp) {
        this.serverTimestamp = timestamp;
    }

    @Override
    public int compareTo(Object o) {
        AbstractUniqueIdGenerator other = (AbstractUniqueIdGenerator)o;
        return this.getId() > other.getId() ? 1 : 0;
    }

    public int hashCode() {
        int prime = 371237;
        int result = 6521;
        result = 371237 * result + (int)(this.getServerTimestamp() ^ this.getServerTimestamp() >>> 32);
        result = 371237 * result + this.getId();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AbstractUniqueIdGenerator other = (AbstractUniqueIdGenerator)obj;
        if (this.getServerTimestamp() != other.getServerTimestamp()) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected void format(StringBuilder sb, long value) {
        int minimumDigits = 4;
        if (value < 0L) {
            sb.append('-');
            value = -value;
        }
        long tmp = value;
        while (--minimumDigits > 0 && (tmp /= 10L) > 0L) {
        }
        for (int i = minimumDigits; i > 0; --i) {
            sb.append('0');
        }
        sb.append(value);
    }
}

