/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result.xslt;

import com.opensymphony.xwork2.util.DomHelper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.result.xslt.AbstractAdapterElement;
import org.apache.struts2.result.xslt.AdapterFactory;
import org.apache.struts2.result.xslt.AdapterNode;
import org.apache.struts2.result.xslt.SimpleTextNode;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class StringAdapter
extends AbstractAdapterElement {
    private static final Logger LOG = LogManager.getLogger(StringAdapter.class);
    boolean parseStringAsXML;

    public StringAdapter() {
    }

    public StringAdapter(AdapterFactory adapterFactory, AdapterNode parent, String propertyName, String value) {
        this.setContext(adapterFactory, parent, propertyName, value);
    }

    protected String getStringValue() {
        return this.getPropertyValue().toString();
    }

    @Override
    protected List<Node> buildChildAdapters() {
        Node node;
        if (this.getParseStringAsXML()) {
            LOG.debug("parsing string as xml: {}", (Object)this.getStringValue());
            node = DomHelper.parse((InputSource)new InputSource(new StringReader(this.getStringValue())));
            node = this.getAdapterFactory().proxyNode(this, node);
        } else {
            LOG.debug("using string as is: {}", (Object)this.getStringValue());
            node = new SimpleTextNode(this.getAdapterFactory(), this, "text", this.getStringValue());
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(node);
        return children;
    }

    public boolean getParseStringAsXML() {
        return this.parseStringAsXML;
    }

    public void setParseStringAsXML(boolean parseStringAsXML) {
        this.parseStringAsXML = parseStringAsXML;
    }
}

