/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Collection;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.RenderRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.dispatcher.DirectRenderFromEventAction;

public class PortletStateInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PortletStateInterceptor.class);
    private static final long serialVersionUID = 6138452063353911784L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        Integer phase = (Integer)invocation.getInvocationContext().get(PortletConstants.PHASE);
        if (PortletConstants.RENDER_PHASE.equals(phase)) {
            this.restoreStack(invocation);
            return invocation.invoke();
        }
        if (PortletConstants.ACTION_PHASE.equals(phase)) {
            try {
                String string = invocation.invoke();
                return string;
            }
            finally {
                this.saveStack(invocation);
            }
        }
        return invocation.invoke();
    }

    private void saveStack(ActionInvocation invocation) {
        Map session = invocation.getInvocationContext().getSession();
        session.put(PortletConstants.STACK_FROM_EVENT_PHASE, invocation.getStack());
        ActionResponse actionResponse = (ActionResponse)invocation.getInvocationContext().get(PortletConstants.RESPONSE);
        actionResponse.setRenderParameter(PortletConstants.EVENT_ACTION, "true");
    }

    private void restoreStack(ActionInvocation invocation) {
        RenderRequest request = (RenderRequest)invocation.getInvocationContext().get(PortletConstants.REQUEST);
        if (StringUtils.isNotEmpty((String)request.getParameter(PortletConstants.EVENT_ACTION))) {
            if (!this.isProperPrg(invocation)) {
                ValueStack oldStack;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Restoring value stack from event phase", new String[0]);
                }
                if ((oldStack = (ValueStack)invocation.getInvocationContext().getSession().get(PortletConstants.STACK_FROM_EVENT_PHASE)) != null) {
                    CompoundRoot oldRoot = oldStack.getRoot();
                    ValueStack currentStack = invocation.getStack();
                    CompoundRoot root = currentStack.getRoot();
                    root.addAll((Collection)oldRoot);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Restored stack", new String[0]);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Won't restore stack from event phase since it's a proper PRG request", new String[0]);
            }
        }
    }

    private boolean isProperPrg(ActionInvocation invocation) {
        return !(invocation.getAction() instanceof DirectRenderFromEventAction);
    }
}

