/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.junit;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.interceptor.ValidationAware;
import com.opensymphony.xwork2.interceptor.annotations.After;
import com.opensymphony.xwork2.interceptor.annotations.Before;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.junit.XWorkJUnit4TestCase;
import org.apache.struts2.util.StrutsTestCaseHelper;
import org.junit.Assert;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockPageContext;
import org.springframework.mock.web.MockServletContext;

public abstract class StrutsJUnit4TestCase<T>
extends XWorkJUnit4TestCase {
    protected MockHttpServletResponse response;
    protected MockHttpServletRequest request;
    protected MockPageContext pageContext;
    protected MockServletContext servletContext;
    protected Map<String, String> dispatcherInitParams;
    protected Dispatcher dispatcher;
    protected DefaultResourceLoader resourceLoader = new DefaultResourceLoader();

    protected Object findValueAfterExecute(String key) {
        return ServletActionContext.getValueStack((HttpServletRequest)this.request).findValue(key);
    }

    protected T getAction() {
        return (T)this.findValueAfterExecute("action");
    }

    protected boolean containsErrors() {
        T action = this.getAction();
        if (action instanceof ValidationAware) {
            return ((ValidationAware)action).hasActionErrors();
        }
        throw new UnsupportedOperationException("Current action does not implement ValidationAware interface");
    }

    protected String executeAction(String uri) throws ServletException, UnsupportedEncodingException {
        this.request.setRequestURI(uri);
        ActionMapping mapping = this.getActionMapping((HttpServletRequest)this.request);
        Assert.assertNotNull((Object)mapping);
        Dispatcher.getInstance().serviceAction((HttpServletRequest)this.request, (HttpServletResponse)this.response, mapping);
        if (this.response.getStatus() != 200) {
            throw new ServletException("Error code [" + this.response.getStatus() + "], Error: [" + this.response.getErrorMessage() + "]");
        }
        return this.response.getContentAsString();
    }

    protected ActionProxy getActionProxy(String uri) {
        this.request.setRequestURI(uri);
        ActionMapping mapping = this.getActionMapping((HttpServletRequest)this.request);
        String namespace = mapping.getNamespace();
        String name = mapping.getName();
        String method = mapping.getMethod();
        Configuration config = this.configurationManager.getConfiguration();
        ActionProxy proxy = ((ActionProxyFactory)config.getContainer().getInstance(ActionProxyFactory.class)).createActionProxy(namespace, name, method, new HashMap(), true, false);
        this.initActionContext(proxy.getInvocation().getInvocationContext());
        ServletActionContext.setServletContext((ServletContext)this.servletContext);
        ServletActionContext.setRequest((HttpServletRequest)this.request);
        ServletActionContext.setResponse((HttpServletResponse)this.response);
        ServletActionContext.getContext().put("struts.actionMapping", (Object)mapping);
        return proxy;
    }

    protected void initActionContext(ActionContext actionContext) {
        actionContext.withParameters(HttpParameters.create((Map)this.request.getParameterMap()).build());
        this.initSession(actionContext);
        ActionContext.bind((ActionContext)actionContext);
    }

    protected void initSession(ActionContext actionContext) {
        if (actionContext.getSession() == null) {
            actionContext.withSession(new HashMap());
            this.request.setSession((HttpSession)new MockHttpSession((ServletContext)this.servletContext));
        }
    }

    protected ActionMapping getActionMapping(HttpServletRequest request) {
        return ((ActionMapper)this.container.getInstance(ActionMapper.class)).getMapping(request, this.configurationManager);
    }

    protected ActionMapping getActionMapping(String url) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setRequestURI(url);
        return this.getActionMapping((HttpServletRequest)req);
    }

    protected void injectStrutsDependencies(Object object) {
        this.container.inject(object);
    }

    protected void setupBeforeInitDispatcher() throws Exception {
    }

    protected void initServletMockObjects() {
        this.servletContext = new MockServletContext((ResourceLoader)this.resourceLoader);
        this.response = new MockHttpServletResponse();
        this.request = new MockHttpServletRequest();
        this.pageContext = new MockPageContext((ServletContext)this.servletContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    public void finishExecution() {
        HttpSession session = this.request.getSession();
        Enumeration attributeNames = session.getAttributeNames();
        MockHttpServletRequest nextRequest = new MockHttpServletRequest();
        while (attributeNames.hasMoreElements()) {
            String key = (String)attributeNames.nextElement();
            Object attribute = session.getAttribute(key);
            nextRequest.getSession().setAttribute(key, attribute);
        }
        this.response = new MockHttpServletResponse();
        this.request = nextRequest;
        this.pageContext = new MockPageContext((ServletContext)this.servletContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initServletMockObjects();
        this.setupBeforeInitDispatcher();
        this.initDispatcherParams();
        this.initDispatcher(this.dispatcherInitParams);
    }

    protected void initDispatcherParams() {
        if (StringUtils.isNotBlank((CharSequence)this.getConfigPath())) {
            this.dispatcherInitParams = new HashMap<String, String>();
            this.dispatcherInitParams.put("config", "struts-default.xml," + this.getConfigPath());
        }
    }

    protected Dispatcher initDispatcher(Map<String, String> params) {
        this.dispatcher = StrutsTestCaseHelper.initDispatcher((ServletContext)this.servletContext, params);
        this.configurationManager = this.dispatcher.getConfigurationManager();
        this.configuration = this.configurationManager.getConfiguration();
        this.container = this.configuration.getContainer();
        this.container.inject((Object)this.dispatcher);
        return this.dispatcher;
    }

    protected String getConfigPath() {
        return null;
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.dispatcher != null && this.dispatcher.getConfigurationManager() != null) {
            this.dispatcher.cleanup();
            this.dispatcher = null;
        }
        StrutsTestCaseHelper.tearDown();
    }
}

