/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.convention.AbstractActionNameBuilder;

public class SEOActionNameBuilder
extends AbstractActionNameBuilder {
    private static final Logger LOG = LogManager.getLogger(SEOActionNameBuilder.class);
    private boolean lowerCase;
    private String separator;

    @Inject
    public SEOActionNameBuilder(@Inject(value="struts.convention.action.name.lowercase") String lowerCase, @Inject(value="struts.convention.action.name.separator") String separator) {
        this.lowerCase = Boolean.parseBoolean(lowerCase);
        this.separator = separator;
    }

    @Override
    public String build(String className) {
        String actionName = className;
        this.checkActionName(actionName);
        LOG.trace("Truncate Action suffix if found");
        actionName = this.truncateSuffixIfMatches(actionName);
        LOG.trace("Convert to underscores");
        char[] ca = actionName.toCharArray();
        StringBuilder build = new StringBuilder("" + ca[0]);
        boolean lower = true;
        for (int i = 1; i < ca.length; ++i) {
            char c = ca[i];
            if (Character.isUpperCase(c) && lower) {
                build.append(this.separator);
                lower = false;
            } else if (!Character.isUpperCase(c)) {
                lower = true;
            }
            build.append(c);
        }
        actionName = build.toString();
        if (this.lowerCase) {
            actionName = actionName.toLowerCase();
        }
        LOG.trace("Changed action name from [{}] to [{}]", (Object)className, (Object)actionName);
        return actionName;
    }
}

