/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.util.List;
import org.apache.streampark.common.util.RedisConfig$;
import org.apache.streampark.common.util.RedisEndpoint;
import org.apache.streampark.common.util.RedisEndpoint$;
import org.apache.streampark.common.util.RedisNode;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\tY!+\u001a3jg\u000e{gNZ5h\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003\u0019\u0019w.\\7p]*\u0011q\u0001C\u0001\u000bgR\u0014X-Y7qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003-Ig.\u001b;jC2Dun\u001d;\u0016\u0003i\u0001\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001bI+G-[:F]\u0012\u0004x.\u001b8u\u0011!y\u0002A!A!\u0002\u0013Q\u0012\u0001D5oSRL\u0017\r\u001c%pgR\u0004\u0003\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\b\u0006\u0002$IA\u00111\u0004\u0001\u0005\u00061\u0001\u0002\rA\u0007\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0003-Ig.\u001b;jC2\fE\r\u001a:\u0016\u0003!\u0002\"!\u000b\u0017\u000f\u0005=Q\u0013BA\u0016\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\u0002\u0002B\u0002\u0019\u0001A\u0003%\u0001&\u0001\u0007j]&$\u0018.\u00197BI\u0012\u0014\b\u0005C\u00043\u0001\t\u0007I\u0011A\u001a\u0002\u000b!|7\u000f^:\u0016\u0003Q\u00022aD\u001b8\u0013\t1\u0004CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001cq%\u0011\u0011H\u0001\u0002\n%\u0016$\u0017n\u001d(pI\u0016Daa\u000f\u0001!\u0002\u0013!\u0014A\u00025pgR\u001c\b\u0005C\u0004>\u0001\t\u0007I\u0011A\u001a\u0002\u000b9|G-Z:\t\r}\u0002\u0001\u0015!\u00035\u0003\u0019qw\u000eZ3tA!)\u0011\t\u0001C\u0001O\u00059q-\u001a;BkRD\u0007\"B\"\u0001\t\u0003!\u0015!B4fi\u0012\u0013U#A#\u0011\u0005=1\u0015BA$\u0011\u0005\rIe\u000e\u001e\u0005\u0006\u0013\u0002!\tAS\u0001\u000eO\u0016$(+\u00198e_6tu\u000eZ3\u0016\u0003]BQ\u0001\u0014\u0001\u0005\u00025\u000bqbZ3u\u001d>$Wm\u001d\"z'2|Go\u001d\u000b\u0004i9\u0003\u0006\"B(L\u0001\u0004)\u0015\u0001B:Q_NDQ!U&A\u0002\u0015\u000bA!\u001a)pg\")1\u000b\u0001C\u0001)\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8G_J\\U-\u001f\u000b\u0003+~\u0003\"AV/\u000e\u0003]S!\u0001W-\u0002\u000b),G-[:\u000b\u0005i[\u0016aB2mS\u0016tGo\u001d\u0006\u00029\u0006)!/\u001a3jg&\u0011al\u0016\u0002\u0006\u0015\u0016$\u0017n\u001d\u0005\u0006AJ\u0003\r\u0001K\u0001\u0004W\u0016L\b\"\u00022\u0001\t\u0013\u0019\u0017AD2mkN$XM]#oC\ndW\r\u001a\u000b\u0003I\u001e\u0004\"aD3\n\u0005\u0019\u0004\"a\u0002\"p_2,\u0017M\u001c\u0005\u00061\u0005\u0004\rA\u0007\u0005\u0006S\u0002!\tA[\u0001\bO\u0016$\bj\\:u)\t94\u000eC\u0003aQ\u0002\u0007\u0001\u0006C\u0003n\u0001\u0011%a.\u0001\u0005hKRDun\u001d;t)\t!t\u000eC\u0003\u0019Y\u0002\u0007!\u0004C\u0003r\u0001\u0011%!/\u0001\nhKRtuN\\\"mkN$XM\u001d(pI\u0016\u001cHC\u0001\u001bt\u0011\u0015A\u0002\u000f1\u0001\u001b\u0011\u0015)\b\u0001\"\u0003w\u0003=9W\r^\"mkN$XM\u001d(pI\u0016\u001cHC\u0001\u001bx\u0011\u0015AB\u000f1\u0001\u001b\u0011\u0015I\b\u0001\"\u0001{\u0003!9W\r\u001e(pI\u0016\u001cHC\u0001\u001b|\u0011\u0015A\u0002\u00101\u0001\u001b\u0001")
public class RedisConfig
implements Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().db();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.nodes()).filter((Function1)new Serializable(this, sPos, ePos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisConfig $outer;
            private final int sPos$1;
            private final int ePos$1;

            public final boolean apply(RedisNode node) {
                return this.$outer.org$apache$streampark$common$util$RedisConfig$$inter$1(this.sPos$1, this.ePos$1, node.startSlot(), node.endSlot());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sPos$1 = sPos$1;
                this.ePos$1 = ePos$1;
            }
        })).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$1) {
                return x$1.idx() == 0;
            }
        });
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info = conn.info().split("\n");
        String version2 = ((String[])Predef$.MODULE$.refArrayOps((Object[])info).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.contains("redis_version:");
            }
        }))[0];
        String[] clusterEnable = (String[])Predef$.MODULE$.refArrayOps((Object[])info).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.contains("cluster_enabled:");
            }
        });
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version2.substring(14, version2.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot((String)key);
        return ((RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.hosts()).filter((Function1)new Serializable(this, slot){
            public static final long serialVersionUID = 0L;
            private final int slot$1;

            public final boolean apply(RedisNode host) {
                return host.startSlot() <= this.slot$1 && host.endSlot() >= this.slot$1;
            }
            {
                this.slot$1 = slot$1;
            }
        }))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RedisNode x$4) {
                return x$4.idx() == 0;
            }
        });
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2 master;
        while (true) {
            master = new Tuple2((Object)initialHost.host(), (Object)BoxesRunTime.boxToInteger((int)initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (!Predef$.MODULE$.refArrayOps((Object[])replinfo).exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$5) {
                    return x$5.contains("role:slave");
                }
            })) break;
            String host = ((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$6) {
                    return x$6.contains("master_host:");
                }
            }))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$7) {
                    return x$7.contains("master_port:");
                }
            }))[0].trim().substring(12))).toInt();
            initialHost = new RedisEndpoint(host, port, initialHost.auth(), initialHost.db(), RedisEndpoint$.MODULE$.apply$default$5());
        }
        Tuple2[] slaves = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])replinfo).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x) {
                return x.contains("slave") && x.contains("online");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String rl) {
                String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
                String ip = content[0];
                String port = content[1];
                return new Tuple2((Object)ip.substring(ip.indexOf(61) + 1), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = master;
        Tuple2[] nodes = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])slaves).$plus$colon((Object)tuple2, ClassTag$.MODULE$.apply(Tuple2.class));
        int range = nodes.length;
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).map((Function1)new Serializable(this, initialHost, nodes, range){
            public static final long serialVersionUID = 0L;
            private final RedisEndpoint initialHost$1;
            private final Tuple2[] nodes$1;
            private final int range$1;

            public final RedisNode apply(int i) {
                return new RedisNode(new RedisEndpoint((String)this.nodes$1[i]._1(), this.nodes$1[i]._2$mcI$sp(), this.initialHost$1.auth(), this.initialHost$1.db(), this.initialHost$1.timeout()), 0, 16383, i, this.range$1);
            }
            {
                this.initialHost$1 = initialHost$1;
                this.nodes$1 = nodes$1;
                this.range$1 = range$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(conn.clusterSlots()).flatMap((Function1)new Serializable(this, initialHost){
            public static final long serialVersionUID = 0L;
            public final RedisEndpoint initialHost$2;

            public final IndexedSeq<RedisNode> apply(Object slotInfoObj) {
                List slotInfo = (List)slotInfoObj;
                int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
                int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map((Function1)new Serializable(this, slotInfo, sPos, ePos){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final List slotInfo$1;
                    private final int sPos$2;
                    private final int ePos$2;

                    public final RedisNode apply(int i) {
                        List node = (List)JavaConversions$.MODULE$.asScalaBuffer(this.slotInfo$1).apply(i + 2);
                        String host = SafeEncoder.encode((byte[])((byte[])node.get(0)));
                        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
                        return new RedisNode(new RedisEndpoint(host, port, this.$outer.initialHost$2.auth(), this.$outer.initialHost$2.db(), this.$outer.initialHost$2.timeout()), this.sPos$2, this.ePos$2, i, this.slotInfo$1.size() - 2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.slotInfo$1 = slotInfo$1;
                        this.sPos$2 = sPos$2;
                        this.ePos$2 = ePos$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.initialHost$2 = initialHost$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    public final boolean org$apache$streampark$common$util$RedisConfig$$inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

