/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import org.apache.streampark.common.util.RedisEndpoint;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class RedisClient$
implements Logger {
    public static final RedisClient$ MODULE$;
    private transient ConcurrentHashMap<RedisEndpoint, JedisPool> pools;
    private transient ConcurrentHashMap<RedisEndpoint, JedisCluster> clusters;
    private JedisPoolConfig org$apache$streampark$common$util$RedisClient$$poolConfig;
    private transient org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    static {
        new RedisClient$();
    }

    private ConcurrentHashMap pools$lzycompute() {
        RedisClient$ redisClient$ = this;
        synchronized (redisClient$) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pools = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.pools;
        }
    }

    private ConcurrentHashMap clusters$lzycompute() {
        RedisClient$ redisClient$ = this;
        synchronized (redisClient$) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.clusters = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.clusters;
        }
    }

    /*
     * WARNING - void declaration
     */
    private JedisPoolConfig org$apache$streampark$common$util$RedisClient$$poolConfig$lzycompute() {
        RedisClient$ redisClient$ = this;
        synchronized (redisClient$) {
            if (!this.bitmap$0) {
                void var2_2;
                JedisPoolConfig poolConfig = new JedisPoolConfig();
                poolConfig.setMaxTotal(1000);
                poolConfig.setMaxIdle(64);
                poolConfig.setTestOnBorrow(true);
                poolConfig.setTestOnReturn(false);
                poolConfig.setTestWhileIdle(false);
                poolConfig.setMinEvictableIdleTimeMillis(1800000L);
                poolConfig.setTimeBetweenEvictionRunsMillis(30000L);
                poolConfig.setNumTestsPerEvictionRun(-1);
                this.org$apache$streampark$common$util$RedisClient$$poolConfig = var2_2;
                this.bitmap$0 = true;
            }
            return this.org$apache$streampark$common$util$RedisClient$$poolConfig;
        }
    }

    @Override
    public org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger$class.initializeLogIfNecessary(this, isInterpreter);
    }

    private ConcurrentHashMap<RedisEndpoint, JedisPool> pools() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.pools$lzycompute() : this.pools;
    }

    private ConcurrentHashMap<RedisEndpoint, JedisCluster> clusters() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.clusters$lzycompute() : this.clusters;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Jedis connect(RedisEndpoint[] endpoints) {
        while (true) {
            Predef$.MODULE$.require(endpoints.length > 0, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "[StreamPark] The RedisEndpoint array is empty!!!";
                }
            });
            int index = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % endpoints.length;
            try {
                return this.connect(endpoints[index]);
            }
            catch (Exception exception) {
                void var3_2;
                this.logger().error(exception.getMessage());
                endpoints = (RedisEndpoint[])Predef$.MODULE$.refArrayOps((Object[])endpoints).drop((int)var3_2);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Jedis connect(RedisEndpoint re) {
        pool = (JedisPool)JavaConversions$.MODULE$.mapAsScalaConcurrentMap(this.pools()).getOrElseUpdate((Object)re, (Function0)new Serializable(re){
            public static final long serialVersionUID = 0L;
            private final RedisEndpoint re$1;

            public final JedisPool apply() {
                return RedisClient$.MODULE$.createJedisPool(this.re$1);
            }
            {
                this.re$1 = re$1;
            }
        });
        sleepTime = 4;
        conn = null;
        while (true) {
            if (conn == null) ** GOTO lbl-1000
            return conn;
lbl-1000:
            // 1 sources

            {
                conn = pool.getResource();
                continue;
            }
            break;
        }
    }

    public JedisPool createJedisPool(RedisEndpoint endpoint) {
        String x$1 = ConfigConst$.MODULE$.DEFAULT_DATAMASK_STRING();
        String x$2 = endpoint.copy$default$1();
        int x$3 = endpoint.copy$default$2();
        int x$4 = endpoint.copy$default$4();
        int x$5 = endpoint.copy$default$5();
        RedisEndpoint endpointEn = endpoint.copy(x$2, x$3, x$1, x$4, x$5);
        this.logInfo((Function0<String>)new Serializable(endpointEn){
            public static final long serialVersionUID = 0L;
            private final RedisEndpoint endpointEn$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] RedisClient: createJedisPool with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.endpointEn$1}));
            }
            {
                this.endpointEn$1 = endpointEn$1;
            }
        });
        return new JedisPool((GenericObjectPoolConfig)this.org$apache$streampark$common$util$RedisClient$$poolConfig(), endpoint.host(), endpoint.port(), endpoint.timeout(), endpoint.auth(), endpoint.db());
    }

    public JedisPoolConfig org$apache$streampark$common$util$RedisClient$$poolConfig() {
        return this.bitmap$0 ? this.org$apache$streampark$common$util$RedisClient$$poolConfig : this.org$apache$streampark$common$util$RedisClient$$poolConfig$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public JedisCluster connectCluster(Seq<RedisEndpoint> res) {
        void var3_3;
        Predef$.MODULE$.require(res.nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "[StreamPark] The RedisEndpoint array is empty!!!";
            }
        });
        RedisEndpoint head = (RedisEndpoint)res.head();
        JedisCluster cluster = (JedisCluster)JavaConversions$.MODULE$.mapAsScalaConcurrentMap(this.clusters()).getOrElseUpdate((Object)head, (Function0)new Serializable(res, head){
            public static final long serialVersionUID = 0L;
            private final Seq res$1;
            private final RedisEndpoint head$1;

            public final JedisCluster apply() {
                scala.collection.immutable.Set hostPorts = ((TraversableOnce)this.res$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final HostAndPort apply(RedisEndpoint r) {
                        return new HostAndPort(r.host(), r.port());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                return new JedisCluster(JavaConversions$.MODULE$.setAsJavaSet((Set)hostPorts), this.head$1.timeout(), 1000, 1, this.head$1.auth(), (GenericObjectPoolConfig)RedisClient$.MODULE$.org$apache$streampark$common$util$RedisClient$$poolConfig());
            }
            {
                this.res$1 = res$1;
                this.head$1 = head$1;
            }
        });
        return var3_3;
    }

    public void close() {
        JavaConversions$.MODULE$.mapAsScalaConcurrentMap(this.pools()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<RedisEndpoint, JedisPool> x0$1) {
                Tuple2<RedisEndpoint, JedisPool> tuple2 = x0$1;
                if (tuple2 != null) {
                    JedisPool v = (JedisPool)tuple2._2();
                    v.close();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private RedisClient$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

