/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.thrift.data.ThriftEventBundle;

public final class ThriftEventConverter {
    private static Log log = LogFactory.getLog(ThriftEventConverter.class);

    private ThriftEventConverter() {
    }

    public static ThriftEventBundle toThriftEventBundle(Event event, ThriftEventBundle eventBundle, String sessionId) {
        ThriftEventBundle thriftEventBundle = eventBundle;
        if (thriftEventBundle == null) {
            thriftEventBundle = new ThriftEventBundle();
            thriftEventBundle.setStringAttributeList(new LinkedList());
            thriftEventBundle.setLongAttributeList(new LinkedList());
            thriftEventBundle.setSessionId(sessionId);
            thriftEventBundle.setEventNum(0);
        }
        thriftEventBundle.addToStringAttributeList(event.getStreamId());
        thriftEventBundle.addToLongAttributeList(event.getTimeStamp());
        thriftEventBundle = ThriftEventConverter.assignAttributes(thriftEventBundle, event.getMetaData());
        thriftEventBundle = ThriftEventConverter.assignAttributes(thriftEventBundle, event.getCorrelationData());
        thriftEventBundle = ThriftEventConverter.assignAttributes(thriftEventBundle, event.getPayloadData());
        thriftEventBundle = ThriftEventConverter.assignMap(thriftEventBundle, event.getArbitraryDataMap());
        thriftEventBundle.setEventNum(thriftEventBundle.getEventNum() + 1);
        return thriftEventBundle;
    }

    private static ThriftEventBundle assignAttributes(ThriftEventBundle thriftEventBundle, Object[] attributes) {
        if (attributes != null) {
            for (Object object : attributes) {
                if (object instanceof Integer) {
                    if (!thriftEventBundle.isSetIntAttributeList()) {
                        thriftEventBundle.setIntAttributeList(new LinkedList());
                    }
                    thriftEventBundle.addToIntAttributeList(((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Float) {
                    if (!thriftEventBundle.isSetDoubleAttributeList()) {
                        thriftEventBundle.setDoubleAttributeList(new LinkedList());
                    }
                    thriftEventBundle.addToDoubleAttributeList(((Float)object).doubleValue());
                    continue;
                }
                if (object instanceof Long) {
                    if (!thriftEventBundle.isSetLongAttributeList()) {
                        thriftEventBundle.setLongAttributeList(new LinkedList());
                    }
                    thriftEventBundle.addToLongAttributeList(((Long)object).longValue());
                    continue;
                }
                if (object instanceof String) {
                    if (!thriftEventBundle.isSetStringAttributeList()) {
                        thriftEventBundle.setStringAttributeList(new LinkedList());
                    }
                    thriftEventBundle.addToStringAttributeList((String)object);
                    continue;
                }
                if (object instanceof Boolean) {
                    if (!thriftEventBundle.isSetBoolAttributeList()) {
                        thriftEventBundle.setBoolAttributeList(new LinkedList());
                    }
                    thriftEventBundle.addToBoolAttributeList(((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof Double) {
                    if (!thriftEventBundle.isSetDoubleAttributeList()) {
                        thriftEventBundle.setDoubleAttributeList(new LinkedList());
                    }
                    thriftEventBundle.addToDoubleAttributeList(((Double)object).doubleValue());
                    continue;
                }
                if (object == null) {
                    if (!thriftEventBundle.isSetStringAttributeList()) {
                        thriftEventBundle.setStringAttributeList(new LinkedList());
                    }
                    thriftEventBundle.addToStringAttributeList("_null");
                    continue;
                }
                log.error((Object)("Undefined attribute type : " + object));
            }
        }
        return thriftEventBundle;
    }

    private static ThriftEventBundle assignMap(ThriftEventBundle thriftEventBundle, Map<String, String> arbitraryDataMap) {
        if (null != arbitraryDataMap) {
            if (!thriftEventBundle.isSetArbitraryDataMapMap()) {
                thriftEventBundle.setArbitraryDataMapMap(new HashMap());
            }
            thriftEventBundle.putToArbitraryDataMapMap(thriftEventBundle.getEventNum(), arbitraryDataMap);
        }
        return thriftEventBundle;
    }
}

