/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.session;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ChrootWrapper {
    private static final Log log = LogFactory.getLog(UserRegistry.class);
    protected String basePrefix = null;

    public ChrootWrapper(String basePrefix) {
        if (basePrefix != null) {
            if (basePrefix.equals("/")) {
                basePrefix = null;
            }
            this.basePrefix = basePrefix;
        }
    }

    public String getBasePrefix() {
        return this.basePrefix;
    }

    public String getInPath(String path) {
        if (this.basePrefix == null || this.basePrefix.length() == 0 || path == null) {
            return path;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deriving the absolute path, chroot-base: " + this.basePrefix + ", " + "path: " + path + "."));
        }
        if (path.startsWith("//")) {
            return path.substring(1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.equals("/")) {
            return this.basePrefix;
        }
        return this.basePrefix + path;
    }

    public String getOutPath(String absolutePath) {
        if (this.basePrefix == null || this.basePrefix.length() == 0 || absolutePath == null) {
            return absolutePath;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deriving the relative path, chroot-base: " + this.basePrefix + ", " + "path: " + absolutePath + "."));
        }
        if (absolutePath.startsWith(this.basePrefix + "/")) {
            return absolutePath.substring(this.basePrefix.length());
        }
        if (absolutePath.equals(this.basePrefix)) {
            return "/";
        }
        if (absolutePath.startsWith(this.basePrefix + ";version")) {
            return "/" + absolutePath.substring(this.basePrefix.length());
        }
        return "/" + absolutePath;
    }

    public String[] getOutPaths(String[] absolutePaths) {
        if (this.basePrefix == null || this.basePrefix.length() == 0 || absolutePaths == null || absolutePaths.length == 0) {
            return absolutePaths;
        }
        for (int i = 0; i < absolutePaths.length; ++i) {
            String absolutePath = absolutePaths[i];
            absolutePaths[i] = this.getOutPath(absolutePath);
        }
        return absolutePaths;
    }

    public Resource getOutResource(Resource resource) throws RegistryException {
        String permanentPath;
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return resource;
        }
        String absolutePath = resource.getPath();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deriving the relative resource, chroot-base: " + this.basePrefix + ", " + "resource-absolute-path: " + absolutePath + "."));
        }
        if (resource instanceof CollectionImpl) {
            this.fixCollection((CollectionImpl)resource);
        }
        if (absolutePath != null) {
            String relativePath = this.getOutPath(absolutePath);
            ((ResourceImpl)resource).setPath(relativePath);
        }
        if ((permanentPath = resource.getPermanentPath()) != null) {
            ((ResourceImpl)resource).setMatchingSnapshotID(((ResourceImpl)resource).getMatchingSnapshotID());
        }
        this.fixMountPoints(resource);
        return resource;
    }

    public Collection getOutCollection(Collection collection) throws RegistryException {
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return collection;
        }
        String absolutePath = collection.getPath();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deriving the relative resource, chroot-base: " + this.basePrefix + ", " + "resource-absolute-path: " + absolutePath + "."));
        }
        this.fixCollection((CollectionImpl)collection);
        if (absolutePath != null) {
            String relativePath = this.getOutPath(absolutePath);
            ((ResourceImpl)((Object)collection)).setPath(relativePath);
        }
        this.fixMountPoints(collection);
        return collection;
    }

    public Association[] getOutAssociations(Association[] associations) {
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return associations;
        }
        for (Association association : associations) {
            if (association == null) continue;
            association.setSourcePath(this.getOutPath(association.getSourcePath()));
            if (association.getDestinationPath().matches("^[a-zA-Z]+://.*")) continue;
            association.setDestinationPath(this.getOutPath(association.getDestinationPath()).replace("//", "/"));
        }
        return associations;
    }

    public TaggedResourcePath[] getOutTaggedResourcePaths(TaggedResourcePath[] taggedResourcePaths) {
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return taggedResourcePaths;
        }
        for (TaggedResourcePath trp : taggedResourcePaths) {
            String path = trp.getResourcePath();
            trp.setResourcePath(this.getOutPath(path));
        }
        return taggedResourcePaths;
    }

    public Comment[] getOutComments(Comment[] comments) {
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return comments;
        }
        for (Comment comment : comments) {
            comment.setPath(this.getOutPath(comment.getPath()));
            comment.setResourcePath(this.getOutPath(comment.getResourcePath()));
            comment.setCommentPath(this.getOutPath(comment.getCommentPath()));
        }
        return comments;
    }

    public Collection filterSearchResult(Collection collection) throws RegistryException {
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return collection;
        }
        String[] results = collection.getChildren();
        if (results == null || results.length == 0) {
            return collection;
        }
        ArrayList<String> filteredResult = new ArrayList<String>();
        for (String result : results) {
            if (!result.startsWith(this.basePrefix + "/")) continue;
            filteredResult.add(result);
        }
        String[] filteredResultArr = filteredResult.toArray(new String[filteredResult.size()]);
        collection.setContent(filteredResultArr);
        return collection;
    }

    private void fixCollection(CollectionImpl collection) throws RegistryException {
        block4: {
            Resource[] resources;
            Object content;
            block3: {
                if (this.basePrefix == null || this.basePrefix.length() == 0) {
                    return;
                }
                content = collection.getContent();
                if (!(content instanceof String[])) break block3;
                String[] paths = (String[])content;
                for (int i = 0; i < paths.length; ++i) {
                    paths[i] = this.getOutPath(paths[i]);
                }
                break block4;
            }
            if (!(content instanceof Resource[])) break block4;
            for (Resource resource : resources = (Resource[])content) {
                ((ResourceImpl)resource).setPath(this.getOutPath(resource.getPath()));
                if (!(resource instanceof Comment)) continue;
                Comment comment = (Comment)resource;
                comment.setResourcePath(this.getOutPath(comment.getResourcePath()));
            }
        }
    }

    private void fixMountPoints(Resource resource) {
        String actualPath;
        String targetPoint;
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return;
        }
        String mountPoint = resource.getProperty("registry.mountpoint");
        if (mountPoint != null) {
            resource.setProperty("registry.mountpoint", this.getOutPath(mountPoint));
        }
        if ((targetPoint = resource.getProperty("registry.targetpoint")) != null) {
            resource.setProperty("registry.targetpoint", this.getOutPath(targetPoint));
        }
        if ((actualPath = resource.getProperty("registry.actualpath")) != null) {
            resource.setProperty("registry.actualpath", this.getOutPath(actualPath));
        }
    }

    public LogEntry[] fixLogEntries(LogEntry[] logEntries) {
        if (this.basePrefix == null || this.basePrefix.length() == 0) {
            return logEntries;
        }
        ArrayList<LogEntry> fixedLogEntries = new ArrayList<LogEntry>();
        for (LogEntry logEntry : logEntries) {
            String actionData;
            String[] temp;
            String logPath = logEntry.getResourcePath();
            if (logPath == null || !logPath.startsWith(this.basePrefix + "/") && !logPath.equals(this.basePrefix)) continue;
            logEntry.setResourcePath(this.getOutPath(logPath));
            if (logEntry.getActionData() != null && logEntry.getActionData().startsWith(this.basePrefix)) {
                logEntry.setActionData(this.getOutPath(logEntry.getActionData()));
            } else if ((logEntry.getAction() == 15 || logEntry.getAction() == 16) && (temp = (actionData = logEntry.getActionData()).split(";")).length == 2 && temp[1].startsWith(this.basePrefix)) {
                logEntry.setActionData(temp[0] + ";" + this.getOutPath(temp[1]));
            }
            fixedLogEntries.add(logEntry);
        }
        return fixedLogEntries.toArray(new LogEntry[fixedLogEntries.size()]);
    }
}

